using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.FileSystem;
using System.Windows.Forms;
using System.Collections;
using System.Drawing;
using SCFiler2.Util;
using SCFiler2.ItemInterface;

namespace SCFiler2.ListViewControl {
	/// <summary>
	/// VirtualModeListView߂́AListViewItem̂
	/// </summary>
	public sealed class VirtualListViewItem {
		private FilerItem targetItem;
		private ListViewItem viewItem;
		private VirtualListView parentView;
		private string text;
		private object tag;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="fierItem">̃ACeɊ֘AtACeFullName</param>
		public VirtualListViewItem(FilerItem filerItem) {
			this.targetItem = filerItem;
			this.tag = filerItem;
			text = filerItem.NameWithoutExtension;
		}

		/// <summary>
		/// ACeɃr[֘AÂBr[Items.AddƏɌĂяôŃ[U[IɌĂяoKv͂Ȃ
		/// </summary>
		/// <param name="focusedView">ItemێĂr[</param>
		public void AssignVirtualListView(VirtualListView view) {
			this.parentView = view;
		}

		/// <summary>
		/// ̃ACeɑΉListViewItem
		/// </summary>
		public ListViewItem Item {
			get {
				//͂߂ČĂ΂ꂽɐ悤ɂ
				if (viewItem == null) {
					createListViewItem();
				}
				return this.viewItem;
			}
		}

		/// <summary>
		/// ̃ACeɑΉFilerItem
		/// </summary>
		public FilerItem FilerItem {
			get { return this.targetItem; }
		}

		/// <summary>
		/// ̃ACȇI
		/// </summary>
		public bool Selected {
			set {
				if (value == true) {
					if (this.parentView.AssignedListView.SelectedIndices.Contains(this.Index)) {
						//Ȃ
					} else {
						this.parentView.AssignedListView.SelectedIndices.Add(this.Index);
					}
				} else {
					if (this.parentView.AssignedListView.SelectedIndices.Contains(this.Index)) {
						this.parentView.AssignedListView.SelectedIndices.Remove(this.Index);
					} else {
						//Ȃ
					}
				}
			}

			get {
					return this.parentView.SelectedItems.Contains(this);
			}
		}

		/// <summary>
		/// ̃ACeɃtH[JX邩ǂ
		/// </summary>
		public bool Focused {
			set {
				this.parentView.AssignedListView.Items[this.Index].Focused = value;
			}

			get {
				return this.parentView.AssignedListView.Items[this.Index].Focused;
			}
		}

		/// <summary>
		/// ̃ACe\
		/// </summary>
		public string Text {
			get { return text; }
			set {
				if (this.viewItem != null) {
					this.viewItem.Text = value;
				}
				this.text = value;
			}
		}

		/// <summary>
		/// ̃ACeɊ֘AÂĂIuWFNg
		/// </summary>
		public object Tag {
			get { return this.tag; }
			set {
				if (this.viewItem != null) {
					this.viewItem.Tag = value;
				}
				this.tag = value;
			}
		}

		/// <summary>
		/// ̃ACeIndex
		/// </summary>
		public int Index {
			get { return this.parentView.Items.IndexOf(this); }
		}

		/// <summary>
		/// ̃ACe\̈ɕ\悤ɃXN[
		/// </summary>
		public void EnsureVisible() {
			this.parentView.EnsureVisible(this.Index);
		}

		private int smallImageIndex = -1;
		private bool isSmallImageLoaded = false; 
		public int SmallImageIndex {
			get { return smallImageIndex; }
		}

		private int largeImageIndex = -1;
		private bool isLargeImageLoaded = false;
		public int LargeImageIndex {
			get { return largeImageIndex;}
		}

		public enum ImageSize {
			Icon,
			Large
		}

		private ImageSize imageMode = ImageSize.Icon;
		public ImageSize ImageMode {
			get { return imageMode; }
			set {
				if (this.imageMode == value) {
					return;
				}
				this.imageMode = value;
				if (this.viewItem == null) {
					//ListViewItem^C~Oœǂݍނ̂ŁAł͉Ȃ
					return;
				}
				switch (value) {
					case ImageSize.Icon:
						if (!isSmallImageLoaded) {
							loadSmallImage();
						}
						this.Item.ImageIndex = smallImageIndex;
						break;
					case ImageSize.Large:
						if (!isLargeImageLoaded) {
							loadLargeImage();
						}
						this.Item.ImageIndex = largeImageIndex;
						break;
				}
			}
		}

		/// <summary>
		/// VirtualListViewItem\ListViewItem𐶐
		/// </summary>
		/// <returns>ꂽCX^X</returns>
		private void createListViewItem() {
			//炩viewItemɃCX^Xݒ肵ĂȂƁASelecteďĂяocreateListViewItem()̏zĂяoN
			this.viewItem = new ListViewItem(this.targetItem.NameWithoutExtension);//O

			switch (this.targetItem.Type) {
				case ItemType.Folder:
					this.viewItem.SubItems.Add("<dir>");//gq
					break;
				case ItemType.File:
					this.viewItem.SubItems.Add(this.targetItem.Extension);
					break;
				case ItemType.Drive:
					this.viewItem.SubItems.Add("");
					break;
			}

			switch (this.imageMode) {
				case ImageSize.Icon:
					loadSmallImage();
					this.viewItem.ImageIndex = this.smallImageIndex;
					break;
				case ImageSize.Large:
					loadLargeImage();
					this.viewItem.ImageIndex = this.largeImageIndex;
					break;
			}

			this.viewItem.SubItems.Add(this.targetItem.SizeDisplayString);//TCY
			this.viewItem.SubItems.Add(this.targetItem.UpdateDateString);//XV
			this.viewItem.Tag = this.targetItem;
			this.viewItem.Selected = this.Selected;
		}

		private void loadLargeImage() {
			Image image = this.FilerItem.ThumnailImage;
			if (image != null) {
				this.parentView.AssignedListView.LargeImageList.Images.Add(image);
				this.largeImageIndex = this.parentView.AssignedListView.LargeImageList.Images.Count - 1;
			}
			this.isLargeImageLoaded = true;
		}

		private void loadSmallImage() {
			switch (this.FilerItem.Type) {
				case ItemType.File:
					//ACR̕\
					if (SCFiler2System.Instance.Option.FileView.IconDisplay == SCFiler2System.OptionClass.FileViewOption.FileIconDisp.Nothing) {
						//\Ȃ
						this.smallImageIndex = -1;
					} else if (SCFiler2System.Instance.Option.FileView.IconDisplay == SCFiler2System.OptionClass.FileViewOption.FileIconDisp.All) {
						this.smallImageIndex = this.parentView.RegistSmallImage(targetItem);
					} else if (SCFiler2System.Instance.Option.FileView.IconDisplay == SCFiler2System.OptionClass.FileViewOption.FileIconDisp.ExeOnly && targetItem.Extension.ToUpper() == ".EXE") {
						this.smallImageIndex = this.parentView.RegistSmallImage(targetItem);
					}
					break;
				case ItemType.Folder:
					this.smallImageIndex = 0; //tH_0g
					break;
				case ItemType.Drive:
					Drive drive = (Drive)targetItem;
					switch (drive.DriveType) {
						case System.IO.DriveType.Fixed:
							this.smallImageIndex = (int)VirtualListView.IconListIndex.Hdd;
							break;
						case System.IO.DriveType.CDRom:
							this.smallImageIndex = (int)VirtualListView.IconListIndex.CDROM;
							break;
						case System.IO.DriveType.Removable:
							this.smallImageIndex = (int)VirtualListView.IconListIndex.Removable;
							break;
						case System.IO.DriveType.Network:
							this.smallImageIndex = (int)VirtualListView.IconListIndex.NetworkDrive;
							break;
						default:
							this.smallImageIndex = (int)VirtualListView.IconListIndex.Hdd;
							break;
					}
					break;
			}
			this.isSmallImageLoaded = true;
		}

		public override bool Equals(object obj) {
			if (obj == null || obj.GetType() != this.GetType()) {
				return false;
			} else {
				return this.FilerItem.FullName == ((VirtualListViewItem)obj).FilerItem.FullName;
			}
		}

		public override int GetHashCode() {
			return this.FilerItem.FullName.GetHashCode();
		}
	}
}
