/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed.gui;

import java.awt.BorderLayout;
import java.util.Vector;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

class SedOutputDialog extends JDialog {

	//
	JTable tb1;
	DefaultTableModel tm1;
	boolean dirty;

	SedOutputDialog(JFrame parent) {
		super(parent, "output");
		tb1 = new JTable();
		setLayout(new BorderLayout());
		add(tb1.getTableHeader(), BorderLayout.NORTH);
		add(new JScrollPane(tb1), BorderLayout.CENTER);
		setSize(700, 400);
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	void inittable() {
		Vector v01 = new Vector();

		v01.add("Path");
		v01.add("Line No.");
		v01.add("Line");
		tm1 = new DefaultTableModel(v01, 0);
		tb1.setModel(tm1);
		tb1.getColumnModel().getColumn(0).setPreferredWidth(200);
		tb1.getColumnModel().getColumn(1).setMaxWidth(60);
		dirty = false;
	}

	void putLine(String path, long lineno, String line) {
		tm1.addRow(new Object[] { path, lineno, line });
		dirty = true;
	}

	public void showDialog() {
		setVisible(dirty);
	}

}
