/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import junit.framework.TestCase;
import org.openqa.selenium.server.SeleniumServer;

public class SeleniumServerUnitTest
extends TestCase {
    private int positiveJettyThreads = 512;
    private int negativeJettyThreadsMaximum = 1025;
    private int negativeJettyThreadsMinimum = 0;
    private SeleniumServer server;

    public void tearDown() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void testJettyThreadsPositive() throws Exception {
        SeleniumServer.setJettyThreads((int)this.positiveJettyThreads);
        this.server = new SeleniumServer();
        this.server.start();
        SeleniumServerUnitTest.assertEquals((String)"Jetty threads given is not correct.", (int)this.positiveJettyThreads, (int)SeleniumServer.getJettyThreads());
    }

    public void testJettyThreadsNegativeMaximum() throws Exception {
        int expectedJettyThreads = SeleniumServer.getJettyThreads();
        try {
            SeleniumServer.setJettyThreads((int)this.negativeJettyThreadsMaximum);
            SeleniumServerUnitTest.fail((String)"Error not caught when an illegal argument was passed to setJettyThreads");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.server = new SeleniumServer();
        this.server.start();
        SeleniumServerUnitTest.assertEquals((String)"Server did not start up correctly.", (int)expectedJettyThreads, (int)SeleniumServer.getJettyThreads());
    }

    public void testJettyThreadsNegativeZero() throws Exception {
        int expectedJettyThreads = SeleniumServer.getJettyThreads();
        try {
            SeleniumServer.setJettyThreads((int)this.negativeJettyThreadsMinimum);
            SeleniumServerUnitTest.fail((String)"Error not caught when an illegal argument was passed to setJettyThreads");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.server = new SeleniumServer();
        this.server.start();
        SeleniumServerUnitTest.assertEquals((String)"Server did not start up correctly.", (int)expectedJettyThreads, (int)SeleniumServer.getJettyThreads());
    }
}

