# -*- coding: utf-8 -*-
#
# Copyright (C)2005-2009 Edgewall Software
# Copyright (C) 2005 Christopher Lenz <cmlenz@gmx.de>
# All rights reserved.
#
# This software is licensed as described in the file COPYING, which
# you should have received as part of this distribution. The terms
# are also available at http://trac.edgewall.org/wiki/TracLicense.
#
# This software consists of voluntary contributions made by many
# individuals. For the exact contribution history, see the revision
# history and logs, available at http://trac.edgewall.org/log/.
#
# Author: Takahsi Okamoto

from trac.core import TracError
from trac.util.html import Markup, Fragment, escape

class HDFWrapper:
    """ Fake HDFWrapper to remove clearsilver dependency.
        TODO: This Class should be removed after resolve replace HDFWrapper 
              to something.
    """
    has_clearsilver = None
    
    def __init__(self, loadpaths=[]):
        self.hdf = {}
        self.has_clearsilver = False
        self['hdf.loadpaths'] = loadpaths

    def __repr__(self):
        return '<HDFWrapper 0x%x>' % id(self)

    def __nonzero__(self):
        return self.has_clearsilver

    def __getattr__(self, name):
        # For backwards compatibility, expose the interface of the underlying HDF
        # object
        if self.has_clearsilver:
            return getattr(self.hdf, name)
        else:
            return None

    def __contains__(self, name):
        return self.hdf.getObj(str(name)) != None
    has_key = __contains__

    def get(self, name, default=None):
        return self.hdf[name]

    def __getitem__(self, name):
        value = self.get(name, None)
        if value == None:
            raise KeyError, name
        return value

    def __setitem__(self, name, value):
        self.set_value(name, value, True)
        
    def set_unescaped(self, name, value):
        """
        Add data to the HDF dataset.
        
        This method works the same way as `__setitem__` except that `value`
        is not escaped if it is a string.
        """
        self.set_value(name, value, False)
        
    def set_value(self, name, value, do_escape=True):
        self.hdf[name] = value

    def __str__(self):
        from StringIO import StringIO
        buf = StringIO()
        def hdf_tree_walk(node, prefix=''):
            while node:
                name = node.name() or ''
                buf.write('%s%s' % (prefix, name))
                value = node.value()
                if value or not node.child():
                    if value.find('\n') == -1:
                        buf.write(' = %s' % value)
                    else:
                        buf.write(' = << EOM\n%s\nEOM' % value)
                if node.child():
                    buf.write(' {\n')
                    hdf_tree_walk(node.child(), prefix + '  ')
                    buf.write('%s}\n' % prefix)
                else:
                    buf.write('\n')
                node = node.next()
        hdf_tree_walk(self.hdf.child())
        return buf.getvalue().strip()

    def parse(self, string):
        """Parse the given string as template text, and returns a neo_cs.CS
        object.
        """
        return None

    def render(self, template, form_token=None):
        return None

