<?php

/*
*	Plugin for dTree javascript library by Geir Landrö
*	http://www.destroydrop.com/javascripts/tree/api/
*
*	You need to download and install the javascript library before
*	using this plugin
*/

class cpm_dtree {

var $treeTitle = "";
var $cpmFetch;
var $baseUrl;

function cpm_dtree (&$objCpm,$treeTitle = "") {
	$this->cpmFetch = $objCpm;
	$this->cpmFetch->cpm_setReturnType("resultSet");

	if ($treeTitle == "") {
		$this->treeTitle = $objCpm->cpm_getConfigEntry('gallery_name');
	}

	$this->baseUrl = $objCpm->cpm_getConfigEntry('cpg_url');
}


function getHeaderContent( ) {

	$OA = array();

	$results = $this->cpmFetch->cpm_getCategoryList();
	$albums = $this->cpmFetch->cpm_getAlbumListFrom("",1000,1000);

$code = '
<!-- Generated by CpmFetch:Dtree -->
<script type="text/javascript">
<!--

cpmfetchdtree = new dTree("cpmfetchdtree");
cpmfetchdtree.config.inOrder = "true";
';

	$code .= "cpmfetchdtree.add(0,-1,'{$this->treeTitle}');\n";

	foreach ($results as $row) {
		if (! array_key_exists($row['cCid'],$OA)) {
			$OA[$row['cCid']] = 1;

			$title = htmlspecialchars($row['cName'],ENT_QUOTES);

			$code .= $this->dtree_addline($row['cCid'],$row['cParent'],$title,"{$this->baseUrl}/index.php?cat={$row['cCid']}");
		}
	}

	foreach ($albums as $row) {
		$id = $row['aAid'] + 10000;
		$pid = $row['aCategory'];
		$title = htmlspecialchars($row['aTitle'],ENT_QUOTES);
		$link = "{$this->baseUrl}/thumbnails.php?album={$row['aAid']}";
		$code .= $this->dtree_addline($id,$pid,$title,$link);
	}

$code .= '
//-->
</script>
';

	return ($code);
}


function getTree( ) {
$code = '
<script type="text/javascript">
<!--
document.write(cpmfetchdtree);
//-->
</script>
';
return ($code);
}


function dtree_addline($id,$pid,$title,$link) {
	return("cpmfetchdtree.add({$id},{$pid},'{$title}','{$link}');\n");
}

} // END OF CLASS


?>

