/*
 * Decompiled with CFR 0.152.
 */
package jcmdline;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import jcmdline.AbstractParameter;
import jcmdline.CmdLineException;
import jcmdline.Strings;

public class TimeParam
extends AbstractParameter {
    private static final String sTimeFmt = "HH:mm:ss:SSS";
    private static final String sTimeFmtDisplay = "HH:mm[:ss[:SSS]]";
    private static final DecimalFormat secondFmt = new DecimalFormat("00");
    private static final DecimalFormat msFmt = new DecimalFormat("000");
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final long MILLIS_PER_HOUR = 3600000L;
    private static final long MILLIS_PER_DAY = 86400000L;
    private int defaultSeconds = 0;
    private int defaultMilliSeconds = 0;
    private String[] acceptableTimes = null;

    public TimeParam(String tag, String desc) {
        this(tag, desc, true, false, false);
    }

    public TimeParam(String tag, String desc, boolean optional) {
        this(tag, desc, optional, false, false);
    }

    public TimeParam(String tag, String desc, boolean optional, boolean multiValued) {
        this(tag, desc, optional, multiValued, false);
    }

    public TimeParam(String tag, String desc, boolean optional, boolean multiValued, boolean hidden) {
        this.setTag(tag);
        this.setDesc(desc);
        this.setOptional(optional);
        this.setMultiValued(multiValued);
        this.setHidden(hidden);
        this.setOptionLabel(sTimeFmtDisplay);
    }

    public TimeParam(String tag, String desc, String[] acceptableValues) {
        this(tag, desc, acceptableValues, true, false, false);
    }

    public TimeParam(String tag, String desc, String[] acceptableValues, boolean optional) {
        this(tag, desc, acceptableValues, optional, false, false);
    }

    public TimeParam(String tag, String desc, String[] acceptableValues, boolean optional, boolean multiValued) {
        this(tag, desc, acceptableValues, optional, multiValued, false);
    }

    public TimeParam(String tag, String desc, String[] acceptableValues, boolean optional, boolean multiValued, boolean hidden) {
        this.setTag(tag);
        this.setAcceptableValues(acceptableValues);
        this.setDesc(desc);
        this.setOptional(optional);
        this.setMultiValued(multiValued);
        this.setHidden(hidden);
        this.setOptionLabel(sTimeFmtDisplay);
    }

    public void validateValue(String val) throws CmdLineException {
        super.validateValue(val);
        String fullval = this.fullTime(val);
        if (this.acceptableTimes != null) {
            for (int i = 0; i < this.acceptableTimes.length; ++i) {
                if (!fullval.equals(this.fullTime(this.acceptableTimes[i]))) continue;
                return;
            }
            int maxExpectedAVLen = 200;
            StringBuffer b = new StringBuffer(maxExpectedAVLen);
            for (int i = 0; i < this.acceptableTimes.length; ++i) {
                b.append("\n   " + this.acceptableTimes[i]);
            }
            throw new CmdLineException(Strings.get("Parameter.valNotAcceptableVal", new Object[]{val, this.tag, b.toString()}));
        }
        try {
            if (fullval.length() > 12) {
                throw new Exception();
            }
            int n = Integer.parseInt(fullval.substring(0, 2));
            if (n < 0 || n > 23) {
                throw new Exception();
            }
            n = Integer.parseInt(fullval.substring(3, 5));
            if (n < 0 || n > 59) {
                throw new Exception();
            }
            n = Integer.parseInt(fullval.substring(6, 8));
            if (n < 0 || n > 59) {
                throw new Exception();
            }
            n = Integer.parseInt(fullval.substring(9, 12));
            if (n < 0 || n > 999) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new CmdLineException(Strings.get("TimeParam.invalidTimeFormat", new Object[]{val, sTimeFmtDisplay}));
        }
    }

    public Date getDate(Date datePortion) {
        Date ret;
        SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yy");
        String sDate = fmt.format(datePortion);
        try {
            fmt = new SimpleDateFormat("MM/dd/yy HH:mm:ss:SSS");
            ret = fmt.parse(sDate + " " + this.fullTime(this.getValue()));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public Date[] getDates(Date datePortion) {
        SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yy");
        String sDate = fmt.format(datePortion);
        Collection vals = this.getValues();
        Date[] ret = new Date[vals.size()];
        fmt = new SimpleDateFormat("MM/dd/yy HH:mm:ss:SSS");
        int i = 0;
        Iterator itr = vals.iterator();
        while (itr.hasNext()) {
            try {
                ret[i] = fmt.parse(sDate + " " + this.fullTime((String)itr.next()));
                ++i;
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return ret;
    }

    public long getMilliValue() {
        long ret;
        String val = this.fullTime(this.getValue());
        try {
            ret = this.calculateMillis(val);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public long[] getMilliValues() {
        Collection vals = this.getValues();
        long[] ret = new long[vals.size()];
        int i = 0;
        Iterator itr = vals.iterator();
        while (itr.hasNext()) {
            String val = this.fullTime((String)itr.next());
            try {
                ret[i] = this.calculateMillis(val);
                ++i;
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(e);
            }
        }
        return ret;
    }

    private long calculateMillis(String val) throws NumberFormatException {
        return Long.parseLong(val.substring(0, 2)) * 3600000L + Long.parseLong(val.substring(3, 5)) * 60000L + Long.parseLong(val.substring(6, 8)) * 1000L + Long.parseLong(val.substring(9, 12));
    }

    public String getFullValue() {
        return this.fullTime(this.getValue());
    }

    public String[] getFullValues() {
        Collection vals = this.getValues();
        String[] ret = new String[vals.size()];
        int i = 0;
        Iterator itr = vals.iterator();
        while (itr.hasNext()) {
            ret[i] = this.fullTime((String)itr.next());
        }
        return ret;
    }

    public void setDefaultSeconds(int defaultSeconds) {
        if (defaultSeconds < 0 || defaultSeconds > 59) {
            throw new IllegalArgumentException(Strings.get("TimeParam.invalidSeconds", new Object[]{new Integer(defaultSeconds)}));
        }
        this.defaultSeconds = defaultSeconds;
    }

    public int getDefaultSeconds() {
        return this.defaultSeconds;
    }

    public void setDefaultMilliSeconds(int defaultMilliSeconds) {
        if (defaultMilliSeconds < 0 || defaultMilliSeconds > 999) {
            throw new IllegalArgumentException(Strings.get("TimeParam.invalidMilliSeconds", new Object[]{new Integer(defaultMilliSeconds)}));
        }
        this.defaultMilliSeconds = defaultMilliSeconds;
    }

    public int getDefaultMilliSeconds() {
        return this.defaultMilliSeconds;
    }

    public void setAcceptableValues(Collection vals) {
        if (vals == null || vals.size() == 0) {
            this.acceptableTimes = null;
        } else {
            this.acceptableTimes = new String[vals.size()];
            int i = 0;
            Iterator itr = vals.iterator();
            while (itr.hasNext()) {
                this.acceptableTimes[i] = itr.next().toString();
                ++i;
            }
        }
    }

    public void setAcceptableValues(String[] vals) {
        this.acceptableTimes = vals == null || vals.length == 0 ? null : vals;
    }

    public String[] getAcceptableValues() {
        return this.acceptableTimes;
    }

    private String fullTime(String val) {
        if (val.length() == 5) {
            val = val + ":" + secondFmt.format(this.defaultSeconds);
        }
        if (val.length() == 8) {
            val = val + ":" + msFmt.format(this.defaultMilliSeconds);
        }
        return val;
    }
}

