/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.JRVirtualizationHelper;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplatePrintElement;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.util.ObjectIOHelperBase;

public class JRVirtualPrintPage
implements JRPrintPage,
JRVirtualizable,
Serializable {
    private static final long serialVersionUID = 10200L;
    private static final Random random = new Random(System.currentTimeMillis());
    private static short counter = 1;
    protected List elements = new ArrayList();
    private String uid;
    private transient JRVirtualizer virtualizer;
    private transient IdentityDataProvider[] identityProviders;
    private JRVirtualizationContext virtualizationContext;

    public JRVirtualPrintPage(JasperPrint printObject, JRVirtualizer virtualizer, JRVirtualizationContext virtualizationContext) {
        this.uid = JRVirtualPrintPage.makeUID(printObject);
        this.virtualizer = virtualizer;
        this.identityProviders = null;
        if (virtualizer != null) {
            virtualizer.registerObject(this);
        }
        this.virtualizationContext = virtualizationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeUID(JasperPrint printObject) {
        Random random = JRVirtualPrintPage.random;
        synchronized (random) {
            short s = counter;
            counter = (short)(s + 1);
            return Integer.toString(System.identityHashCode(printObject)) + "_" + printObject.getPages().size() + "_" + Integer.toString(s) + "_" + Integer.toString(JRVirtualPrintPage.random.nextInt());
        }
    }

    public final String getUID() {
        return this.uid;
    }

    public void setVirtualData(Object o) {
        this.elements = (List)o;
    }

    public Object getVirtualData() {
        return this.elements;
    }

    public void removeVirtualData() {
        this.elements = null;
    }

    public void setIdentityData(Object o) {
        if (this.identityProviders != null) {
            for (int i = 0; i < this.identityProviders.length; ++i) {
                this.identityProviders[i].setIdentityData(this, (ObjectIDPair[])o);
            }
        }
    }

    public Object getIdentityData() {
        ObjectIDPair[] data;
        if (this.identityProviders != null) {
            if (this.identityProviders.length == 1) {
                data = this.identityProviders[0].getIdentityData(this);
            } else if (this.identityProviders.length > 1) {
                HashSet<ObjectIDPair> list = new HashSet<ObjectIDPair>();
                for (int i = 0; i < this.identityProviders.length; ++i) {
                    ObjectIDPair[] pairs = this.identityProviders[i].getIdentityData(this);
                    if (pairs == null) continue;
                    for (int j = 0; j < pairs.length; ++j) {
                        list.add(pairs[j]);
                    }
                }
                data = list.toArray(new ObjectIDPair[list.size()]);
            } else {
                data = null;
            }
        } else {
            data = null;
        }
        return data;
    }

    public boolean isVirtualized() {
        return this.elements == null;
    }

    public void setVirtualizer(JRVirtualizer virtualizer) {
        this.virtualizer = virtualizer;
    }

    public JRVirtualizer getVirtualizer() {
        return this.virtualizer;
    }

    public void addIdentityDataProvider(IdentityDataProvider p) {
        if (this.identityProviders == null) {
            this.identityProviders = new IdentityDataProvider[]{p};
        } else {
            IdentityDataProvider[] newList = new IdentityDataProvider[this.identityProviders.length + 1];
            System.arraycopy(this.identityProviders, 0, newList, 0, this.identityProviders.length);
            newList[this.identityProviders.length] = p;
            this.identityProviders = newList;
        }
    }

    public void removeIdentityDataProvider(IdentityDataProvider p) {
        if (this.identityProviders != null) {
            for (int idx = 0; idx < this.identityProviders.length; ++idx) {
                if (this.identityProviders[idx] != p) continue;
                IdentityDataProvider[] newList = new IdentityDataProvider[this.identityProviders.length - 1];
                System.arraycopy(this.identityProviders, 0, newList, 0, idx);
                int remaining = this.identityProviders.length - idx - 1;
                if (remaining > 0) {
                    System.arraycopy(this.identityProviders, idx + 1, newList, idx, remaining);
                }
                this.identityProviders = newList;
                break;
            }
        }
    }

    public List getElements() {
        this.ensureVirtualData();
        return this.elements;
    }

    protected void ensureVirtualData() {
        if (this.virtualizer != null) {
            if (this.isVirtualized()) {
                this.virtualizer.requestData(this);
            } else {
                this.virtualizer.touch(this);
            }
        }
    }

    public void setElements(List elements) {
        this.cleanVirtualData();
        this.elements = elements;
    }

    protected void cleanVirtualData() {
        if (this.virtualizer != null) {
            if (this.isVirtualized()) {
                this.virtualizer.clearData(this);
            } else {
                this.virtualizer.touch(this);
            }
        }
    }

    public void addElement(JRPrintElement element) {
        this.ensureVirtualData();
        this.elements.add(element);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.uid = (String)in.readObject();
        this.virtualizationContext = (JRVirtualizationContext)in.readObject();
        byte[] buffer = (byte[])ObjectIOHelperBase.getInstance().readUnshared(in);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer, 0, buffer.length);
        ObjectInputStream elementsStream = new ObjectInputStream(inputStream);
        this.elements = (List)elementsStream.readObject();
        this.afterInternalization();
        this.setThreadVirtualizer();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.ensureVirtualData();
        this.beforeExternalization();
        out.writeObject(this.uid);
        out.writeObject(this.virtualizationContext);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream stream = new ObjectOutputStream(bout);
        stream.writeObject(this.elements);
        stream.flush();
        byte[] bytes = bout.toByteArray();
        ObjectIOHelperBase.getInstance().writeUnshared(out, bytes);
    }

    private void setThreadVirtualizer() {
        JRVirtualizer threadVirtualizer = JRVirtualizationHelper.getThreadVirtualizer();
        if (threadVirtualizer != null) {
            this.virtualizer = threadVirtualizer;
            this.virtualizer.registerObject(this);
        }
    }

    protected void finalize() {
        if (this.virtualizer != null) {
            this.virtualizer.deregisterObject(this);
        }
    }

    protected List getDeepElements() {
        ArrayList deepElements = new ArrayList(this.elements.size());
        this.collectDeepElements(this.elements, deepElements);
        return deepElements;
    }

    protected void collectDeepElements(List elementsList, List deepElements) {
        Iterator it = elementsList.iterator();
        while (it.hasNext()) {
            JRPrintElement element = (JRPrintElement)it.next();
            deepElements.add(element);
            if (!(element instanceof JRPrintFrame)) continue;
            JRPrintFrame frame = (JRPrintFrame)element;
            this.collectDeepElements(frame.getElements(), deepElements);
        }
    }

    public void beforeExternalization() {
        List elems = this.getDeepElements();
        HashMap<String, JRIdHolderTemplateElement> idTemplates = new HashMap<String, JRIdHolderTemplateElement>();
        Iterator it = elems.iterator();
        while (it.hasNext()) {
            JRPrintImage image;
            JRRenderable renderer;
            JRTemplatePrintElement templateElement;
            JRTemplateElement template;
            JRPrintElement element = (JRPrintElement)it.next();
            if (element instanceof JRTemplatePrintElement && (template = (templateElement = (JRTemplatePrintElement)element).getTemplate()) != null) {
                this.virtualizationContext.cacheTemplate(template);
                String templateId = template.getId();
                JRIdHolderTemplateElement idTemplate = (JRIdHolderTemplateElement)idTemplates.get(templateId);
                if (idTemplate == null) {
                    idTemplate = new JRIdHolderTemplateElement(templateId);
                    idTemplates.put(templateId, idTemplate);
                }
                templateElement.setTemplate(idTemplate);
            }
            if (!(element instanceof JRPrintImage) || (renderer = (image = (JRPrintImage)element).getRenderer()) == null || !this.virtualizationContext.hasCachedRenderer(renderer.getId())) continue;
            image.setRenderer(new JRIdHolderRenderer(renderer));
        }
    }

    public void afterInternalization() {
        List elems = this.getDeepElements();
        Iterator iter = elems.iterator();
        while (iter.hasNext()) {
            JRPrintImage image;
            JRRenderable renderer;
            JRTemplatePrintElement templateElement;
            JRTemplateElement template;
            JRPrintElement element = (JRPrintElement)iter.next();
            if (element instanceof JRTemplatePrintElement && (template = (templateElement = (JRTemplatePrintElement)element).getTemplate()) != null) {
                if (!(template instanceof JRIdHolderTemplateElement)) {
                    throw new JRRuntimeException("Virtualization error.");
                }
                JRTemplateElement cachedTemplate = this.virtualizationContext.getCachedTemplate(template.getId());
                if (cachedTemplate == null) {
                    throw new JRRuntimeException("Template " + template.getId() + " not found in virtualization context.");
                }
                templateElement.setTemplate(cachedTemplate);
            }
            if (!(element instanceof JRPrintImage) || (renderer = (image = (JRPrintImage)element).getRenderer()) == null || !(renderer instanceof JRIdHolderRenderer)) continue;
            JRRenderable cachedRenderer = this.virtualizationContext.getCachedRenderer(renderer.getId());
            if (cachedRenderer == null) {
                throw new JRRuntimeException("Renderer " + renderer.getId() + " not found in virtualization context.");
            }
            image.setRenderer(cachedRenderer);
        }
    }

    protected static class JRIdHolderTemplateElement
    extends JRTemplateElement {
        private static final long serialVersionUID = 10200L;

        protected JRIdHolderTemplateElement(String id) {
            super(id);
        }
    }

    protected static class JRIdHolderRenderer
    implements JRRenderable,
    Serializable {
        private static final long serialVersionUID = 10200L;
        protected final String id;

        protected JRIdHolderRenderer(JRRenderable renderer) {
            this.id = renderer.getId();
        }

        public String getId() {
            return this.id;
        }

        public byte getType() {
            return 0;
        }

        public byte getImageType() {
            return 0;
        }

        public Dimension2D getDimension() throws JRException {
            return null;
        }

        public byte[] getImageData() throws JRException {
            return null;
        }

        public void render(Graphics2D grx, Rectangle2D rectanle) throws JRException {
        }
    }

    public static interface IdentityDataProvider {
        public ObjectIDPair[] getIdentityData(JRVirtualPrintPage var1);

        public void setIdentityData(JRVirtualPrintPage var1, ObjectIDPair[] var2);
    }

    public static class ObjectIDPair
    implements Serializable {
        private static final long serialVersionUID = 10200L;
        private final Object o;
        private final int id;

        public ObjectIDPair(Object o) {
            this.o = o;
            this.id = System.identityHashCode(o);
        }

        public Object getObject() {
            return this.o;
        }

        public int getIdentity() {
            return this.id;
        }
    }
}

