/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Vector;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRuntimeException;

public class JRCsvDataSource
implements JRDataSource {
    private DateFormat dateFormat = new SimpleDateFormat();
    private char fieldDelimiter = (char)44;
    private String recordDelimiter = "\n";
    private HashMap columnNames = new HashMap();
    private boolean useFirstRowAsHeader;
    private Vector fields;
    private Reader reader;
    private char[] buffer = new char[1024];
    private int position;
    private int bufSize;
    private boolean processingStarted;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;

    public JRCsvDataSource(InputStream stream) {
        this(new InputStreamReader(stream));
    }

    public JRCsvDataSource(File file) throws FileNotFoundException {
        this(new FileReader(file));
    }

    public JRCsvDataSource(Reader reader) {
        this.reader = reader;
    }

    public boolean next() throws JRException {
        try {
            if (!this.processingStarted) {
                if (this.useFirstRowAsHeader) {
                    this.parseRow();
                    for (int i = 0; i < this.fields.size(); ++i) {
                        String name = (String)this.fields.get(i);
                        this.columnNames.put(name, new Integer(i));
                    }
                }
                this.processingStarted = true;
            }
            return this.parseRow();
        }
        catch (IOException e) {
            throw new JRException(e);
        }
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        String fieldName = jrField.getName();
        Integer columnIndex = (Integer)this.columnNames.get(fieldName);
        if (columnIndex == null && fieldName.startsWith("COLUMN_")) {
            columnIndex = Integer.getInteger(fieldName.substring(7));
        }
        if (columnIndex == null) {
            throw new JRException("Unknown column name : " + fieldName);
        }
        if (this.fields.size() > columnIndex) {
            Class valueClass;
            String fieldValue = (String)this.fields.get(columnIndex);
            if ((class$java$lang$Number == null ? (class$java$lang$Number = JRCsvDataSource.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(valueClass = jrField.getValueClass())) {
                fieldValue = fieldValue.trim();
            }
            try {
                if (valueClass.equals(class$java$lang$String == null ? (class$java$lang$String = JRCsvDataSource.class$("java.lang.String")) : class$java$lang$String)) {
                    return fieldValue;
                }
                if (valueClass.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JRCsvDataSource.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    return fieldValue.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
                }
                if (valueClass.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = JRCsvDataSource.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                    return new Byte(fieldValue);
                }
                if (valueClass.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = JRCsvDataSource.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                    return new Integer(fieldValue);
                }
                if (valueClass.equals(class$java$lang$Long == null ? (class$java$lang$Long = JRCsvDataSource.class$("java.lang.Long")) : class$java$lang$Long)) {
                    return new Long(fieldValue);
                }
                if (valueClass.equals(class$java$lang$Short == null ? (class$java$lang$Short = JRCsvDataSource.class$("java.lang.Short")) : class$java$lang$Short)) {
                    return new Short(fieldValue);
                }
                if (valueClass.equals(class$java$lang$Double == null ? (class$java$lang$Double = JRCsvDataSource.class$("java.lang.Double")) : class$java$lang$Double)) {
                    return new Double(fieldValue);
                }
                if (valueClass.equals(class$java$lang$Float == null ? (class$java$lang$Float = JRCsvDataSource.class$("java.lang.Float")) : class$java$lang$Float)) {
                    return new Float(fieldValue);
                }
                if (valueClass.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JRCsvDataSource.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                    return new BigDecimal(fieldValue);
                }
                if (valueClass.equals(class$java$util$Date == null ? (class$java$util$Date = JRCsvDataSource.class$("java.util.Date")) : class$java$util$Date)) {
                    return this.dateFormat.parse(fieldValue);
                }
                if (valueClass.equals(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JRCsvDataSource.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
                    return new Timestamp(this.dateFormat.parse(fieldValue).getTime());
                }
                if (valueClass.equals(class$java$sql$Time == null ? (class$java$sql$Time = JRCsvDataSource.class$("java.sql.Time")) : class$java$sql$Time)) {
                    return new Time(this.dateFormat.parse(fieldValue).getTime());
                }
                throw new JRException("Field '" + jrField.getName() + "' is of class '" + valueClass.getName() + "' and can not be converted");
            }
            catch (Exception e) {
                throw new JRException("Unable to get value for field '" + jrField.getName() + "' of class '" + valueClass.getName() + "'", e);
            }
        }
        throw new JRException("Unknown column name : " + fieldName);
    }

    private boolean parseRow() throws IOException {
        String field;
        int pos = 0;
        int startFieldPos = 0;
        boolean insideQuotes = false;
        boolean hadQuotes = false;
        boolean misplacedQuote = false;
        this.fields = new Vector();
        String row = this.getRow();
        if (row == null || row.length() == 0) {
            return false;
        }
        while (pos < row.length()) {
            char c = row.charAt(pos);
            if (c == '\"') {
                if (!insideQuotes) {
                    if (!hadQuotes) {
                        insideQuotes = true;
                        hadQuotes = true;
                    } else {
                        misplacedQuote = true;
                    }
                } else if (pos + 1 < row.length() && row.charAt(pos + 1) == '\"') {
                    ++pos;
                } else {
                    insideQuotes = false;
                }
            }
            if (c == this.fieldDelimiter && !insideQuotes) {
                field = row.substring(startFieldPos, pos);
                if (misplacedQuote) {
                    misplacedQuote = false;
                    hadQuotes = false;
                    field = "";
                } else if (hadQuotes) {
                    if ((field = field.trim()).startsWith("\"") && field.endsWith("\"")) {
                        field = field.substring(1, field.length() - 1);
                        field = this.replaceAll(field, "\"\"", "\"");
                    } else {
                        field = "";
                    }
                    hadQuotes = false;
                }
                this.fields.add(field);
                startFieldPos = pos + 1;
            }
            if (++pos != row.length() || !insideQuotes) continue;
            row = row + this.recordDelimiter + this.getRow();
        }
        field = row.substring(startFieldPos, pos);
        if (field == null || field.length() == 0) {
            return true;
        }
        if (misplacedQuote) {
            field = "";
        } else if (hadQuotes) {
            if ((field = field.trim()).startsWith("\"") && field.endsWith("\"")) {
                field = field.substring(1, field.length() - 1);
                field = this.replaceAll(field, "\"\"", "\"");
            } else {
                field = "";
            }
        }
        this.fields.add(field);
        return true;
    }

    private String getRow() throws IOException {
        StringBuffer row = new StringBuffer();
        try {
            while (true) {
                char c;
                if ((c = this.getChar()) == this.recordDelimiter.charAt(0)) {
                    int i;
                    char[] temp = new char[this.recordDelimiter.length()];
                    temp[0] = c;
                    boolean isDelimiter = true;
                    for (i = 1; i < this.recordDelimiter.length() && isDelimiter; ++i) {
                        temp[i] = this.getChar();
                        if (temp[i] == this.recordDelimiter.charAt(i)) continue;
                        isDelimiter = false;
                    }
                    if (isDelimiter) {
                        return row.toString();
                    }
                    row.append(temp, 0, i);
                }
                row.append(c);
            }
        }
        catch (JRException e) {
            return row.toString();
        }
    }

    private char getChar() throws IOException, JRException {
        if (this.position + 1 > this.bufSize) {
            this.bufSize = this.reader.read(this.buffer);
            this.position = 0;
            if (this.bufSize == -1) {
                throw new JRException("No more chars");
            }
        }
        return this.buffer[this.position++];
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        if (this.processingStarted) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started");
        }
        this.dateFormat = dateFormat;
    }

    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(char fieldDelimiter) {
        if (this.processingStarted) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started");
        }
        this.fieldDelimiter = fieldDelimiter;
    }

    public String getRecordDelimiter() {
        return this.recordDelimiter;
    }

    public void setRecordDelimiter(String recordDelimiter) {
        if (this.processingStarted) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started");
        }
        this.recordDelimiter = recordDelimiter;
    }

    public void setColumnNames(String[] columnNames) {
        if (this.processingStarted) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started");
        }
        for (int i = 0; i < columnNames.length; ++i) {
            this.columnNames.put(columnNames[i], new Integer(i));
        }
    }

    public void setUseFirstRowAsHeader(boolean useFirstRowAsHeader) {
        if (this.processingStarted) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started");
        }
        this.useFirstRowAsHeader = useFirstRowAsHeader;
    }

    private String replaceAll(String string, String substring, String replacement) {
        StringBuffer result = new StringBuffer();
        int index = string.indexOf(substring);
        int oldIndex = 0;
        while (index >= 0) {
            result.append(string.substring(oldIndex, index));
            result.append(replacement);
            oldIndex = index += substring.length();
            index = string.indexOf(substring, index);
        }
        if (oldIndex < string.length()) {
            result.append(string.substring(oldIndex, string.length()));
        }
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

