/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRComparableIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRDefaultIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRLongAverageIncrementer;
import net.sf.jasperreports.engine.fill.JRLongCountIncrementer;
import net.sf.jasperreports.engine.fill.JRLongStandardDeviationIncrementer;
import net.sf.jasperreports.engine.fill.JRLongSumIncrementer;
import net.sf.jasperreports.engine.fill.JRLongVarianceIncrementer;

public class JRLongIncrementerFactory
extends JRAbstractExtendedIncrementerFactory {
    protected static final Long ZERO = new Long(0L);
    private static JRLongIncrementerFactory mainInstance = new JRLongIncrementerFactory();

    private JRLongIncrementerFactory() {
    }

    public static JRLongIncrementerFactory getInstance() {
        return mainInstance;
    }

    public JRExtendedIncrementer getExtendedIncrementer(byte calculation) {
        JRExtendedIncrementer incrementer = null;
        switch (calculation) {
            case 1: {
                incrementer = JRLongCountIncrementer.getInstance();
                break;
            }
            case 2: {
                incrementer = JRLongSumIncrementer.getInstance();
                break;
            }
            case 3: {
                incrementer = JRLongAverageIncrementer.getInstance();
                break;
            }
            case 4: 
            case 5: {
                incrementer = JRComparableIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
                break;
            }
            case 6: {
                incrementer = JRLongStandardDeviationIncrementer.getInstance();
                break;
            }
            case 7: {
                incrementer = JRLongVarianceIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
            }
        }
        return incrementer;
    }
}

