/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.barbecue.linear.ean;

import java.awt.Dimension;
import java.util.ArrayList;
import net.sourceforge.barbecue.BarcodeException;
import net.sourceforge.barbecue.Module;
import net.sourceforge.barbecue.linear.ean.EAN13ModuleFactory;
import net.sourceforge.barbecue.linear.upc.UPCABarcode;
import net.sourceforge.barbecue.output.LabelLayoutFactory;
import net.sourceforge.barbecue.output.Output;
import net.sourceforge.barbecue.output.OutputException;

public class EAN13Barcode
extends UPCABarcode {
    public static final String[] TYPES = new String[]{"EAN-13", "EAN13"};
    public static final int LEFT_ODD = 0;
    public static final int LEFT_EVEN = 1;
    public static final int RIGHT = 2;
    public static final int PARITY_EVEN = 0;
    public static final int PARITY_ODD = 1;
    public static final int BARCODE_LENGTH = 12;
    public static final String ISBN_NUMBER_SYSTEM = "978";
    public static final int ISBN_SIZE = 10;

    public EAN13Barcode(String string) throws BarcodeException {
        super(string);
    }

    protected int getBarcodeLength() {
        return 12;
    }

    protected int getGuardCharSize() {
        return 0;
    }

    protected int getLeftWidth() {
        return 7;
    }

    protected Module getRightMargin() {
        return EAN13ModuleFactory.RIGHT_MARGIN;
    }

    protected Dimension draw(Output output, int n, int n2, int n3, int n4) throws OutputException {
        int n5;
        int n6 = n;
        output.beginDraw();
        int n7 = 0;
        int n8 = n4;
        int n9 = 10 * n3;
        if (this.drawingText) {
            n8 = n4 - 11 * n3;
            n7 = n8 + 6 * n3;
        } else {
            n8 = n4 - 6 * n3;
            n7 = n4;
        }
        String string = this.getLabel();
        int n10 = this.barHeight + n2;
        Module[] moduleArray = this.encodeData();
        String string2 = String.valueOf(string.charAt(0));
        String string3 = string.substring(1, this.getLeftWidth());
        String string4 = string.substring(this.getLeftWidth());
        if (this.requiresChecksum) {
            string4 = string4 + this.calculateChecksum().getSymbol();
        }
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = n;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        n15 = 0;
        n6 += this.drawModule(this.getLeftMargin(), output, n6, n2, n3, n8 + n9);
        n11 = n;
        n15 = n6 - n11;
        n18 = n6;
        int n19 = this.getGuardCharSize();
        int n20 = this.getLeftWidth() - 1;
        n6 += this.drawModule(this.getPreAmble(), output, n6, n2, n3, n7);
        for (n5 = 0; n5 < n19; ++n5) {
            n6 += this.drawModule(moduleArray[0], output, n6, n2, n3, n7);
        }
        n12 = n6;
        n18 = n6 - n18;
        output.paintBackground(n6 - n18, n7, n18, n8 + n9 - n7);
        for (n5 = n19; n5 < n20; ++n5) {
            n6 += this.drawModule(moduleArray[n5], output, n6, n2, n3, n8);
        }
        n16 = n6 - n12;
        n18 = n6;
        n6 += this.drawModule(this.getCentreGuard(), output, n6, n2, n3, n7);
        n13 = n6;
        n18 = n6 - n18;
        output.paintBackground(n6 - n18, n7, n18, n8 + n9 - n7);
        for (n5 = n20; n5 < moduleArray.length; ++n5) {
            n6 += this.drawModule(moduleArray[n5], output, n6, n2, n3, n8);
        }
        n17 = n6 - n13;
        n18 = n6;
        n6 += this.drawModule(this.getPostAmble(), output, n6, n2, n3, n7);
        n18 = n6 - n18;
        output.paintBackground(n6 - n18, n7, n18, n8 + n9 - n7);
        n14 = n6;
        n6 += this.drawModule(this.getRightMargin(), output, n6, n2, n3, n8 + n9);
        if (this.drawingText) {
            output.drawText(string2, LabelLayoutFactory.createMarginLayout(n11, n8, n15, n9));
            output.drawText(string3, LabelLayoutFactory.createMarginLayout(n12, n8, n16, n9));
            output.drawText(string4, LabelLayoutFactory.createMarginLayout(n13, n8, n17, n9));
        }
        Dimension dimension = new Dimension(n6 - n, n10 - n2);
        output.endDraw((int)dimension.getWidth(), (int)dimension.getHeight());
        return dimension;
    }

    protected Module[] encodeData() {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        Module module = null;
        int n = this.data.length();
        String string = this.data.substring(0, 1);
        for (int i = 1; i < n; ++i) {
            char c = this.data.charAt(i);
            module = EAN13ModuleFactory.getModule(string, String.valueOf(c), i);
            this.width += module.widthInBars();
            arrayList.add(module);
        }
        if (this.requiresChecksum) {
            module = EAN13ModuleFactory.getModule(string, this.calculateChecksum().getSymbol(), arrayList.size() - 1);
            this.width += module.widthInBars();
            arrayList.add(module);
        }
        return arrayList.toArray(new Module[0]);
    }

    protected Module calculateChecksum() {
        if (this.requiresChecksum) {
            return EAN13ModuleFactory.getModuleForIndex(this.data.substring(0, 1), EAN13Barcode.getMod10CheckDigit(this.data));
        }
        return null;
    }

    public static int getMod10CheckDigit(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            try {
                int n3 = Integer.parseInt(String.valueOf(string.charAt(i)));
                n += EAN13Barcode.calculateChecksum(n3, i % 2 == 0);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 10 - n % 10;
    }
}

