/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax.parser;

import org.codehaus.groovy.syntax.CSTNode;

public class ExpressionSupport {
    public static boolean isAnExpression(CSTNode node, boolean unknownReturns) {
        if (node.isA(0)) {
            return unknownReturns;
        }
        return node.isAnExpression();
    }

    public static boolean isAnExpression(CSTNode node) {
        return ExpressionSupport.isAnExpression(node, false);
    }

    public static boolean isAnOperator(CSTNode node, boolean unknownReturns) {
        if (node.isA(0)) {
            return unknownReturns;
        }
        return !node.isAnExpression();
    }

    public static boolean isAnOperator(CSTNode node) {
        return ExpressionSupport.isAnOperator(node, false);
    }

    public static boolean isAVariable(CSTNode node) {
        switch (node.getMeaning()) {
            case 30: {
                if (!node.isAnExpression()) break;
                return ExpressionSupport.isAVariable(node.get(1));
            }
            case 70: 
            case 80: {
                if (!node.isAnExpression() || node.get(2).getMeaning() != 440) break;
                return true;
            }
            case 440: {
                return true;
            }
        }
        return false;
    }

    public static boolean isInvokable(CSTNode node) {
        switch (node.getMeaning()) {
            case 542: 
            case 543: 
            case 814: 
            case 817: {
                return true;
            }
        }
        return ExpressionSupport.isAVariable(node);
    }

    public static boolean isAModifiableExpression(CSTNode node, boolean unknownReturns) {
        if (ExpressionSupport.isAnExpression(node, unknownReturns)) {
            if (ExpressionSupport.isAVariable(node)) {
                return true;
            }
            if (node.getMeaning() == 810) {
                boolean is = true;
                for (int i = 1; i < node.size(); ++i) {
                    if (ExpressionSupport.isAModifiableExpression(node.get(i), unknownReturns)) continue;
                    is = false;
                    break;
                }
                return is;
            }
        }
        return false;
    }

    public static boolean isAModifiableExpression(CSTNode node) {
        return ExpressionSupport.isAModifiableExpression(node, false);
    }

    public static boolean isPotentialCastOperator(CSTNode node) {
        if (node.isA(50) && node.isAnExpression()) {
            return ExpressionSupport.isAPotentialTypeName(node.get(1), false);
        }
        return false;
    }

    public static boolean isAPotentialTypeName(CSTNode node, boolean allowVoid) {
        if (node.isA(allowVoid ? 1420 : 1430)) {
            return true;
        }
        if (node.isA(70) && node.isAnExpression()) {
            return ExpressionSupport.isAPotentialTypeName(node.get(2), allowVoid) && ExpressionSupport.isAPotentialTypeName(node.get(1), allowVoid);
        }
        if (node.isA(30) && node.isAnExpression() && node.size() == 2) {
            return ExpressionSupport.isAPotentialTypeName(node.get(1), allowVoid);
        }
        return false;
    }
}

