/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.OuterJoinLoader;
import org.hibernate.loader.OuterJoinableAssociation;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.Select;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.StringHelper;

public class OneToManyLoader
extends OuterJoinLoader
implements CollectionInitializer {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$loader$collection$OneToManyLoader == null ? (class$org$hibernate$loader$collection$OneToManyLoader = OneToManyLoader.class$("org.hibernate.loader.collection.OneToManyLoader")) : class$org$hibernate$loader$collection$OneToManyLoader));
    private final QueryableCollection oneToManyPersister;
    static /* synthetic */ Class class$org$hibernate$loader$collection$OneToManyLoader;

    protected boolean isDuplicateAssociation(Set visitedAssociationKeys, String foreignKeyTable, String[] foreignKeyColumns) {
        boolean isSameJoin = this.oneToManyPersister.getTableName().equals(foreignKeyTable) && Arrays.equals(foreignKeyColumns, this.oneToManyPersister.getKeyColumnNames());
        return isSameJoin || super.isDuplicateAssociation(visitedAssociationKeys, foreignKeyTable, foreignKeyColumns);
    }

    public OneToManyLoader(QueryableCollection oneToManyPersister, SessionFactoryImplementor session, Map enabledFilters) throws MappingException {
        this(oneToManyPersister, 1, session, enabledFilters);
    }

    public OneToManyLoader(QueryableCollection oneToManyPersister, int batchSize, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        this(oneToManyPersister, batchSize, null, factory, enabledFilters);
    }

    public OneToManyLoader(QueryableCollection oneToManyPersister, int batchSize, String subquery, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        super(factory, enabledFilters);
        this.oneToManyPersister = oneToManyPersister;
        OuterJoinLoadable elementPersister = (OuterJoinLoadable)oneToManyPersister.getElementPersister();
        String alias = this.generateRootAlias(oneToManyPersister.getRole());
        List associations = this.walkEntityTree(elementPersister, alias);
        ArrayList<OuterJoinableAssociation> allAssociations = new ArrayList<OuterJoinableAssociation>();
        allAssociations.addAll(associations);
        allAssociations.add(new OuterJoinableAssociation(oneToManyPersister.getCollectionType(), null, null, alias, 1, this.getFactory(), CollectionHelper.EMPTY_MAP));
        this.initPersisters(allAssociations, LockMode.NONE);
        this.initStatementString(elementPersister, alias, associations, batchSize, subquery);
        this.postInstantiate();
        log.debug((Object)("Static select for one-to-many " + oneToManyPersister.getRole() + ": " + this.getSQLString()));
    }

    public void initialize(Serializable id, SessionImplementor session) throws HibernateException {
        this.loadCollection(session, id, this.getKeyType());
    }

    private void initStatementString(OuterJoinLoadable elementPersister, String alias, List associations, int batchSize, String subquery) throws MappingException {
        int joins = OneToManyLoader.countEntityPersisters(associations);
        this.suffixes = OneToManyLoader.generateSuffixes(joins + 1);
        int collectionJoins = OneToManyLoader.countCollectionPersisters(associations) + 1;
        this.collectionSuffixes = OneToManyLoader.generateSuffixes(joins + 1, collectionJoins);
        StringBuffer whereString = this.whereString(alias, this.oneToManyPersister.getKeyColumnNames(), batchSize, subquery);
        String filter = this.oneToManyPersister.filterFragment(alias, this.getEnabledFilters());
        whereString.insert(0, StringHelper.moveAndToBeginning(filter));
        JoinFragment ojf = this.mergeOuterJoins(associations);
        Select select = new Select(this.getDialect()).setSelectClause(this.oneToManyPersister.selectFragment(null, null, alias, this.suffixes[joins], this.collectionSuffixes[0], true) + this.selectString(associations)).setFromClause(elementPersister.fromTableFragment(alias) + elementPersister.fromJoinFragment(alias, true, true)).setWhereClause(whereString.toString()).setOuterJoins(ojf.toFromFragmentString(), ojf.toWhereFragmentString() + elementPersister.whereJoinFragment(alias, true, true));
        select.setOrderByClause(this.orderBy(associations, this.oneToManyPersister.getSQLOrderByString(alias)));
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment("load one-to-many " + this.oneToManyPersister.getRole());
        }
        this.sql = select.toStatementString();
    }

    protected Type getKeyType() {
        return this.oneToManyPersister.getKeyType();
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.oneToManyPersister.getRole() + ')';
    }

    protected boolean isSubselectLoadingEnabled() {
        return this.hasSubselectLoadableCollections();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

