/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.BasicLoader;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.loader.ColumnEntityAliases;
import org.hibernate.loader.DefaultEntityAliases;
import org.hibernate.loader.EntityAliases;
import org.hibernate.loader.GeneratedCollectionAliases;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.loader.custom.SQLQueryParser;
import org.hibernate.loader.custom.SQLQueryReturn;
import org.hibernate.loader.custom.SQLQueryReturnProcessor;
import org.hibernate.loader.custom.SQLQueryScalarReturn;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.SQLLoadable;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.StringHelper;

public class SQLCustomQuery
implements CustomQuery {
    private final String[] entityNames;
    private final String[] collectionRoles;
    private final int[] collectionOwners;
    private final int[] entityOwners;
    private final LockMode[] lockModes;
    private final String sql;
    private final Set querySpaces = new HashSet();
    private final Map namedParameters;
    private final Type[] scalarTypes;
    private final String[] scalarColumnAliases;
    private final EntityAliases[] entityDescriptors;
    private final CollectionAliases[] collectionDescriptors;

    public String getSQL() {
        return this.sql;
    }

    public Map getNamedParameterBindPoints() {
        return this.namedParameters;
    }

    public String[] getCollectionRoles() {
        return this.collectionRoles;
    }

    public String[] getEntityNames() {
        return this.entityNames;
    }

    public LockMode[] getLockModes() {
        return this.lockModes;
    }

    public EntityAliases[] getEntityAliases() {
        return this.entityDescriptors;
    }

    public CollectionAliases[] getCollectionAliases() {
        return this.collectionDescriptors;
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    public int[] getCollectionOwner() {
        return this.collectionOwners;
    }

    public int[] getEntityOwners() {
        return this.entityOwners;
    }

    public String[] getScalarColumnAliases() {
        return this.scalarColumnAliases;
    }

    public Type[] getScalarTypes() {
        return this.scalarTypes;
    }

    public SQLCustomQuery(SQLQueryReturn[] queryReturns, SQLQueryScalarReturn[] scalarQueryReturns, String sqlQuery, Collection additionalQuerySpaces, SessionFactoryImplementor factory) throws HibernateException {
        SQLQueryReturnProcessor processor = new SQLQueryReturnProcessor(queryReturns, scalarQueryReturns, factory);
        processor.process();
        ArrayList<String> collectionSuffixes = new ArrayList<String>();
        List collectionOwnerAliases = processor.getCollectionOwnerAliases();
        List collectionPersisters = processor.getCollectionPersisters();
        int size = collectionPersisters.size();
        if (size != 0) {
            this.collectionOwners = new int[size];
            this.collectionRoles = new String[size];
            this.collectionDescriptors = new CollectionAliases[size];
            for (int i = 0; i < size; ++i) {
                CollectionPersister collectionPersister = (CollectionPersister)collectionPersisters.get(i);
                this.collectionRoles[i] = collectionPersister.getRole();
                this.collectionOwners[i] = processor.getAliases().indexOf(collectionOwnerAliases.get(i));
                String suffix = i + "__";
                collectionSuffixes.add(suffix);
                this.collectionDescriptors[i] = new GeneratedCollectionAliases(collectionPersister, suffix);
            }
        } else {
            this.collectionRoles = null;
            this.collectionDescriptors = null;
            this.collectionOwners = null;
        }
        String[] aliases = ArrayHelper.toStringArray(processor.getAliases());
        String[] collAliases = ArrayHelper.toStringArray(processor.getCollectionAliases());
        String[] collSuffixes = ArrayHelper.toStringArray(collectionSuffixes);
        Map[] propertyResultMaps = processor.getPropertyResults().toArray(new Map[0]);
        Boolean[] useGeneratedAliases = processor.getAliasModes().toArray(new Boolean[0]);
        SQLLoadable[] entityPersisters = processor.getPersisters().toArray(new SQLLoadable[0]);
        QueryableCollection[] collPersisters = collectionPersisters.toArray(new QueryableCollection[0]);
        this.lockModes = processor.getLockModes().toArray(new LockMode[0]);
        this.scalarColumnAliases = ArrayHelper.toStringArray(processor.getScalarColumnAliases());
        this.scalarTypes = ArrayHelper.toTypeArray(processor.getScalarTypes());
        String[] suffixes = BasicLoader.generateSuffixes(entityPersisters.length);
        SQLQueryParser parser = new SQLQueryParser(sqlQuery, processor.getAlias2Persister(), processor.getAlias2Return(), aliases, collAliases, collPersisters, suffixes, collSuffixes);
        this.sql = parser.process();
        this.namedParameters = parser.getNamedParameters();
        this.entityNames = new String[entityPersisters.length];
        this.entityDescriptors = new EntityAliases[entityPersisters.length];
        for (int i = 0; i < entityPersisters.length; ++i) {
            SQLLoadable persister = entityPersisters[i];
            ArrayHelper.addAll(this.querySpaces, persister.getQuerySpaces());
            this.entityNames[i] = persister.getEntityName();
            this.entityDescriptors[i] = Boolean.TRUE.equals(useGeneratedAliases[i]) ? new DefaultEntityAliases(propertyResultMaps[i], entityPersisters[i], suffixes[i]) : new ColumnEntityAliases(propertyResultMaps[i], entityPersisters[i], suffixes[i]);
        }
        if (additionalQuerySpaces != null) {
            this.querySpaces.addAll(additionalQuerySpaces);
        }
        Map alias2OwnerAlias = processor.getAlias2OwnerAlias();
        int[] ownersArray = new int[entityPersisters.length];
        for (int j = 0; j < aliases.length; ++j) {
            String ownerAlias = (String)alias2OwnerAlias.get(aliases[j]);
            ownersArray[j] = StringHelper.isNotEmpty(ownerAlias) ? processor.getAliases().indexOf(ownerAlias) : -1;
        }
        if (ArrayHelper.isAllNegative(ownersArray)) {
            ownersArray = null;
        }
        this.entityOwners = ownersArray;
    }
}

