/*
 * GraphicReportElement.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 * Created on 28 febbraio 2003, 19.22
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.gui.*;
import it.businesslogic.ireport.util.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.geom.*;

public abstract class GraphicReportElement extends ReportElement 
{

	public String graphicElementPen;
	public String fill;
	
	public GraphicReportElement(int x, int y, int width, int height)
	{
		super(x,y, Math.abs(width), Math.abs(height));
		setGraphicElementPen("Thin");
		fill="Solid";
		stretchType="NoStretch";
                // Name the elements differently
                setKey("graphic");
	}
	
	public void drawObject(Graphics2D g,double zoom_factor, int x_shift_origin, int y_shift_origin)
	{
		super.drawGraphicsElement(g, graphicElementPen, zoom_factor, x_shift_origin, y_shift_origin );
	}
        
        /** Getter for property fill.
         * @return Value of property fill.
         *
         */
        public java.lang.String getFill() {
            return fill;
        }
        
        /** Setter for property fill.
         * @param fill New value of property fill.
         *
         */
        public void setFill(java.lang.String fill) {
            this.fill = fill;
        }
        
        /** Getter for property graphicElementPen.
         * @return Value of property graphicElementPen.
         *
         */
        public java.lang.String getGraphicElementPen() {
            return graphicElementPen;
        }
        
        /** Setter for property graphicElementPen.
         * @param graphicElementPen New value of property graphicElementPen.
         *
         */
        public void setGraphicElementPen(java.lang.String graphicElementPen) {
            this.graphicElementPen = graphicElementPen;
        }
        
        public void copyBaseReportElement(ReportElement destination, ReportElement source)
        {
                super.copyBaseReportElement(destination, source);
                
                if (destination instanceof GraphicReportElement &&
                    source instanceof GraphicReportElement )
                {
                    ((GraphicReportElement)destination).setFill( new String( ((GraphicReportElement)source).getFill() ));
                    ((GraphicReportElement)destination).setGraphicElementPen( new String( ((GraphicReportElement)source).getGraphicElementPen() ));
                    ((GraphicReportElement)destination).setStretchType( new String( ((GraphicReportElement)source).getStretchType()) );
                }
        }
        
         public void setStyle(Style style) {
                super.setStyle(style);
                if (style != null)
                {
                    this.setFill( style.getAttributeString( style.ATTRIBUTE_fill, getFill(), true)  );
                    this.setGraphicElementPen( style.getAttributeString( style.ATTRIBUTE_pen,getGraphicElementPen(), true) );   
                }
         }
}

