/*
 * PieDatasetPanel.java
 *
 * Created on 15 agosto 2005, 17.55
 */

package it.businesslogic.ireport.chart;
import it.businesslogic.ireport.SubDataset;
import java.util.*;
/**
 *
 * @author  Administrator
 */
public class TimePeriodDatasetPanel extends javax.swing.JPanel implements ChartDatasetPanel {
    
    private TimePeriodDataset timePeriodDataset = null;
    private SubDataset subDataset = null;
    
    /** Creates new form PieDatasetPanel */
    public TimePeriodDatasetPanel() {
        initComponents();
        applyI18n();
        jList1.setModel( new javax.swing.DefaultListModel());
    }

    public void setTimePeriodDataset(TimePeriodDataset timePeriodDataset) {
        this.timePeriodDataset = timePeriodDataset;
        
        jButtonModify.setEnabled( false );
        jButtonModify.setEnabled( false );
        javax.swing.DefaultListModel lm = (javax.swing.DefaultListModel)jList1.getModel();
        
        lm.removeAllElements();
        
        Vector v = timePeriodDataset.getTimePeriodSeries();
                        
        for (int i=0; i< v.size(); ++i)
        {
            lm.addElement(v.elementAt(i) );
        }

    }

    public TimePeriodDataset getTimePeriodDataset() {
        return timePeriodDataset;
    }
  
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPopupMenuSeries = new javax.swing.JPopupMenu();
        jMenuItemCopy = new javax.swing.JMenuItem();
        jMenuItemPaste = new javax.swing.JMenuItem();
        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        jPanel1 = new javax.swing.JPanel();
        jButtonAdd = new javax.swing.JButton();
        jButtonModify = new javax.swing.JButton();
        jButtonRemove = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();

        jMenuItemCopy.setFont(new java.awt.Font("Tahoma", 0, 11));
        jMenuItemCopy.setText("Copy series");
        jMenuItemCopy.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCopyActionPerformed(evt);
            }
        });

        jPopupMenuSeries.add(jMenuItemCopy);

        jMenuItemPaste.setFont(new java.awt.Font("Tahoma", 0, 11));
        jMenuItemPaste.setText("Paste series");
        jMenuItemPaste.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemPasteActionPerformed(evt);
            }
        });

        jPopupMenuSeries.add(jMenuItemPaste);

        setLayout(new java.awt.GridBagLayout());

        jList1.setFont(new java.awt.Font("Tahoma", 0, 11));
        jList1.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jList1ValueChanged(evt);
            }
        });
        jList1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jList1MouseClicked(evt);
            }
        });

        jScrollPane1.setViewportView(jList1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(jScrollPane1, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jPanel1.setMinimumSize(new java.awt.Dimension(100, 0));
        jPanel1.setPreferredSize(new java.awt.Dimension(100, 0));
        jButtonAdd.setFont(new java.awt.Font("Tahoma", 0, 11));
        jButtonAdd.setText("Add");
        jButtonAdd.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAddActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 4);
        jPanel1.add(jButtonAdd, gridBagConstraints);

        jButtonModify.setFont(new java.awt.Font("Tahoma", 0, 11));
        jButtonModify.setText("Modify");
        jButtonModify.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonModifyActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 4);
        jPanel1.add(jButtonModify, gridBagConstraints);

        jButtonRemove.setFont(new java.awt.Font("Tahoma", 0, 11));
        jButtonRemove.setText("Remove");
        jButtonRemove.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonRemoveActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 4);
        jPanel1.add(jButtonRemove, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 99;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jPanel2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(jPanel1, gridBagConstraints);

        jLabel1.setFont(new java.awt.Font("Tahoma", 0, 11));
        jLabel1.setText("Time period series");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 0, 4);
        add(jLabel1, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents

    private void jMenuItemPasteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemPasteActionPerformed
        Vector v = it.businesslogic.ireport.gui.MainFrame.getMainInstance().getChartSeriesClipBoard();
        
        if (v != null && v.size() > 0)
        {
            for (int i=0; i<v.size(); ++i)
            {
                if (v.elementAt(i) instanceof TimePeriodSeries)
                {
                    TimePeriodSeries cs = (TimePeriodSeries)v.elementAt(i);
                    cs = cs.cloneMe();
                    timePeriodDataset.getTimePeriodSeries().addElement(cs);
                    ((javax.swing.DefaultListModel)jList1.getModel()).addElement(cs);
                }
            }
            jList1.updateUI();
        }
    }//GEN-LAST:event_jMenuItemPasteActionPerformed

    private void jMenuItemCopyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCopyActionPerformed
        Object[] values = jList1.getSelectedValues();
        Vector copy_c = new Vector();
        for (int i=0; i<values.length; ++i) copy_c.add( ((TimePeriodSeries)values[i]).cloneMe() );
        it.businesslogic.ireport.gui.MainFrame.getMainInstance().setChartSeriesClipBoard(copy_c);
    }//GEN-LAST:event_jMenuItemCopyActionPerformed

    private void jList1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jList1MouseClicked
        if (evt.getClickCount() == 1 && evt.getButton() == evt.BUTTON3)
        {
            jMenuItemCopy.setEnabled(jList1.getSelectedIndex() >= 0);
            jMenuItemPaste.setEnabled( it.businesslogic.ireport.gui.MainFrame.getMainInstance().getChartSeriesClipBoard() != null &&
                                       it.businesslogic.ireport.gui.MainFrame.getMainInstance().getChartSeriesClipBoard().size() > 0);
            
            jPopupMenuSeries.show(this, evt.getPoint().x, evt.getPoint().y);
        }
    }//GEN-LAST:event_jList1MouseClicked

    private void jButtonModifyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonModifyActionPerformed
        
        if (jList1.getSelectedIndex() >= 0)
        {
            TimePeriodSeries cs = (TimePeriodSeries)jList1.getSelectedValue();
            TimePeriodSeriesDialog csd = new TimePeriodSeriesDialog(it.businesslogic.ireport.gui.MainFrame.getMainInstance() ,true);
            
            csd.setSeriesExpression( cs.getSeriesExpression() );
            csd.setStartDateExpression( cs.getStartDateExpression() );
            csd.setEndDateExpression( cs.getEndDateExpression() );
            csd.setValueExpression( cs.getValueExpression() );
            csd.setLabelExpression( cs.getLabelExpression() );
            
            csd.setSubDataset( this.getSubDataset() );
            csd.setVisible(true);
            
            if (csd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
            {
                cs.setSeriesExpression( csd.getSeriesExpression() );
                cs.setStartDateExpression( csd.getStartDateExpression() );
                cs.setEndDateExpression( csd.getEndDateExpression() );
                cs.setValueExpression( csd.getValueExpression() );
                cs.setLabelExpression( csd.getLabelExpression() );

                jList1.updateUI();
            }
        
        }
    }//GEN-LAST:event_jButtonModifyActionPerformed

    private void jButtonAddActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAddActionPerformed

        TimePeriodSeriesDialog csd = new TimePeriodSeriesDialog(it.businesslogic.ireport.gui.MainFrame.getMainInstance() ,true);
        csd.setSubDataset( this.getSubDataset() );
        csd.setVisible(true);
        if (csd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {
            TimePeriodSeries cs = new TimePeriodSeries();
            cs.setSeriesExpression( csd.getSeriesExpression() );
            cs.setStartDateExpression( csd.getStartDateExpression() );
            cs.setEndDateExpression( csd.getEndDateExpression() );
            cs.setValueExpression( csd.getValueExpression() );
            cs.setLabelExpression( csd.getLabelExpression() );
            
            getTimePeriodDataset().getTimePeriodSeries().addElement(cs);
            ((javax.swing.DefaultListModel)jList1.getModel()).addElement(cs);
        }
        
    }//GEN-LAST:event_jButtonAddActionPerformed

    private void jButtonRemoveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonRemoveActionPerformed

        while (jList1.getSelectedIndex() >= 0)
        {
            getTimePeriodDataset().getTimePeriodSeries().remove( jList1.getSelectedValue() );
            ((javax.swing.DefaultListModel)jList1.getModel()).removeElementAt(jList1.getSelectedIndex());
        }
        
    }//GEN-LAST:event_jButtonRemoveActionPerformed

    private void jList1ValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jList1ValueChanged

        if (jList1.getSelectedIndex() >= 0)
        {
            jButtonModify.setEnabled( true );
            jButtonModify.setEnabled( true );
        }
        else
        {
            jButtonModify.setEnabled( false );
            jButtonModify.setEnabled( false );
        }
    }//GEN-LAST:event_jList1ValueChanged
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAdd;
    private javax.swing.JButton jButtonModify;
    private javax.swing.JButton jButtonRemove;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JList jList1;
    private javax.swing.JMenuItem jMenuItemCopy;
    private javax.swing.JMenuItem jMenuItemPaste;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPopupMenu jPopupMenuSeries;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
    
     public void applyI18n()
    {
        jButtonAdd.setText(it.businesslogic.ireport.util.I18n.getString("charts.newseries", "Add series"));
        jButtonModify.setText(it.businesslogic.ireport.util.I18n.getString("charts.modifyseries", "Modify series"));
        jButtonRemove.setText(it.businesslogic.ireport.util.I18n.getString("charts.removeseries", "Remove series"));
        
        jMenuItemCopy.setText(it.businesslogic.ireport.util.I18n.getString("charts.copyseries", "Copy series"));
        jMenuItemPaste.setText(it.businesslogic.ireport.util.I18n.getString("charts.pasteseries", "Paste series"));
        
        this.updateUI();
        
    }

    public SubDataset getSubDataset() {
        return subDataset;
    }

    public void setSubDataset(SubDataset subDataset) {
        this.subDataset = subDataset;
    }

     
}
