/*
 * CrosstabEditor.java
 *
 * Created on 3 gennaio 2006, 13.39
 */

package it.businesslogic.ireport.crosstab.gui;

import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.crosstab.CrosstabCell;
import it.businesslogic.ireport.crosstab.CrosstabGroup;
import it.businesslogic.ireport.gui.event.CrosstabLayoutChangedEvent;
import it.businesslogic.ireport.gui.event.CrosstabLayoutChangedListener;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author  Administrator
 */
public class CrosstabEditor extends javax.swing.JPanel implements ImageObserver, CrosstabLayoutChangedListener {
    
    private CrosstabReportElement crosstabElement = null;
    
    
    /** Creates new form CrosstabEditor */
    public CrosstabEditor(CrosstabReportElement crossTabElement) {
        initComponents();
        this.setCrosstabElement(crossTabElement);
        getCrosstabElement().addCrosstabLayoutChangedListener( this );
        this.crosstabEditorPanel1.setEditor( this );
    }

    public CrosstabReportElement getCrosstabElement() {
        return crosstabElement;
    }

    public void setCrosstabElement(CrosstabReportElement crossTabElement) {
        this.crosstabElement = crossTabElement;
    }

    public double getZoomFactor() {
        return crosstabEditorPanel1.getZoomFactor();
    }

    public void setZoomFactor(double zoomFactor) {
       crosstabEditorPanel1.setZoomFactor(zoomFactor);
    }

    public void crosstabLayoutChanged(CrosstabLayoutChangedEvent evt) {
        this.crosstabEditorPanel1.updateGrid();
        this.crosstabEditorPanel1.repaint();
    }
    
    public void updatePanel()
    {
        this.crosstabEditorPanel1.setEditor( this );
    }
    
    public it.businesslogic.ireport.crosstab.gui.CrosstabEditorPanel getPanelEditor()
    {
        return this.crosstabEditorPanel1;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        crosstabEditorPanel1 = new it.businesslogic.ireport.crosstab.gui.CrosstabEditorPanel();

        setLayout(new java.awt.GridBagLayout());

        setBackground(new java.awt.Color(204, 204, 204));
        addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                formFocusGained(evt);
            }
        });
        addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                formKeyPressed(evt);
            }
        });

        jPanel1.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
        jPanel1.setMaximumSize(new java.awt.Dimension(16, 16));
        jPanel1.setMinimumSize(new java.awt.Dimension(16, 16));
        jPanel1.setPreferredSize(new java.awt.Dimension(16, 16));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jPanel1, gridBagConstraints);

        jPanel2.setBackground(new java.awt.Color(255, 255, 255));
        jPanel2.setMaximumSize(new java.awt.Dimension(32767, 16));
        jPanel2.setPreferredSize(new java.awt.Dimension(10, 16));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        add(jPanel2, gridBagConstraints);

        jPanel3.setBackground(new java.awt.Color(255, 255, 255));
        jPanel3.setMaximumSize(new java.awt.Dimension(10, 32767));
        jPanel3.setMinimumSize(new java.awt.Dimension(16, 10));
        jPanel3.setPreferredSize(new java.awt.Dimension(16, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        add(jPanel3, gridBagConstraints);

        jScrollPane1.setAutoscrolls(true);
        jScrollPane1.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jScrollPane1FocusGained(evt);
            }
        });
        jScrollPane1.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jScrollPane1KeyTyped(evt);
            }
        });

        crosstabEditorPanel1.setPreferredSize(new java.awt.Dimension(1000, 1000));
        crosstabEditorPanel1.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                crosstabEditorPanel1FocusGained(evt);
            }
        });
        crosstabEditorPanel1.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                crosstabEditorPanel1KeyPressed(evt);
            }
        });

        jScrollPane1.setViewportView(crosstabEditorPanel1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jScrollPane1, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

    private void jScrollPane1FocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jScrollPane1FocusGained

    }//GEN-LAST:event_jScrollPane1FocusGained

    private void formFocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_formFocusGained

    }//GEN-LAST:event_formFocusGained

    private void crosstabEditorPanel1FocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_crosstabEditorPanel1FocusGained

    }//GEN-LAST:event_crosstabEditorPanel1FocusGained

    private void formKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_formKeyPressed

    }//GEN-LAST:event_formKeyPressed

    private void jScrollPane1KeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jScrollPane1KeyTyped

    }//GEN-LAST:event_jScrollPane1KeyTyped

    private void crosstabEditorPanel1KeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_crosstabEditorPanel1KeyPressed
        
    }//GEN-LAST:event_crosstabEditorPanel1KeyPressed

    public void crosstabMeasureChanged(CrosstabLayoutChangedEvent evt) {
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private it.businesslogic.ireport.crosstab.gui.CrosstabEditorPanel crosstabEditorPanel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
    
}
