/*
 * FormatCommandAlignBottomToBand.java
 * Multiple elements in different bands can be selected.
 * The command needs at least one selected element 
 * Created on 9 mei 2005, 21:36
 */
package it.businesslogic.ireport.gui.command;

import it.businesslogic.ireport.OperationType;
import it.businesslogic.ireport.TransformationType;

import java.awt.Point;


public class FormatCommandAlignBottomToBand
    extends FormatCommand
{
    FormatCommandAlignBottomToBand()
    {
        operationType = OperationType.ALIGN_BOTTOM_TO_BAND;
    }

    /**
     * Modify() moves the bottom edge of each selected element to 
     * bottom of the band it belongs to.
     */
    public void modify()
    {
        re.trasform(new Point(0, 
                              jrf.getReport().getBandYLocation(re.band) + 10 + 
                                  re.band.getHeight() - 
                                  (re.getPosition().y + re.getHeight())), 
                    TransformationType.TRANSFORMATION_MOVE);
    }
}
