package org.syntax.jedit;

import java.util.*;

import org.syntax.jedit.tokenmarker.*;
import javax.swing.text.Segment;

public class IReportKeywordLookup implements KeywordLookupIF
{
        private ArrayList keys = new ArrayList();

        public IReportKeywordLookup()
        {
        }

        public void addKeyword(String keyword)
        {
          addKeyword(keyword, Token.PARAMETER_OK);
        }

        public void addKeyword(String keyword, byte token)
        {
          //System.out.println("add : " + keyword);
          keys.add(new Key(keyword, token));
        }

        public void removeKeyword(String keyword)
        {
          Key key;

          for(int i=0; i<keys.size(); i++)
          {
            key = (Key) keys.get(i);
            if(key.keyword.equals(keyword))
            {
              keys.remove(key);
            }
          }
        }

	/**
	 * Looks up a key.
	 * @param text The text segment
	 * @param offset The offset of the substring within the text segment
	 * @param length The length of the substring
	 */
	public byte lookup(Segment text, int offset, int length)
        {
          Key key;
          String keyword;
          boolean found;

          for(int i=0; i<keys.size(); i++)
          {
            key = (Key) keys.get(i);
            keyword = key.keyword;

            if(keyword.length() != length)
            {
              continue;
            }

            found = true;
            for(int j=0; j<keyword.length(); j++)
            {
              if(keyword.charAt(j) != text.array[offset + j])
              {
                found = false;
                break;
              }
            }

            if(found)
            {
              return key.token;
            }
          }

          return Token.NULL;
        }

        private class Key
        {
          String keyword;
          byte token;

          Key(String keyword, byte token)
          {
            this.keyword = keyword;
            this.token = token;
          }
        }

}
