/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.refactoring;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.ChartReportElement2;
import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.Group;
import it.businesslogic.ireport.HyperLinkableReportElement;
import it.businesslogic.ireport.ImageReportElement;
import it.businesslogic.ireport.JRLinkParameter;
import it.businesslogic.ireport.JRSubreportParameter;
import it.businesslogic.ireport.JRSubreportReturnValue;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.SubReportElement;
import it.businesslogic.ireport.TextFieldReportElement;
import it.businesslogic.ireport.TextReportElement;
import it.businesslogic.ireport.chart.AreaPlot;
import it.businesslogic.ireport.chart.Axis;
import it.businesslogic.ireport.chart.Bar3DPlot;
import it.businesslogic.ireport.chart.BarPlot;
import it.businesslogic.ireport.chart.BubblePlot;
import it.businesslogic.ireport.chart.CandlestickPlot;
import it.businesslogic.ireport.chart.CategoryDataset;
import it.businesslogic.ireport.chart.CategorySeries;
import it.businesslogic.ireport.chart.Chart;
import it.businesslogic.ireport.chart.Dataset;
import it.businesslogic.ireport.chart.HighLowDataset;
import it.businesslogic.ireport.chart.HighLowPlot;
import it.businesslogic.ireport.chart.LinePlot;
import it.businesslogic.ireport.chart.MeterInterval;
import it.businesslogic.ireport.chart.MeterPlot;
import it.businesslogic.ireport.chart.MultiAxisPlot;
import it.businesslogic.ireport.chart.Pie3DPlot;
import it.businesslogic.ireport.chart.PieDataset;
import it.businesslogic.ireport.chart.PiePlot;
import it.businesslogic.ireport.chart.Plot;
import it.businesslogic.ireport.chart.ScatterPlot;
import it.businesslogic.ireport.chart.SectionItemHyperlink;
import it.businesslogic.ireport.chart.ThermometerPlot;
import it.businesslogic.ireport.chart.TimePeriodDataset;
import it.businesslogic.ireport.chart.TimePeriodSeries;
import it.businesslogic.ireport.chart.TimeSeries;
import it.businesslogic.ireport.chart.TimeSeriesDataset;
import it.businesslogic.ireport.chart.TimeSeriesPlot;
import it.businesslogic.ireport.chart.ValueDataset;
import it.businesslogic.ireport.chart.XYDataset;
import it.businesslogic.ireport.chart.XYSeries;
import it.businesslogic.ireport.chart.XYZDataset;
import it.businesslogic.ireport.chart.XYZSeries;
import it.businesslogic.ireport.crosstab.CrosstabGroup;
import it.businesslogic.ireport.crosstab.CrosstabParameter;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.gui.event.SubDatasetObjectChangedEvent;
import it.businesslogic.ireport.util.Misc;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class ReportRefactor {
    public static List replaceTextfieldClass(String expression, String newClassType, List elements) {
        ArrayList<ReportElement> list = new ArrayList<ReportElement>();
        if (expression == null) {
            return list;
        }
        for (int i = 0; i < elements.size(); ++i) {
            ReportElement re = (ReportElement)elements.get(i);
            if (!(re instanceof TextFieldReportElement) || !((TextFieldReportElement)re).getText().trim().equals(expression)) continue;
            ((TextFieldReportElement)re).setMatchingClassExpression(newClassType, true);
            list.add(re);
        }
        return list;
    }

    public static boolean updateDatasetRunExpressions(Dataset dataset, String oldString, String newString) {
        boolean add = false;
        if (dataset == null) {
            return false;
        }
        if (dataset.getConnectionExpression().indexOf(oldString) >= 0) {
            dataset.setConnectionExpression(Misc.string_replace(newString, oldString, dataset.getConnectionExpression()));
            add = true;
        }
        if (dataset.getDataSourceExpression().indexOf(oldString) >= 0) {
            dataset.setDataSourceExpression(Misc.string_replace(newString, oldString, dataset.getDataSourceExpression()));
            add = true;
        }
        if (dataset.getParametersMapExpression().indexOf(oldString) >= 0) {
            dataset.setParametersMapExpression(Misc.string_replace(newString, oldString, dataset.getParametersMapExpression()));
            add = true;
        }
        for (int k = 0; k < dataset.getSubreportParameters().size(); ++k) {
            JRSubreportParameter para = (JRSubreportParameter)dataset.getSubreportParameters().get(k);
            if (para.getExpression().indexOf(oldString) < 0) continue;
            para.setExpression(Misc.string_replace(newString, oldString, para.getExpression()));
            add = true;
        }
        return add;
    }

    public static boolean updateDatasetExpressions(Dataset dataset, String oldString, String newString) {
        boolean add;
        block40: {
            block45: {
                block44: {
                    block43: {
                        block42: {
                            block41: {
                                block39: {
                                    add = false;
                                    if (dataset == null) {
                                        return false;
                                    }
                                    if (dataset.getIncrementWhenExpression().indexOf(oldString) >= 0) {
                                        dataset.setIncrementWhenExpression(Misc.string_replace(newString, oldString, dataset.getIncrementWhenExpression()));
                                        add = true;
                                    }
                                    if (!(dataset instanceof PieDataset)) break block39;
                                    PieDataset ds = (PieDataset)dataset;
                                    if (ds.getKeyExpression().indexOf(oldString) >= 0) {
                                        ds.setKeyExpression(Misc.string_replace(newString, oldString, ds.getKeyExpression()));
                                        add = true;
                                    }
                                    if (ds.getLabelExpression().indexOf(oldString) >= 0) {
                                        ds.setLabelExpression(Misc.string_replace(newString, oldString, ds.getLabelExpression()));
                                        add = true;
                                    }
                                    if (ds.getValueExpression().indexOf(oldString) >= 0) {
                                        ds.setValueExpression(Misc.string_replace(newString, oldString, ds.getValueExpression()));
                                        add = true;
                                    }
                                    if (!ReportRefactor.updateSectionHyperLink(ds.getSectionHyperLink(), oldString, newString)) break block40;
                                    add = true;
                                    break block40;
                                }
                                if (!(dataset instanceof CategoryDataset)) break block41;
                                CategoryDataset ds = (CategoryDataset)dataset;
                                for (int k = 0; k < ds.getCategorySeries().size(); ++k) {
                                    CategorySeries series = (CategorySeries)ds.getCategorySeries().get(k);
                                    if (ReportRefactor.updateSectionHyperLink(series.getSectionItemHyperlink(), oldString, newString)) {
                                        add = true;
                                    }
                                    if (series.getCategoryExpression().indexOf(oldString) >= 0) {
                                        series.setCategoryExpression(Misc.string_replace(newString, oldString, series.getCategoryExpression()));
                                        add = true;
                                    }
                                    if (series.getLabelExpression().indexOf(oldString) >= 0) {
                                        series.setLabelExpression(Misc.string_replace(newString, oldString, series.getLabelExpression()));
                                        add = true;
                                    }
                                    if (series.getSeriesExpression().indexOf(oldString) >= 0) {
                                        series.setSeriesExpression(Misc.string_replace(newString, oldString, series.getSeriesExpression()));
                                        add = true;
                                    }
                                    if (series.getValueExpression().indexOf(oldString) < 0) continue;
                                    series.setValueExpression(Misc.string_replace(newString, oldString, series.getValueExpression()));
                                    add = true;
                                }
                                break block40;
                            }
                            if (!(dataset instanceof HighLowDataset)) break block42;
                            HighLowDataset ds = (HighLowDataset)dataset;
                            if (ReportRefactor.updateSectionHyperLink(ds.getItemHyperLink(), oldString, newString)) {
                                add = true;
                            }
                            if (ds.getCloseExpression().indexOf(oldString) >= 0) {
                                ds.setCloseExpression(Misc.string_replace(newString, oldString, ds.getCloseExpression()));
                                add = true;
                            }
                            if (ds.getDateExpression().indexOf(oldString) >= 0) {
                                ds.setDateExpression(Misc.string_replace(newString, oldString, ds.getDateExpression()));
                                add = true;
                            }
                            if (ds.getHighExpression().indexOf(oldString) >= 0) {
                                ds.setHighExpression(Misc.string_replace(newString, oldString, ds.getHighExpression()));
                                add = true;
                            }
                            if (ds.getLowExpression().indexOf(oldString) >= 0) {
                                ds.setLowExpression(Misc.string_replace(newString, oldString, ds.getLowExpression()));
                                add = true;
                            }
                            if (ds.getOpenExpression().indexOf(oldString) < 0) break block40;
                            ds.setOpenExpression(Misc.string_replace(newString, oldString, ds.getOpenExpression()));
                            add = true;
                            break block40;
                        }
                        if (!(dataset instanceof TimePeriodDataset)) break block43;
                        TimePeriodDataset ds = (TimePeriodDataset)dataset;
                        for (int k = 0; k < ds.getTimePeriodSeries().size(); ++k) {
                            TimePeriodSeries series = (TimePeriodSeries)ds.getTimePeriodSeries().get(k);
                            if (ReportRefactor.updateSectionHyperLink(series.getSectionItemHyperlink(), oldString, newString)) {
                                add = true;
                            }
                            if (series.getEndDateExpression().indexOf(oldString) >= 0) {
                                series.setEndDateExpression(Misc.string_replace(newString, oldString, series.getEndDateExpression()));
                                add = true;
                            }
                            if (series.getLabelExpression().indexOf(oldString) >= 0) {
                                series.setLabelExpression(Misc.string_replace(newString, oldString, series.getLabelExpression()));
                                add = true;
                            }
                            if (series.getSeriesExpression().indexOf(oldString) >= 0) {
                                series.setSeriesExpression(Misc.string_replace(newString, oldString, series.getSeriesExpression()));
                                add = true;
                            }
                            if (series.getStartDateExpression().indexOf(oldString) >= 0) {
                                series.setStartDateExpression(Misc.string_replace(newString, oldString, series.getStartDateExpression()));
                                add = true;
                            }
                            if (series.getValueExpression().indexOf(oldString) < 0) continue;
                            series.setValueExpression(Misc.string_replace(newString, oldString, series.getValueExpression()));
                            add = true;
                        }
                        break block40;
                    }
                    if (!(dataset instanceof TimeSeriesDataset)) break block44;
                    TimeSeriesDataset ds = (TimeSeriesDataset)dataset;
                    for (int k = 0; k < ds.getTimeSeries().size(); ++k) {
                        TimeSeries series = (TimeSeries)ds.getTimeSeries().get(k);
                        if (ReportRefactor.updateSectionHyperLink(series.getSectionItemHyperlink(), oldString, newString)) {
                            add = true;
                        }
                        if (series.getTimePeriodExpression().indexOf(oldString) >= 0) {
                            series.setTimePeriodExpression(Misc.string_replace(newString, oldString, series.getTimePeriodExpression()));
                            add = true;
                        }
                        if (series.getLabelExpression().indexOf(oldString) >= 0) {
                            series.setLabelExpression(Misc.string_replace(newString, oldString, series.getLabelExpression()));
                            add = true;
                        }
                        if (series.getSeriesExpression().indexOf(oldString) >= 0) {
                            series.setSeriesExpression(Misc.string_replace(newString, oldString, series.getSeriesExpression()));
                            add = true;
                        }
                        if (series.getValueExpression().indexOf(oldString) < 0) continue;
                        series.setValueExpression(Misc.string_replace(newString, oldString, series.getValueExpression()));
                        add = true;
                    }
                    break block40;
                }
                if (!(dataset instanceof ValueDataset)) break block45;
                ValueDataset ds = (ValueDataset)dataset;
                if (ds.getValueExpression().indexOf(oldString) < 0) break block40;
                ds.setValueExpression(Misc.string_replace(newString, oldString, ds.getValueExpression()));
                add = true;
                break block40;
            }
            if (dataset instanceof XYDataset) {
                XYDataset ds = (XYDataset)dataset;
                for (int k = 0; k < ds.getXYSeries().size(); ++k) {
                    XYSeries series = (XYSeries)ds.getXYSeries().get(k);
                    if (ReportRefactor.updateSectionHyperLink(series.getSectionItemHyperlink(), oldString, newString)) {
                        add = true;
                    }
                    if (series.getLabelExpression().indexOf(oldString) >= 0) {
                        series.setLabelExpression(Misc.string_replace(newString, oldString, series.getLabelExpression()));
                        add = true;
                    }
                    if (series.getSeriesExpression().indexOf(oldString) >= 0) {
                        series.setSeriesExpression(Misc.string_replace(newString, oldString, series.getSeriesExpression()));
                        add = true;
                    }
                    if (series.getXValueExpression().indexOf(oldString) >= 0) {
                        series.setXValueExpression(Misc.string_replace(newString, oldString, series.getXValueExpression()));
                        add = true;
                    }
                    if (series.getYValueExpression().indexOf(oldString) < 0) continue;
                    series.setYValueExpression(Misc.string_replace(newString, oldString, series.getYValueExpression()));
                    add = true;
                }
            } else if (dataset instanceof XYZDataset) {
                XYZDataset ds = (XYZDataset)dataset;
                for (int k = 0; k < ds.getXYZSeries().size(); ++k) {
                    XYZSeries series = (XYZSeries)ds.getXYZSeries().get(k);
                    if (ReportRefactor.updateSectionHyperLink(series.getSectionItemHyperlink(), oldString, newString)) {
                        add = true;
                    }
                    if (series.getSeriesExpression().indexOf(oldString) >= 0) {
                        series.setSeriesExpression(Misc.string_replace(newString, oldString, series.getSeriesExpression()));
                        add = true;
                    }
                    if (series.getXValueExpression().indexOf(oldString) >= 0) {
                        series.setXValueExpression(Misc.string_replace(newString, oldString, series.getXValueExpression()));
                        add = true;
                    }
                    if (series.getYValueExpression().indexOf(oldString) >= 0) {
                        series.setYValueExpression(Misc.string_replace(newString, oldString, series.getYValueExpression()));
                        add = true;
                    }
                    if (series.getZValueExpression().indexOf(oldString) < 0) continue;
                    series.setZValueExpression(Misc.string_replace(newString, oldString, series.getZValueExpression()));
                    add = true;
                }
            }
        }
        return add;
    }

    public static void replaceInReportExpressions(String oldString, String newString, SubDataset subDataset, Report referenceReport) {
        int i;
        Report report = null;
        if (subDataset instanceof Report) {
            report = (Report)subDataset;
        }
        if (subDataset.getFilterExpression() != null && subDataset.getFilterExpression().indexOf(oldString) >= 0) {
            subDataset.setFilterExpression(Misc.string_replace(newString, oldString, subDataset.getFilterExpression()));
            if (report != null) {
                report.incrementReportChanges();
            }
        }
        if (subDataset.getQuery() != null && subDataset.getQuery().indexOf(oldString) >= 0) {
            subDataset.setQuery(Misc.string_replace(newString, oldString, subDataset.getQuery()));
            subDataset.fireSubDatasetObjectChangedListenerSubDatasetObjectChanged(new SubDatasetObjectChangedEvent(subDataset, 3, 1, subDataset.getQuery(), subDataset.getQuery()));
        }
        for (i = 0; i < subDataset.getVariables().size(); ++i) {
            JRVariable var = (JRVariable)subDataset.getVariables().get(i);
            boolean fireEvent = false;
            if (var.getInitialValueExpression().indexOf(oldString) >= 0) {
                var.setInitialValueExpression(Misc.string_replace(newString, oldString, var.getInitialValueExpression()));
                fireEvent = true;
            }
            if (var.getExpression().indexOf(oldString) >= 0) {
                var.setExpression(Misc.string_replace(newString, oldString, var.getExpression()));
                fireEvent = true;
            }
            if (!fireEvent) continue;
            subDataset.fireSubDatasetObjectChangedListenerSubDatasetObjectChanged(new SubDatasetObjectChangedEvent(subDataset, 1, 1, var, var));
        }
        for (i = 0; i < subDataset.getGroups().size(); ++i) {
            Group grp = (Group)subDataset.getGroups().get(i);
            if (grp.getGroupExpression().indexOf(oldString) < 0) continue;
            grp.setGroupExpression(Misc.string_replace(newString, oldString, grp.getGroupExpression()));
        }
        Vector<ReportElement> changedElements = new Vector<ReportElement>();
        if (subDataset instanceof Report) {
            int i2;
            Report rep = (Report)subDataset;
            for (i2 = 0; i2 < rep.getBands().size(); ++i2) {
                Band band = (Band)rep.getBands().get(i2);
                if (band.getPrintWhenExpression().indexOf(oldString) < 0) continue;
                band.setPrintWhenExpression(Misc.string_replace(newString, oldString, band.getPrintWhenExpression()));
            }
            for (i2 = 0; i2 < rep.getElements().size(); ++i2) {
                Object para;
                int k;
                Object tre;
                boolean add = false;
                ReportElement re = (ReportElement)rep.getElements().get(i2);
                if (re.getPrintWhenExpression().indexOf(oldString) >= 0) {
                    re.setPrintWhenExpression(Misc.string_replace(newString, oldString, re.getPrintWhenExpression()));
                    add = true;
                }
                if (re instanceof TextFieldReportElement && ((TextReportElement)(tre = (TextFieldReportElement)re)).getText().indexOf(oldString) >= 0) {
                    ((TextReportElement)tre).setText(Misc.string_replace(newString, oldString, ((TextReportElement)tre).getText()));
                    add = true;
                }
                if (re instanceof ImageReportElement && ((ImageReportElement)(tre = (ImageReportElement)re)).getImageExpression().indexOf(oldString) >= 0) {
                    ((ImageReportElement)tre).setImageExpression(Misc.string_replace(newString, oldString, ((ImageReportElement)tre).getImageExpression()));
                    add = true;
                }
                if (re instanceof SubReportElement) {
                    tre = (SubReportElement)re;
                    if (((SubReportElement)tre).getSubreportExpression().indexOf(oldString) >= 0) {
                        ((SubReportElement)tre).setSubreportExpression(Misc.string_replace(newString, oldString, ((SubReportElement)tre).getSubreportExpression()));
                        add = true;
                    }
                    if (((SubReportElement)tre).getParametersMapExpression().indexOf(oldString) >= 0) {
                        ((SubReportElement)tre).setParametersMapExpression(Misc.string_replace(newString, oldString, ((SubReportElement)tre).getParametersMapExpression()));
                        add = true;
                    }
                    if (((SubReportElement)tre).getDataSourceExpression().indexOf(oldString) >= 0) {
                        ((SubReportElement)tre).setDataSourceExpression(Misc.string_replace(newString, oldString, ((SubReportElement)tre).getDataSourceExpression()));
                        add = true;
                    }
                    if (((SubReportElement)tre).getConnectionExpression().indexOf(oldString) >= 0) {
                        ((SubReportElement)tre).setConnectionExpression(Misc.string_replace(newString, oldString, ((SubReportElement)tre).getConnectionExpression()));
                        add = true;
                    }
                    for (k = 0; k < ((SubReportElement)tre).getSubreportParameters().size(); ++k) {
                        para = (JRSubreportParameter)((SubReportElement)tre).getSubreportParameters().get(k);
                        if (((JRSubreportParameter)para).getExpression().indexOf(oldString) < 0) continue;
                        ((JRSubreportParameter)para).setExpression(Misc.string_replace(newString, oldString, ((JRSubreportParameter)para).getExpression()));
                        add = true;
                    }
                    for (k = 0; k < ((SubReportElement)tre).getReturnValues().size(); ++k) {
                        para = (JRSubreportReturnValue)((SubReportElement)tre).getReturnValues().get(k);
                        if (!oldString.equals("$V{" + ((JRSubreportReturnValue)para).getToVariable() + "}")) continue;
                        String nv = newString.substring(3, newString.length() - 1);
                        ((JRSubreportReturnValue)para).setToVariable(nv);
                        add = true;
                    }
                }
                if (re instanceof HyperLinkableReportElement) {
                    tre = (HyperLinkableReportElement)((Object)re);
                    if (tre.getAnchorNameExpression().indexOf(oldString) >= 0) {
                        tre.setAnchorNameExpression(Misc.string_replace(newString, oldString, tre.getAnchorNameExpression()));
                        add = true;
                    }
                    if (tre.getHyperlinkAnchorExpression().indexOf(oldString) >= 0) {
                        tre.setHyperlinkAnchorExpression(Misc.string_replace(newString, oldString, tre.getHyperlinkAnchorExpression()));
                        add = true;
                    }
                    if (tre.getHyperlinkPageExpression().indexOf(oldString) >= 0) {
                        tre.setHyperlinkPageExpression(Misc.string_replace(newString, oldString, tre.getHyperlinkPageExpression()));
                        add = true;
                    }
                    if (tre.getHyperlinkReferenceExpression().indexOf(oldString) >= 0) {
                        tre.setHyperlinkReferenceExpression(Misc.string_replace(newString, oldString, tre.getHyperlinkReferenceExpression()));
                        add = true;
                    }
                    for (k = 0; k < tre.getLinkParameters().size(); ++k) {
                        para = (JRLinkParameter)tre.getLinkParameters().get(k);
                        if (((JRLinkParameter)para).getExpression().indexOf(oldString) < 0) continue;
                        ((JRLinkParameter)para).setExpression(Misc.string_replace(newString, oldString, ((JRLinkParameter)para).getExpression()));
                        add = true;
                    }
                }
                if (re instanceof CrosstabReportElement) {
                    tre = (CrosstabReportElement)re;
                    for (k = 0; k < ((CrosstabReportElement)tre).getCrosstabParameters().size(); ++k) {
                        para = (CrosstabParameter)((CrosstabReportElement)tre).getCrosstabParameters().get(k);
                        if (((CrosstabParameter)para).getParameterValueExpression().indexOf(oldString) < 0) continue;
                        ((CrosstabParameter)para).setParameterValueExpression(Misc.string_replace(newString, oldString, ((CrosstabParameter)para).getParameterValueExpression()));
                        add = true;
                    }
                    if (ReportRefactor.updateDatasetRunExpressions(((CrosstabReportElement)tre).getDataset(), oldString, newString)) {
                        add = true;
                    }
                    if ((!((CrosstabReportElement)tre).isUseDataset() || ((CrosstabReportElement)tre).getDataset().getSubDataset() == null) && ReportRefactor.updateDatasetCrosstabExpressions((CrosstabReportElement)tre, oldString, newString)) {
                        add = true;
                    }
                }
                if (re instanceof ChartReportElement2) {
                    tre = (ChartReportElement2)re;
                    if (ReportRefactor.updateDatasetRunExpressions(((ChartReportElement2)tre).getChart().getDataset(), oldString, newString)) {
                        add = true;
                    }
                    if (((ChartReportElement2)tre).getChart().getDataset().getSubDataset() == null && ReportRefactor.updateDatasetExpressions(((ChartReportElement2)tre).getChart().getDataset(), oldString, newString)) {
                        add = true;
                    }
                }
                if (!add) continue;
                changedElements.add(re);
            }
        } else if (referenceReport != null) {
            for (int i3 = 0; i3 < referenceReport.getElements().size(); ++i3) {
                ReportElement tre;
                boolean add = false;
                ReportElement re = (ReportElement)referenceReport.getElements().get(i3);
                if (re instanceof CrosstabReportElement) {
                    tre = (CrosstabReportElement)re;
                    if (((CrosstabReportElement)tre).isUseDataset() && ((CrosstabReportElement)tre).getDataset().getSubDataset() == subDataset && ReportRefactor.updateDatasetCrosstabExpressions((CrosstabReportElement)tre, oldString, newString)) {
                        add = true;
                    }
                } else if (re instanceof ChartReportElement2) {
                    tre = (ChartReportElement2)re;
                    System.out.println("Checking this chart element...");
                    if (((ChartReportElement2)tre).getChart().getDataset().getSubDataset() == subDataset && ReportRefactor.updateDatasetExpressions(((ChartReportElement2)tre).getChart().getDataset(), oldString, newString)) {
                        add = true;
                    }
                }
                if (!add) continue;
                changedElements.add(re);
            }
        }
        if (referenceReport != null && changedElements.size() > 0) {
            CrosstabReportElement cre = referenceReport.getReportFrame().getSelectedCrosstabEditorPanel() != null ? referenceReport.getReportFrame().getSelectedCrosstabEditorPanel().getCrosstabElement() : null;
            referenceReport.getReportFrame().fireReportListenerReportElementsChanged(new ReportElementChangedEvent(referenceReport.getReportFrame(), cre, changedElements, 3));
            referenceReport.getReportFrame().repaint();
            MainFrame.getMainInstance().getElementPropertiesDialog().updateSelection();
        }
    }

    private static boolean updateSectionHyperLink(SectionItemHyperlink tre, String oldString, String newString) {
        boolean add = false;
        if (tre.getHyperlinkAnchorExpression().indexOf(oldString) >= 0) {
            tre.setHyperlinkAnchorExpression(Misc.string_replace(newString, oldString, tre.getHyperlinkAnchorExpression()));
            add = true;
        }
        if (tre.getHyperlinkPageExpression().indexOf(oldString) >= 0) {
            tre.setHyperlinkPageExpression(Misc.string_replace(newString, oldString, tre.getHyperlinkPageExpression()));
            add = true;
        }
        if (tre.getHyperlinkReferenceExpression().indexOf(oldString) >= 0) {
            tre.setHyperlinkReferenceExpression(Misc.string_replace(newString, oldString, tre.getHyperlinkReferenceExpression()));
            add = true;
        }
        for (int k = 0; k < tre.getHyperlinkParameters().size(); ++k) {
            JRLinkParameter para = (JRLinkParameter)tre.getHyperlinkParameters().get(k);
            if (para.getExpression().indexOf(oldString) < 0) continue;
            para.setExpression(Misc.string_replace(newString, oldString, para.getExpression()));
            add = true;
        }
        return add;
    }

    private static boolean updateDatasetCrosstabExpressions(CrosstabReportElement tre, String oldString, String newString) {
        CrosstabGroup grp;
        int i;
        boolean add = false;
        if (ReportRefactor.updateDatasetExpressions(tre.getDataset(), oldString, newString)) {
            add = true;
        }
        for (i = 0; i < tre.getColumnGroups().size(); ++i) {
            grp = (CrosstabGroup)tre.getColumnGroups().get(i);
            if (grp.getBucketExpression().indexOf(oldString) < 0) continue;
            grp.setBucketExpression(Misc.string_replace(newString, oldString, grp.getBucketExpression()));
            add = true;
        }
        for (i = 0; i < tre.getRowGroups().size(); ++i) {
            grp = (CrosstabGroup)tre.getRowGroups().get(i);
            if (grp.getBucketExpression().indexOf(oldString) < 0) continue;
            grp.setBucketExpression(Misc.string_replace(newString, oldString, grp.getBucketExpression()));
            add = true;
        }
        return add;
    }

    private static boolean updateDatasetChartExpressions(ChartReportElement2 tre, String oldString, String newString) {
        int k;
        Plot pl;
        boolean add = false;
        if (ReportRefactor.updateDatasetExpressions(tre.getChart().getDataset(), oldString, newString)) {
            add = true;
        }
        Chart chart = tre.getChart();
        Plot plot = chart.getPlot();
        if (chart.getTitle().getTitleExpression().indexOf(oldString) >= 0) {
            chart.getTitle().setTitleExpression(Misc.string_replace(newString, oldString, chart.getTitle().getTitleExpression()));
            add = true;
        }
        if (chart.getSubTitle().getTitleExpression().indexOf(oldString) >= 0) {
            chart.getSubTitle().setTitleExpression(Misc.string_replace(newString, oldString, chart.getSubTitle().getTitleExpression()));
            add = true;
        }
        if (chart.getPlot() instanceof AreaPlot) {
            pl = (AreaPlot)chart.getPlot();
            if (((AreaPlot)pl).getCategoryAxisLabelExpression().indexOf(oldString) >= 0) {
                ((AreaPlot)pl).setCategoryAxisLabelExpression(Misc.string_replace(newString, oldString, ((AreaPlot)pl).getCategoryAxisLabelExpression()));
                add = true;
            }
            if (((AreaPlot)pl).getValueAxisLabelExpression().indexOf(oldString) >= 0) {
                ((AreaPlot)pl).setValueAxisLabelExpression(Misc.string_replace(newString, oldString, ((AreaPlot)pl).getValueAxisLabelExpression()));
                add = true;
            }
        }
        if (chart.getPlot() instanceof Bar3DPlot) {
            pl = (Bar3DPlot)chart.getPlot();
            if (((Bar3DPlot)pl).getCategoryAxisLabelExpression().indexOf(oldString) >= 0) {
                ((Bar3DPlot)pl).setCategoryAxisLabelExpression(Misc.string_replace(newString, oldString, ((Bar3DPlot)pl).getCategoryAxisLabelExpression()));
                add = true;
            }
            if (((Bar3DPlot)pl).getValueAxisLabelExpression().indexOf(oldString) >= 0) {
                ((Bar3DPlot)pl).setValueAxisLabelExpression(Misc.string_replace(newString, oldString, ((Bar3DPlot)pl).getValueAxisLabelExpression()));
                add = true;
            }
        }
        if (chart.getPlot() instanceof BarPlot) {
            pl = (BarPlot)chart.getPlot();
            if (((BarPlot)pl).getCategoryAxisLabelExpression().indexOf(oldString) >= 0) {
                ((BarPlot)pl).setCategoryAxisLabelExpression(Misc.string_replace(newString, oldString, ((BarPlot)pl).getCategoryAxisLabelExpression()));
                add = true;
            }
            if (((BarPlot)pl).getValueAxisLabelExpression().indexOf(oldString) >= 0) {
                ((BarPlot)pl).setValueAxisLabelExpression(Misc.string_replace(newString, oldString, ((BarPlot)pl).getValueAxisLabelExpression()));
                add = true;
            }
        }
        if (chart.getPlot() instanceof BubblePlot) {
            pl = (BubblePlot)chart.getPlot();
            if (((BubblePlot)pl).getXAxisLabelExpression().indexOf(oldString) >= 0) {
                ((BubblePlot)pl).setXAxisLabelExpression(Misc.string_replace(newString, oldString, ((BubblePlot)pl).getXAxisLabelExpression()));
                add = true;
            }
            if (((BubblePlot)pl).getYAxisLabelExpression().indexOf(oldString) >= 0) {
                ((BubblePlot)pl).setYAxisLabelExpression(Misc.string_replace(newString, oldString, ((BubblePlot)pl).getYAxisLabelExpression()));
                add = true;
            }
        }
        if (chart.getPlot() instanceof CandlestickPlot) {
            pl = (CandlestickPlot)chart.getPlot();
            if (((CandlestickPlot)pl).getTimeAxisLabelExpression().indexOf(oldString) >= 0) {
                ((CandlestickPlot)pl).setTimeAxisLabelExpression(Misc.string_replace(newString, oldString, ((CandlestickPlot)pl).getTimeAxisLabelExpression()));
                add = true;
            }
            if (((CandlestickPlot)pl).getValueAxisLabelExpression().indexOf(oldString) >= 0) {
                ((CandlestickPlot)pl).setValueAxisLabelExpression(Misc.string_replace(newString, oldString, ((CandlestickPlot)pl).getValueAxisLabelExpression()));
                add = true;
            }
        }
        if (chart.getPlot() instanceof HighLowPlot) {
            pl = (HighLowPlot)chart.getPlot();
            if (((HighLowPlot)pl).getTimeAxisLabelExpression().indexOf(oldString) >= 0) {
                ((HighLowPlot)pl).setTimeAxisLabelExpression(Misc.string_replace(newString, oldString, ((HighLowPlot)pl).getTimeAxisLabelExpression()));
                add = true;
            }
            if (((HighLowPlot)pl).getValueAxisLabelExpression().indexOf(oldString) >= 0) {
                ((HighLowPlot)pl).setValueAxisLabelExpression(Misc.string_replace(newString, oldString, ((HighLowPlot)pl).getValueAxisLabelExpression()));
                add = true;
            }
        }
        if (chart.getPlot() instanceof LinePlot) {
            pl = (LinePlot)chart.getPlot();
            if (((LinePlot)pl).getCategoryAxisLabelExpression().indexOf(oldString) >= 0) {
                ((LinePlot)pl).setCategoryAxisLabelExpression(Misc.string_replace(newString, oldString, ((LinePlot)pl).getCategoryAxisLabelExpression()));
                add = true;
            }
            if (((LinePlot)pl).getValueAxisLabelExpression().indexOf(oldString) >= 0) {
                ((LinePlot)pl).setValueAxisLabelExpression(Misc.string_replace(newString, oldString, ((LinePlot)pl).getValueAxisLabelExpression()));
                add = true;
            }
        }
        if (chart.getPlot() instanceof MeterPlot) {
            pl = (MeterPlot)chart.getPlot();
            if (((MeterPlot)pl).getDataRange().getHighExpression().indexOf(oldString) >= 0) {
                ((MeterPlot)pl).getDataRange().setHighExpression(Misc.string_replace(newString, oldString, ((MeterPlot)pl).getDataRange().getHighExpression()));
                add = true;
            }
            if (((MeterPlot)pl).getDataRange().getLowExpression().indexOf(oldString) >= 0) {
                ((MeterPlot)pl).getDataRange().setLowExpression(Misc.string_replace(newString, oldString, ((MeterPlot)pl).getDataRange().getLowExpression()));
                add = true;
            }
            for (k = 0; k < ((MeterPlot)pl).getMeterIntervals().size(); ++k) {
                MeterInterval mi = (MeterInterval)((MeterPlot)pl).getMeterIntervals().get(k);
                if (mi.getDataRange().getHighExpression().indexOf(oldString) >= 0) {
                    mi.getDataRange().setHighExpression(Misc.string_replace(newString, oldString, ((MeterPlot)pl).getDataRange().getHighExpression()));
                    add = true;
                }
                if (mi.getDataRange().getLowExpression().indexOf(oldString) < 0) continue;
                mi.getDataRange().setLowExpression(Misc.string_replace(newString, oldString, ((MeterPlot)pl).getDataRange().getLowExpression()));
                add = true;
            }
        }
        if (chart.getPlot() instanceof MultiAxisPlot) {
            pl = (MultiAxisPlot)chart.getPlot();
            for (k = 0; k < ((MultiAxisPlot)pl).getAxis().size(); ++k) {
                Axis ax = (Axis)((MultiAxisPlot)pl).getAxis().get(k);
                if (ax.getChartReportElement().getChart().getDataset() != chart.getDataset() || !ReportRefactor.updateDatasetChartExpressions(ax.getChartReportElement(), oldString, newString)) continue;
                add = true;
            }
        }
        if (chart.getPlot() instanceof Pie3DPlot) {
            pl = (Pie3DPlot)chart.getPlot();
        }
        if (chart.getPlot() instanceof PiePlot) {
            pl = (PiePlot)chart.getPlot();
        }
        if (chart.getPlot() instanceof ScatterPlot) {
            pl = (ScatterPlot)chart.getPlot();
            if (((ScatterPlot)pl).getXAxisLabelExpression().indexOf(oldString) >= 0) {
                ((ScatterPlot)pl).setXAxisLabelExpression(Misc.string_replace(newString, oldString, ((ScatterPlot)pl).getXAxisLabelExpression()));
                add = true;
            }
            if (((ScatterPlot)pl).getYAxisLabelExpression().indexOf(oldString) >= 0) {
                ((ScatterPlot)pl).setYAxisLabelExpression(Misc.string_replace(newString, oldString, ((ScatterPlot)pl).getYAxisLabelExpression()));
                add = true;
            }
        }
        if (chart.getPlot() instanceof ThermometerPlot) {
            pl = (ThermometerPlot)chart.getPlot();
            if (((ThermometerPlot)pl).getDataRange().getHighExpression().indexOf(oldString) >= 0) {
                ((ThermometerPlot)pl).getDataRange().setHighExpression(Misc.string_replace(newString, oldString, ((ThermometerPlot)pl).getDataRange().getHighExpression()));
                add = true;
            }
            if (((ThermometerPlot)pl).getDataRange().getLowExpression().indexOf(oldString) >= 0) {
                ((ThermometerPlot)pl).getDataRange().setLowExpression(Misc.string_replace(newString, oldString, ((ThermometerPlot)pl).getDataRange().getLowExpression()));
                add = true;
            }
            if (((ThermometerPlot)pl).getHighRange().getHighExpression().indexOf(oldString) >= 0) {
                ((ThermometerPlot)pl).getHighRange().setHighExpression(Misc.string_replace(newString, oldString, ((ThermometerPlot)pl).getHighRange().getHighExpression()));
                add = true;
            }
            if (((ThermometerPlot)pl).getHighRange().getLowExpression().indexOf(oldString) >= 0) {
                ((ThermometerPlot)pl).getHighRange().setLowExpression(Misc.string_replace(newString, oldString, ((ThermometerPlot)pl).getHighRange().getLowExpression()));
                add = true;
            }
            if (((ThermometerPlot)pl).getLowRange().getHighExpression().indexOf(oldString) >= 0) {
                ((ThermometerPlot)pl).getLowRange().setHighExpression(Misc.string_replace(newString, oldString, ((ThermometerPlot)pl).getLowRange().getHighExpression()));
                add = true;
            }
            if (((ThermometerPlot)pl).getLowRange().getLowExpression().indexOf(oldString) >= 0) {
                ((ThermometerPlot)pl).getLowRange().setLowExpression(Misc.string_replace(newString, oldString, ((ThermometerPlot)pl).getLowRange().getLowExpression()));
                add = true;
            }
            if (((ThermometerPlot)pl).getMediumRange().getHighExpression().indexOf(oldString) >= 0) {
                ((ThermometerPlot)pl).getLowRange().setHighExpression(Misc.string_replace(newString, oldString, ((ThermometerPlot)pl).getMediumRange().getHighExpression()));
                add = true;
            }
            if (((ThermometerPlot)pl).getMediumRange().getLowExpression().indexOf(oldString) >= 0) {
                ((ThermometerPlot)pl).getLowRange().setLowExpression(Misc.string_replace(newString, oldString, ((ThermometerPlot)pl).getMediumRange().getLowExpression()));
                add = true;
            }
        }
        if (chart.getPlot() instanceof TimeSeriesPlot) {
            pl = (TimeSeriesPlot)chart.getPlot();
            if (((TimeSeriesPlot)pl).getTimeAxisLabelExpression().indexOf(oldString) >= 0) {
                ((TimeSeriesPlot)pl).setTimeAxisLabelExpression(Misc.string_replace(newString, oldString, ((TimeSeriesPlot)pl).getTimeAxisLabelExpression()));
                add = true;
            }
            if (((TimeSeriesPlot)pl).getValueAxisLabelExpression().indexOf(oldString) >= 0) {
                ((TimeSeriesPlot)pl).setValueAxisLabelExpression(Misc.string_replace(newString, oldString, ((TimeSeriesPlot)pl).getValueAxisLabelExpression()));
                add = true;
            }
        }
        return add;
    }
}

