/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.options.general;

import java.util.prefs.Preferences;
import org.netbeans.core.ProxySettings;
import org.openide.util.NbPreferences;

class GeneralOptionsModel {
    GeneralOptionsModel() {
    }

    private static Preferences getProxyPreferences() {
        return NbPreferences.root().node("org/netbeans/core");
    }

    int getProxyType() {
        return GeneralOptionsModel.getProxyPreferences().getInt("proxyType", 1);
    }

    void setProxyType(int n) {
        if (n != this.getProxyType()) {
            GeneralOptionsModel.getProxyPreferences().putInt("proxyType", n);
        }
    }

    String getHttpProxyHost() {
        return ProxySettings.getHttpHost();
    }

    void setHttpProxyHost(String string) {
        if (!string.equals(this.getHttpProxyHost())) {
            GeneralOptionsModel.getProxyPreferences().put("proxyHttpHost", string);
        }
    }

    String getHttpProxyPort() {
        return ProxySettings.getHttpPort();
    }

    void setHttpProxyPort(String string) {
        if (string != this.getHttpProxyPort()) {
            GeneralOptionsModel.getProxyPreferences().put("proxyHttpPort", GeneralOptionsModel.validatePort(string) ? string : "");
        }
    }

    String getHttpsProxyHost() {
        return ProxySettings.getHttpsHost();
    }

    void setHttpsProxyHost(String string) {
        if (!string.equals(this.getHttpsProxyHost())) {
            GeneralOptionsModel.getProxyPreferences().put("proxyHttpsHost", string);
        }
    }

    String getHttpsProxyPort() {
        return ProxySettings.getHttpsPort();
    }

    void setHttpsProxyPort(String string) {
        if (string != this.getHttpsProxyPort()) {
            GeneralOptionsModel.getProxyPreferences().put("proxyHttpsPort", GeneralOptionsModel.validatePort(string) ? string : "");
        }
    }

    String getSocksHost() {
        return ProxySettings.getSocksHost();
    }

    void setSocksHost(String string) {
        if (string != this.getSocksHost()) {
            GeneralOptionsModel.getProxyPreferences().put("proxySocksHost", string);
        }
    }

    String getSocksPort() {
        return ProxySettings.getSocksPort();
    }

    void setSocksPort(String string) {
        if (string != this.getSocksPort()) {
            GeneralOptionsModel.getProxyPreferences().put("proxySocksPort", GeneralOptionsModel.validatePort(string) ? string : "");
        }
    }

    String getNonProxyHosts() {
        return GeneralOptionsModel.code2view(ProxySettings.getNonProxyHosts());
    }

    void setNonProxyHosts(String string) {
        if (!string.equals(this.getNonProxyHosts())) {
            GeneralOptionsModel.getProxyPreferences().put("proxyNonProxyHosts", GeneralOptionsModel.view2code(string));
        }
    }

    boolean useProxyAuthentication() {
        return ProxySettings.useAuthentication();
    }

    void setUseProxyAuthentication(boolean bl) {
        if (bl != this.useProxyAuthentication()) {
            GeneralOptionsModel.getProxyPreferences().putBoolean("useProxyAuthentication", bl);
        }
    }

    boolean useProxyAllProtocols() {
        return ProxySettings.useProxyAllProtocols();
    }

    void setUseProxyAllProtocols(boolean bl) {
        if (bl != this.useProxyAllProtocols()) {
            GeneralOptionsModel.getProxyPreferences().putBoolean("useProxyAllProtocols", bl);
        }
    }

    String getProxyAuthenticationUsername() {
        return ProxySettings.getAuthenticationUsername();
    }

    void setAuthenticationUsername(String string) {
        GeneralOptionsModel.getProxyPreferences().put("proxyAuthenticationUsername", string);
    }

    char[] getProxyAuthenticationPassword() {
        return ProxySettings.getAuthenticationPassword();
    }

    void setAuthenticationPassword(char[] cArray) {
        GeneralOptionsModel.getProxyPreferences().put("proxyAuthenticationPassword", new String(cArray));
    }

    private static boolean validatePort(String string) {
        boolean bl;
        block3: {
            if (string.trim().length() == 0) {
                return true;
            }
            bl = false;
            try {
                Integer.parseInt(string);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)numberFormatException);
            }
        }
        return bl;
    }

    private static String code2view(String string) {
        return string == null ? string : string.replace("|", ", ");
    }

    private static String view2code(String string) {
        return string == null ? string : string.replace(", ", "|");
    }
}

