/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class JDBCMetaData {
    String jdbcDriverClassName = null;
    String jdbcConnectionUrl = null;
    Connection conn = null;
    DatabaseMetaData md = null;
    private Map allFactTableDimensions = new HashMap();
    private Map allTablesPKs = new HashMap();
    private Map allTablesCols = new HashMap();
    private Map allSchemasMap = new HashMap();
    private Vector allSchemas = new Vector();
    private String errMsg = null;
    private Database db = new Database();

    public JDBCMetaData(String jdbcDriverClassName, String jdbcConnectionUrl) {
        this.jdbcConnectionUrl = jdbcConnectionUrl;
        this.jdbcDriverClassName = jdbcDriverClassName;
        if (this.initConnection() == null) {
            this.setAllSchemas();
            this.closeConnection();
        }
    }

    public String initConnection() {
        try {
            if (this.jdbcDriverClassName == null || this.jdbcConnectionUrl == null) {
                throw new Exception("Driver=" + this.jdbcDriverClassName + "\nConn Url=" + this.jdbcConnectionUrl + "\n(Hint: Use Prefrences to set Database Connection parameters first and then open a Schema.)");
            }
            Class.forName(this.jdbcDriverClassName);
            this.conn = DriverManager.getConnection(this.jdbcConnectionUrl);
            System.out.println("JDBC connection OPEN");
            this.md = this.conn.getMetaData();
            this.db.productName = this.md.getDatabaseProductName();
            this.db.productVersion = this.md.getDatabaseProductVersion();
            this.db.catalogName = this.conn.getCatalog();
            System.out.println("Catalog name = " + this.db.catalogName);
            System.out.println("Database Product Name: " + this.db.productName);
            System.out.println("Database Product Version: " + this.db.productVersion);
            return null;
        }
        catch (Exception e) {
            this.errMsg = e.getMessage();
            System.out.println("Database connection exception : " + this.errMsg);
            return this.errMsg;
        }
    }

    public void closeConnection() {
        try {
            this.conn.close();
            System.out.println("JDBC connection CLOSE");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setAllSchemas() {
        ResultSet rs = null;
        try {
            rs = this.md.getSchemas();
            while (rs.next()) {
                DbSchema dbs = new DbSchema();
                dbs.name = rs.getString("TABLE_SCHEM");
                this.setAllTables(dbs);
                this.db.addDbSchema(dbs);
            }
            rs.close();
        }
        catch (Exception e) {
            System.out.println("Exception : Database does not support schemas." + e.getMessage());
            DbSchema dbs = new DbSchema();
            dbs.name = null;
            this.setAllTables(dbs);
            this.db.addDbSchema(dbs);
        }
    }

    private void setAllTables(DbSchema dbs) {
        ResultSet rs = null;
        try {
            rs = this.md.getTables(null, dbs.name, null, new String[]{"TABLE"});
            while (rs.next()) {
                DbTable dbt;
                String tbname = rs.getString("TABLE_NAME");
                ResultSet rs_fks = this.md.getImportedKeys(null, dbs.name, tbname);
                if (rs_fks.next()) {
                    dbt = new FactTable();
                    do {
                        ((FactTable)dbt).addFks(rs_fks.getString("FKCOLUMN_NAME"), rs_fks.getString("pktable_name"));
                    } while (rs_fks.next());
                } else {
                    dbt = new DbTable();
                }
                rs_fks.close();
                dbt.schemaName = dbs.name;
                dbt.name = tbname;
                this.setPKey(dbt);
                this.setColumns(dbt);
                dbs.addDbTable(dbt);
                this.db.addDbTable(dbt);
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setPKey(DbTable dbt) {
        ResultSet rs = null;
        try {
            rs = this.md.getPrimaryKeys(null, dbt.schemaName, dbt.name);
            if (rs.next()) {
                dbt.pk = rs.getString("column_name");
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setColumns(DbTable dbt) {
        ResultSet rs = null;
        try {
            rs = this.md.getColumns(null, dbt.schemaName, dbt.name, null);
            while (rs.next()) {
                dbt.addColsDataType(rs.getString("COLUMN_NAME"), rs.getString("DATA_TYPE"));
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Vector getAllSchemas() {
        return this.db.getAllSchemas();
    }

    public Vector getAllTables(String schemaName) {
        return this.db.getAllTables(schemaName);
    }

    public Vector getAllTables(String schemaName, String minusTable) {
        if (minusTable == null) {
            return this.getAllTables(schemaName);
        }
        Vector<String> allTablesMinusOne = new Vector<String>();
        for (String s : this.getAllTables(schemaName)) {
            if (s.endsWith(minusTable) && (schemaName == null || s.startsWith(schemaName))) continue;
            allTablesMinusOne.add(s);
        }
        return allTablesMinusOne;
    }

    public Vector getFactTables(String schemaName) {
        return this.db.getFactTables(schemaName);
    }

    public Vector getDimensionTables(String schemaName, String factTable) {
        Vector dimeTables = new Vector();
        if (factTable == null) {
            return dimeTables;
        }
        return this.db.getDimensionTables(schemaName, factTable);
    }

    public boolean isTableExists(String schemaName, String tableName) {
        if (tableName == null) {
            return true;
        }
        return this.db.tableExists(schemaName, tableName);
    }

    public boolean isColExists(String schemaName, String tableName, String colName) {
        if (tableName == null || colName == null) {
            return true;
        }
        return this.db.colExists(schemaName, tableName, colName);
    }

    public Vector getFactTableFKs(String schemaName, String factTable) {
        Vector fks = new Vector();
        if (factTable == null) {
            return fks;
        }
        return this.db.getFactTableFKs(schemaName, factTable);
    }

    public String getTablePK(String schemaName, String tableName) {
        if (tableName == null) {
            return null;
        }
        return this.db.getTablePK(schemaName, tableName);
    }

    public Vector getAllColumns(String schemaName, String tableName) {
        Vector allcols = new Vector();
        if (tableName == null) {
            return allcols;
        }
        return this.db.getAllColumns(schemaName, tableName);
    }

    public int getColumnDataType(String schemaName, String tableName, String colName) {
        if (tableName == null || colName == null) {
            return -1;
        }
        return this.db.getColumnDataType(schemaName, tableName, colName);
    }

    public String getDbCatalogName() {
        return this.db.catalogName;
    }

    public String getDatabaseProductName() {
        return this.db.productName;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public static void main(String[] args) {
        String s = "somita->namita";
        String[] p = s.split("->");
        if (p.length >= 2) {
            System.out.println("p0=" + p[0] + ", p1=" + p[1]);
        }
    }

    class FactTable
    extends DbTable {
        Map fks;

        FactTable() {
            this.fks = new TreeMap();
        }

        private void addFks(String fk, String pkt) {
            this.fks.put(fk, pkt);
        }
    }

    class DbTable {
        String schemaName;
        String name;
        String pk;
        Map colsDataType = new TreeMap();

        DbTable() {
        }

        private void addColsDataType(String col, String dataType) {
            this.colsDataType.put(col, dataType);
        }
    }

    class DbSchema {
        String name;
        List tables = new ArrayList();

        DbSchema() {
        }

        private void addDbTable(DbTable dbt) {
            this.tables.add(dbt);
        }
    }

    class Database {
        String catalogName = "";
        String productName = "Unknown";
        String productVersion = "";
        List schemas = new ArrayList();
        List tables = new ArrayList();
        Map tablesCount = new TreeMap();
        Vector allSchemas;

        Database() {
        }

        private void addDbSchema(DbSchema dbs) {
            this.schemas.add(dbs);
        }

        private void addDbTable(DbTable dbs) {
            this.tables.add(dbs);
            Integer count = (Integer)this.tablesCount.get(dbs.name);
            count = count == null ? new Integer(1) : new Integer(count + 1);
            this.tablesCount.put(dbs.name, count);
        }

        private Vector getAllSchemas() {
            if (this.allSchemas == null) {
                this.allSchemas = new Vector();
                if (this.schemas.size() > 0) {
                    Iterator i = this.schemas.iterator();
                    while (i.hasNext()) {
                        this.allSchemas.add(((DbSchema)i.next()).name);
                    }
                }
            }
            return this.allSchemas;
        }

        private boolean tableExists(String sname, String tableName) {
            if (sname == null || sname.equals("")) {
                return this.tablesCount.containsKey(tableName);
            }
            for (DbSchema s : this.schemas) {
                if (!s.name.equals(sname)) continue;
                for (DbTable d : s.tables) {
                    if (!d.name.equals(tableName)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean colExists(String sname, String tableName, String colName) {
            if (sname == null || sname.equals("")) {
                for (DbTable t : this.tables) {
                    if (!t.name.equals(tableName)) continue;
                    return t.colsDataType.containsKey(colName);
                }
            } else {
                for (DbSchema s : this.schemas) {
                    if (!s.name.equals(sname)) continue;
                    for (DbTable t : s.tables) {
                        if (!t.name.equals(tableName)) continue;
                        return t.colsDataType.containsKey(colName);
                    }
                    break;
                }
            }
            return false;
        }

        private Vector getAllTables(String sname) {
            Vector<String> v = new Vector<String>();
            if (sname == null || sname.equals("")) {
                for (DbTable d : this.tables) {
                    if (d.schemaName == null) {
                        v.add(d.name);
                        continue;
                    }
                    v.add(d.schemaName + "->" + d.name);
                }
            } else {
                for (DbSchema s : this.schemas) {
                    if (!s.name.equals(sname)) continue;
                    for (DbTable d : s.tables) {
                        v.add(d.name);
                    }
                    break;
                }
            }
            return v;
        }

        private Vector getFactTables(String sname) {
            Vector<String> f = new Vector<String>();
            if (sname == null || sname.equals("")) {
                for (DbTable t : this.tables) {
                    if (!(t instanceof FactTable)) continue;
                    if (t.schemaName == null) {
                        f.add(t.name);
                        continue;
                    }
                    f.add(t.schemaName + "->" + t.name);
                }
            } else {
                for (DbSchema s : this.schemas) {
                    if (!s.name.equals(sname)) continue;
                    for (Object t : s.tables) {
                        if (!(t instanceof FactTable)) continue;
                        f.add(((FactTable)t).name);
                    }
                    break;
                }
            }
            return f;
        }

        private Vector getFactTableFKs(String sname, String factTable) {
            Vector<String> f;
            block8: {
                f = new Vector<String>();
                if (sname == null || sname.equals("")) {
                    boolean duplicate = this.tablesCount.containsKey(factTable) && (Integer)this.tablesCount.get(factTable) > 1;
                    for (DbTable t : this.tables) {
                        if (!(t instanceof FactTable) || !t.name.equals(factTable)) continue;
                        if (duplicate) {
                            for (String fk : ((FactTable)t).fks.keySet()) {
                                if (t.schemaName == null) {
                                    f.add(t.name + "->" + fk);
                                    continue;
                                }
                                f.add(t.schemaName + "->" + t.name + "->" + fk);
                            }
                            continue;
                        }
                        f.addAll(((FactTable)t).fks.keySet());
                    }
                } else {
                    for (DbSchema s : this.schemas) {
                        if (!s.name.equals(sname)) continue;
                        for (DbTable t : s.tables) {
                            if (!(t instanceof FactTable) || !t.name.equals(factTable)) continue;
                            f.addAll(((FactTable)t).fks.keySet());
                            break block8;
                        }
                        break;
                    }
                }
            }
            return f;
        }

        private Vector getDimensionTables(String sname, String factTable) {
            Vector<String> f;
            block8: {
                f = new Vector<String>();
                if (sname == null || sname.equals("")) {
                    boolean duplicate = this.tablesCount.containsKey(factTable) && (Integer)this.tablesCount.get(factTable) > 1;
                    for (DbTable t : this.tables) {
                        if (!(t instanceof FactTable) || !t.name.equals(factTable)) continue;
                        if (duplicate) {
                            for (String fkt : ((FactTable)t).fks.values()) {
                                if (t.schemaName == null) {
                                    f.add(t.name + "->" + fkt);
                                    continue;
                                }
                                f.add(t.schemaName + "->" + t.name + "->" + fkt);
                            }
                            continue;
                        }
                        f.addAll(((FactTable)t).fks.values());
                        break;
                    }
                } else {
                    for (DbSchema s : this.schemas) {
                        if (!s.name.equals(sname)) continue;
                        for (DbTable t : s.tables) {
                            if (!(t instanceof FactTable) || !t.name.equals(factTable)) continue;
                            f.addAll(((FactTable)t).fks.values());
                            break block8;
                        }
                        break;
                    }
                }
            }
            return f;
        }

        private String getTablePK(String sname, String tableName) {
            if (sname == null || sname.equals("")) {
                for (DbTable t : this.tables) {
                    if (!t.name.equals(tableName)) continue;
                    return t.pk;
                }
            } else {
                for (DbSchema s : this.schemas) {
                    if (!s.name.equals(sname)) continue;
                    for (DbTable t : s.tables) {
                        if (!t.name.equals(tableName)) continue;
                        return t.pk;
                    }
                    break;
                }
            }
            return null;
        }

        private Vector getAllColumns(String sname, String tableName) {
            Vector<String> f;
            block8: {
                f = new Vector<String>();
                if (sname == null || sname.equals("")) {
                    boolean duplicate = this.tablesCount.containsKey(tableName) && (Integer)this.tablesCount.get(tableName) > 1;
                    for (DbTable t : this.tables) {
                        if (!t.name.equals(tableName)) continue;
                        if (duplicate) {
                            for (String c : t.colsDataType.keySet()) {
                                if (t.schemaName == null) {
                                    f.add(t.name + "->" + c);
                                    continue;
                                }
                                f.add(t.schemaName + "->" + t.name + "->" + c);
                            }
                            continue;
                        }
                        f.addAll(t.colsDataType.keySet());
                        break;
                    }
                } else {
                    for (DbSchema s : this.schemas) {
                        if (!s.name.equals(sname)) continue;
                        for (DbTable t : s.tables) {
                            if (!t.name.equals(tableName)) continue;
                            f.addAll(t.colsDataType.keySet());
                            break block8;
                        }
                        break;
                    }
                }
            }
            return f;
        }

        private int getColumnDataType(String sname, String tableName, String colName) {
            if (sname == null || sname.equals("")) {
                for (DbTable t : this.tables) {
                    if (!t.name.equals(tableName)) continue;
                    int dataType = Integer.parseInt((String)t.colsDataType.get(colName));
                    return dataType;
                }
            } else {
                for (DbSchema s : this.schemas) {
                    if (!s.name.equals(sname)) continue;
                    for (DbTable t : s.tables) {
                        if (!t.name.equals(tableName)) continue;
                        int dataType = Integer.parseInt((String)t.colsDataType.get(colName));
                        return dataType;
                    }
                    break;
                }
            }
            return -1;
        }
    }
}

