/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import mondrian.gui.JDBCMetaData;
import mondrian.gui.MondrianGuiDef;
import mondrian.gui.PropertyTableModel;
import mondrian.gui.SchemaExplorer;
import mondrian.gui.SchemaPropertyCellRenderer;

public class SchemaPropertyCellEditor
implements TableCellEditor {
    ArrayList listeners;
    JTextField stringEditor;
    JCheckBox booleanEditor;
    JTextField integerEditor;
    JTable tableEditor;
    Component activeEditor;
    JComboBox listEditor;
    JComboBox relationList;
    JTable relationTable;
    JPanel relationRenderer;
    JDBCMetaData jdbcMetaData;
    ComboBoxModel allOptions;
    ComboBoxModel selOptions;
    String listEditorValue;
    MouseListener ml;
    ItemListener il;
    ActionListener al;
    String noSelect = "-- No Selection --";
    FocusAdapter editorFocus;
    private String cacheCube = "";
    private String cacheHierarchy = "";
    private Vector hlevels = new Vector();

    public SchemaPropertyCellEditor(JDBCMetaData jdbcMetaData) {
        this();
        this.jdbcMetaData = jdbcMetaData;
    }

    public SchemaPropertyCellEditor() {
        this.listeners = new ArrayList();
        this.stringEditor = new JTextField();
        this.stringEditor.setFont(Font.decode("Dialog"));
        this.stringEditor.setBorder(null);
        this.booleanEditor = new JCheckBox();
        this.booleanEditor.setBackground(Color.white);
        this.integerEditor = new JTextField();
        this.integerEditor.setBorder(null);
        this.integerEditor.setHorizontalAlignment(4);
        this.integerEditor.setFont(Font.decode("Courier"));
        this.tableEditor = new JTable();
        this.listEditor = new JComboBox();
        this.listEditor.setEditable(true);
        this.listEditor.setMaximumSize(this.stringEditor.getMaximumSize());
        this.listEditor.setFont(Font.decode("Dialog"));
        this.listEditor.setBackground(Color.white);
        this.listEditor.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.al = new ActionListener(){
            boolean all = true;

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("comboBoxChanged") && SchemaPropertyCellEditor.this.listEditor.getSelectedIndex() == 0) {
                    if (this.all) {
                        SchemaPropertyCellEditor.this.listEditor.setModel(SchemaPropertyCellEditor.this.allOptions);
                    } else {
                        SchemaPropertyCellEditor.this.listEditor.setModel(SchemaPropertyCellEditor.this.selOptions);
                    }
                    SchemaPropertyCellEditor.this.listEditor.setSelectedIndex(-1);
                    boolean bl = this.all = !this.all;
                }
                if (SchemaPropertyCellEditor.this.listEditor.isDisplayable()) {
                    SchemaPropertyCellEditor.this.listEditor.setPopupVisible(true);
                }
            }
        };
        JTextComponent editor = (JTextComponent)this.listEditor.getEditor().getEditorComponent();
        editor.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (SchemaPropertyCellEditor.this.listEditor.isDisplayable()) {
                    SchemaPropertyCellEditor.this.listEditor.setPopupVisible(true);
                }
            }
        });
        editor.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (SchemaPropertyCellEditor.this.listEditor.isDisplayable()) {
                    SchemaPropertyCellEditor.this.listEditor.setPopupVisible(true);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    SchemaPropertyCellEditor.this.listEditor.setSelectedItem(SchemaPropertyCellEditor.this.listEditorValue);
                    SchemaPropertyCellEditor.this.listEditor.getEditor().setItem(SchemaPropertyCellEditor.this.listEditorValue);
                }
            }
        });
        this.relationRenderer = new JPanel();
        this.relationList = new JComboBox<String>(new String[]{"Join", "Table"});
        this.relationList.setMaximumSize(this.stringEditor.getMaximumSize());
        this.relationTable = new JTable();
        this.relationRenderer.add(this.relationList);
        this.relationRenderer.add(this.relationTable);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        PropertyTableModel tableModel = (PropertyTableModel)table.getModel();
        Class<?> parentClassz = null;
        if (tableModel.getParentTarget() != null) {
            parentClassz = tableModel.getParentTarget().getClass();
        }
        Class<?> targetClassz = tableModel.target.getClass();
        String propertyName = tableModel.getRowName(row);
        String selectedFactTable = tableModel.getFactTable();
        String selectedFactTableSchema = tableModel.getFactTableSchema();
        this.listEditorValue = null;
        if (targetClassz == MondrianGuiDef.UserDefinedFunction.class && propertyName.equals("className")) {
            Vector udfs = this.getUdfs();
            DefaultComboBoxModel cAlludfs = new DefaultComboBoxModel(udfs);
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAlludfs);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Measure.class && propertyName.equals("formatString")) {
            Vector formatStrs = this.getFormatStrings();
            DefaultComboBoxModel cAllformatStrs = new DefaultComboBoxModel(formatStrs);
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllformatStrs);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Measure.class && propertyName.equals("aggregator")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Measure._aggregator_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Measure.class && propertyName.equals("datatype")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Measure._datatype_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.SQL.class && propertyName.equals("dialect")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.SQL._dialect_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Level.class && propertyName.equals("hideMemberIf")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Level._hideMemberIf_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Level.class && propertyName.equals("levelType")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Level._levelType_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Level.class && propertyName.equals("type")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Level._type_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Dimension.class && propertyName.equals("type")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Dimension._type_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.DimensionUsage.class && propertyName.equals("source")) {
            Vector source = this.getSource();
            DefaultComboBoxModel cAllsource = new DefaultComboBoxModel(source);
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllsource);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if ((tableModel.target instanceof MondrianGuiDef.Grant || tableModel.target instanceof MondrianGuiDef.MemberGrant) && propertyName.equals("access")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            DefaultComboBoxModel<String> cAccess = new DefaultComboBoxModel<String>(MondrianGuiDef.Grant._access_values);
            if (targetClassz == MondrianGuiDef.SchemaGrant.class) {
                cAccess = new DefaultComboBoxModel<String>(new String[]{"all", "none", "all_dimensions"});
            } else if (targetClassz == MondrianGuiDef.CubeGrant.class || targetClassz == MondrianGuiDef.DimensionGrant.class || targetClassz == MondrianGuiDef.MemberGrant.class) {
                cAccess = new DefaultComboBoxModel<String>(new String[]{"all", "none"});
            } else if (targetClassz == MondrianGuiDef.HierarchyGrant.class) {
                cAccess = new DefaultComboBoxModel<String>(new String[]{"all", "none", "custom"});
            }
            this.listEditor.setModel(cAccess);
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.DimensionGrant.class && propertyName.equals("dimension") || targetClassz == MondrianGuiDef.HierarchyGrant.class && propertyName.equals("hierarchy")) {
            Vector source = this.getDimensions();
            DefaultComboBoxModel cAllsource = new DefaultComboBoxModel(source);
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllsource);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.HierarchyGrant.class && (propertyName.equals("topLevel") || propertyName.equals("bottomLevel"))) {
            Vector source = this.getLevels(((MondrianGuiDef.HierarchyGrant)((Object)tableModel.target)).hierarchy);
            DefaultComboBoxModel cAllsource = new DefaultComboBoxModel(source);
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllsource);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if ((targetClassz == MondrianGuiDef.VirtualCubeDimension.class || targetClassz == MondrianGuiDef.VirtualCubeMeasure.class) && propertyName.equals("cubeName") || targetClassz == MondrianGuiDef.CubeGrant.class && propertyName.equals("cube")) {
            Vector source = this.getCubes();
            DefaultComboBoxModel cAllsource = new DefaultComboBoxModel(source);
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllsource);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Dimension.class && propertyName.equals("foreignKey") || targetClassz == MondrianGuiDef.DimensionUsage.class && propertyName.equals("foreignKey") || targetClassz == MondrianGuiDef.Measure.class && propertyName.equals("column")) {
            Vector<String> fks = new Vector<String>(this.jdbcMetaData.getFactTableFKs(selectedFactTableSchema, selectedFactTable));
            fks.add(0, "<< All Columns >>");
            Vector<String> allcols = new Vector<String>(this.jdbcMetaData.getAllColumns(selectedFactTableSchema, selectedFactTable));
            DefaultComboBoxModel cFks = new DefaultComboBoxModel(fks);
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            if (fks.size() > 1 && propertyName.equals("foreignKey")) {
                allcols.add(0, "<< Foreign keys >>");
                DefaultComboBoxModel cAllcols = new DefaultComboBoxModel(allcols);
                this.listEditor.setModel(cFks);
                this.selOptions = cFks;
                this.allOptions = cAllcols;
                this.listEditor.addActionListener(this.al);
            } else {
                DefaultComboBoxModel cAllcols = new DefaultComboBoxModel(allcols);
                this.listEditor.setModel(cAllcols);
            }
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Hierarchy.class && propertyName.equals("primaryKey")) {
            MondrianGuiDef.Hierarchy hProps = (MondrianGuiDef.Hierarchy)((Object)tableModel.getValue());
            String pkTable = hProps.primaryKeyTable;
            String schemaName = null;
            Vector allcols = this.jdbcMetaData.getAllColumns(schemaName, pkTable);
            String pk = this.jdbcMetaData.getTablePK(schemaName, pkTable);
            DefaultComboBoxModel cAllcols = new DefaultComboBoxModel(allcols);
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllcols);
            if (value == null || ((String)value).equals("")) {
                this.listEditor.setSelectedItem(pk);
            } else {
                this.listEditor.setSelectedItem((String)value);
                this.listEditorValue = (String)value;
            }
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Level.class && propertyName.equals("column") || targetClassz == MondrianGuiDef.Property.class && propertyName.equals("column")) {
            MondrianGuiDef.Level lProps = targetClassz == MondrianGuiDef.Level.class ? (MondrianGuiDef.Level)((Object)tableModel.getValue()) : (MondrianGuiDef.Level)((Object)this.getParentObject());
            String lTable = lProps.table;
            Vector allcols = this.jdbcMetaData.getAllColumns(null, lTable);
            DefaultComboBoxModel cAllcols = new DefaultComboBoxModel(allcols);
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllcols);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Property.class && propertyName.equals("type")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Property._type_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Table.class && propertyName.equals("schema")) {
            Vector allschemas = this.jdbcMetaData.getAllSchemas();
            DefaultComboBoxModel cAllschemas = new DefaultComboBoxModel(allschemas);
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllschemas);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Table.class && propertyName.equals("name") || targetClassz == MondrianGuiDef.Hierarchy.class && propertyName.equals("primaryKeyTable") || targetClassz == MondrianGuiDef.Level.class && propertyName.equals("table")) {
            String schema = "";
            if (targetClassz == MondrianGuiDef.Table.class) {
                MondrianGuiDef.Table tProps = (MondrianGuiDef.Table)((Object)tableModel.getValue());
                schema = tProps.schema;
            }
            Vector factTables = new Vector(this.jdbcMetaData.getFactTables(schema));
            Vector allTablesMinusFact = new Vector(this.jdbcMetaData.getAllTables(schema, selectedFactTable));
            Vector allTables = new Vector(this.jdbcMetaData.getAllTables(schema));
            Vector dimeTables = new Vector(this.jdbcMetaData.getDimensionTables(schema, selectedFactTable));
            DefaultComboBoxModel<String> cFactTables = new DefaultComboBoxModel<String>(factTables);
            DefaultComboBoxModel<String> cAllTables = new DefaultComboBoxModel<String>(allTablesMinusFact.size() > 0 ? allTablesMinusFact : allTables);
            DefaultComboBoxModel<String> cDimeTables = new DefaultComboBoxModel<String>(dimeTables);
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllTables);
            this.allOptions = cAllTables;
            boolean toggleModel = false;
            if (parentClassz == MondrianGuiDef.Cube.class) {
                this.allOptions = cAllTables = new DefaultComboBoxModel(allTables);
                if (factTables.size() > 0) {
                    cFactTables.insertElementAt("<< All Tables >>", 0);
                    cAllTables.insertElementAt("<< Fact Tables >>", 0);
                    this.listEditor.setModel(cFactTables);
                    this.selOptions = cFactTables;
                    toggleModel = true;
                }
            } else if (dimeTables.size() > 0) {
                cDimeTables.insertElementAt("<< All Tables >>", 0);
                cAllTables.insertElementAt("<< Dimension Tables >>", 0);
                this.listEditor.setModel(cDimeTables);
                this.selOptions = cDimeTables;
                toggleModel = true;
            }
            if (toggleModel) {
                this.listEditor.addActionListener(this.al);
            }
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (value instanceof String) {
            this.activeEditor = this.stringEditor;
            this.stringEditor.setText((String)value);
        } else if (value instanceof Boolean) {
            this.activeEditor = this.booleanEditor;
            this.booleanEditor.setSelected((Boolean)value);
        } else if (value instanceof Integer) {
            this.activeEditor = this.integerEditor;
            this.integerEditor.setText((String)value);
        } else if (value == null) {
            value = "";
            this.activeEditor = this.stringEditor;
            this.stringEditor.setText((String)value);
        } else if (value.getClass() == MondrianGuiDef.Join.class) {
            SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor();
            this.tableEditor.setDefaultEditor(Object.class, spce);
            SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
            this.tableEditor.setDefaultRenderer(Object.class, spcr);
            PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_JOIN);
            this.tableEditor.setModel(ptm);
            this.activeEditor = this.tableEditor;
        } else {
            if (value.getClass() == MondrianGuiDef.NameExpression.class) {
                return null;
            }
            if (value.getClass() == MondrianGuiDef.Relation.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor();
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_RELATION);
                this.tableEditor.setModel(ptm);
                this.activeEditor = this.tableEditor;
                return null;
            }
            if (value.getClass() == MondrianGuiDef.OrdinalExpression.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor();
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel((Object)((MondrianGuiDef.OrdinalExpression)((Object)value)).expressions[0], SchemaExplorer.DEF_SQL);
                ptm.setParentTarget(((PropertyTableModel)table.getModel()).target);
                this.tableEditor.setModel(ptm);
                this.activeEditor = this.tableEditor;
            } else if (value.getClass() == MondrianGuiDef.Formula.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.jdbcMetaData);
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_FORMULA);
                this.tableEditor.setModel(ptm);
                this.tableEditor.getColumnModel().getColumn(0).setMaxWidth(100);
                this.tableEditor.getColumnModel().getColumn(0).setMinWidth(100);
                this.activeEditor = this.tableEditor;
            } else if (value.getClass() == MondrianGuiDef.CalculatedMemberProperty.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.jdbcMetaData);
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_CALCULATED_MEMBER_PROPERTY);
                this.tableEditor.setModel(ptm);
                this.tableEditor.getColumnModel().getColumn(0).setMaxWidth(100);
                this.tableEditor.getColumnModel().getColumn(0).setMinWidth(100);
                this.activeEditor = this.tableEditor;
            } else if (value.getClass() == MondrianGuiDef.Table.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.jdbcMetaData);
                for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    spce.addCellEditorListener((CellEditorListener)this.listeners.get(i));
                }
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_TABLE);
                ptm.setFactTable(selectedFactTable);
                if (targetClassz == MondrianGuiDef.Cube.class) {
                    ptm.setParentTarget(((PropertyTableModel)table.getModel()).target);
                }
                this.tableEditor.setModel(ptm);
                this.tableEditor.getColumnModel().getColumn(0).setMaxWidth(100);
                this.tableEditor.getColumnModel().getColumn(0).setMinWidth(100);
                this.activeEditor = this.tableEditor;
            } else if (value.getClass() == MondrianGuiDef.AggFactCount.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.jdbcMetaData);
                for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    spce.addCellEditorListener((CellEditorListener)this.listeners.get(i));
                }
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_AGG_FACT_COUNT);
                ptm.setFactTable(selectedFactTable);
                this.tableEditor.setModel(ptm);
                this.tableEditor.getColumnModel().getColumn(0).setMaxWidth(100);
                this.tableEditor.getColumnModel().getColumn(0).setMinWidth(100);
                this.activeEditor = this.tableEditor;
            } else if (value.getClass() == MondrianGuiDef.Closure.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.jdbcMetaData);
                for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    spce.addCellEditorListener((CellEditorListener)this.listeners.get(i));
                }
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_CLOSURE);
                ptm.setFactTable(selectedFactTable);
                if (targetClassz == MondrianGuiDef.Level.class) {
                    ptm.setParentTarget(((PropertyTableModel)table.getModel()).target);
                }
                this.tableEditor.setModel(ptm);
                this.tableEditor.getColumnModel().getColumn(0).setMaxWidth(100);
                this.tableEditor.getColumnModel().getColumn(0).setMinWidth(100);
                spcr.setTableRendererHeight(this.tableEditor, null);
                this.activeEditor = this.tableEditor;
            } else if (value.getClass() == MondrianGuiDef.Property.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor();
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_PROPERTY);
                this.tableEditor.setModel(ptm);
                this.activeEditor = this.tableEditor;
            } else {
                value = "";
                this.activeEditor = this.stringEditor;
                this.stringEditor.setText((String)value);
            }
        }
        this.activeEditor.setVisible(true);
        table.changeSelection(row, column, false, false);
        this.activeEditor.setBackground(new Color(224, 249, 255));
        this.activeEditor.requestFocusInWindow();
        return this.activeEditor;
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    public void cancelCellEditing() {
        if (this.activeEditor != null) {
            this.activeEditor.setVisible(false);
            this.fireEditingCancelled();
        }
    }

    public Object getCellEditorValue() {
        if (this.activeEditor == this.stringEditor) {
            return this.stringEditor.getText();
        }
        if (this.activeEditor == this.booleanEditor) {
            return this.booleanEditor.isSelected();
        }
        if (this.activeEditor == this.listEditor) {
            if (this.listEditor.isEditable()) {
                return this.listEditor.getEditor().getItem();
            }
            if (this.listEditor.getSelectedItem() == this.noSelect) {
                return null;
            }
            return this.listEditor.getSelectedItem();
        }
        if (this.activeEditor == this.tableEditor) {
            return ((PropertyTableModel)this.tableEditor.getModel()).getValue();
        }
        return null;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        if (this.activeEditor != null) {
            if (this.activeEditor == this.tableEditor && this.tableEditor.isEditing()) {
                ArrayList<JTable> nestedTableEditors = new ArrayList<JTable>();
                JTable nestedTableEditor = this.tableEditor;
                while (nestedTableEditor != null) {
                    nestedTableEditors.add(nestedTableEditor);
                    SchemaPropertyCellEditor sce = (SchemaPropertyCellEditor)nestedTableEditor.getCellEditor();
                    if (sce != null && sce.activeEditor == sce.tableEditor && sce.tableEditor.isEditing()) {
                        nestedTableEditor = sce.tableEditor;
                        continue;
                    }
                    nestedTableEditor = null;
                }
                for (int i = nestedTableEditors.size() - 1; i >= 0; --i) {
                    ((JTable)nestedTableEditors.get(i)).editingStopped(null);
                }
            }
            this.activeEditor.setVisible(false);
            this.fireEditingStopped();
        }
        return true;
    }

    protected void fireEditingStopped() {
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((CellEditorListener)this.listeners.get(i)).editingStopped(ce);
        }
    }

    protected void fireEditingCancelled() {
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((CellEditorListener)this.listeners.get(i)).editingCanceled(ce);
        }
    }

    private Vector getUdfs() {
        Vector<String> udfs = new Vector<String>();
        MondrianGuiDef.Schema s = this.getSchema();
        if (s != null) {
            MondrianGuiDef.UserDefinedFunction[] u = s.userDefinedFunctions;
            for (int i = 0; i < u.length; ++i) {
                if (u[i].className == null || udfs.contains(u[i].className)) continue;
                udfs.add(u[i].className);
            }
        }
        return udfs;
    }

    private Vector getFormatStrings() {
        Vector<String> fs = new Vector<String>();
        MondrianGuiDef.Schema s = this.getSchema();
        if (s != null) {
            MondrianGuiDef.Cube[] c = s.cubes;
            for (int i = 0; i < c.length; ++i) {
                MondrianGuiDef.Measure[] m = c[i].measures;
                for (int j = 0; j < m.length; ++j) {
                    if (m[j].formatString == null || fs.contains(m[j].formatString)) continue;
                    fs.add(m[j].formatString);
                }
            }
        }
        return fs;
    }

    private MondrianGuiDef.Schema getSchema() {
        SchemaExplorer se = this.getSchemaExplorer();
        return se == null ? null : se.getSchema();
    }

    private Object getParentObject() {
        SchemaExplorer se = this.getSchemaExplorer();
        if (se != null) {
            Object po = se.getParentObject();
            return po;
        }
        return null;
    }

    private SchemaExplorer getSchemaExplorer() {
        SchemaExplorer se = null;
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            CellEditorListener cel = (CellEditorListener)this.listeners.get(i);
            if (!(cel instanceof SchemaExplorer)) continue;
            se = (SchemaExplorer)cel;
            break;
        }
        return se;
    }

    private Vector getSource() {
        Vector<String> source = new Vector<String>();
        MondrianGuiDef.Schema s = this.getSchema();
        if (s != null) {
            MondrianGuiDef.Dimension[] u = s.dimensions;
            for (int i = 0; i < u.length; ++i) {
                source.add(u[i].name);
            }
        }
        return source;
    }

    private Vector getCubes() {
        Vector<String> source = new Vector<String>();
        MondrianGuiDef.Schema s = this.getSchema();
        if (s != null) {
            MondrianGuiDef.Cube[] u = s.cubes;
            for (int i = 0; i < u.length; ++i) {
                source.add(u[i].name);
            }
        }
        return source;
    }

    private void generatePrimaryKeyTables(Object relation, Vector v) {
        if (relation == null) {
            return;
        }
        if (relation instanceof MondrianGuiDef.Table) {
            String sname = ((MondrianGuiDef.Table)((Object)relation)).schema;
            v.add((sname == null || sname.equals("") ? "" : sname + "->") + ((MondrianGuiDef.Table)((Object)relation)).name);
            return;
        }
        MondrianGuiDef.Join currentJoin = (MondrianGuiDef.Join)((Object)relation);
        this.generatePrimaryKeyTables((Object)currentJoin.left, v);
        this.generatePrimaryKeyTables((Object)currentJoin.right, v);
    }

    private Vector getDimensions() {
        Vector<String> dims = new Vector<String>();
        Object po = this.getParentObject();
        if (po != null) {
            MondrianGuiDef.Schema s;
            MondrianGuiDef.CubeGrant parent = (MondrianGuiDef.CubeGrant)((Object)po);
            if (parent.cube != null && !parent.cube.equals("") && (s = this.getSchema()) != null) {
                for (int i = 0; i < s.cubes.length; ++i) {
                    if (!s.cubes[i].name.equals(parent.cube)) continue;
                    for (int j = 0; j < s.cubes[i].dimensions.length; ++j) {
                        dims.add(s.cubes[i].dimensions[j].name);
                    }
                    break;
                }
            }
        }
        return dims;
    }

    private Vector getLevels(String hierarchy) {
        if (hierarchy != null && !hierarchy.equals("")) {
            Object po;
            if (hierarchy.startsWith("[") && hierarchy.endsWith("]")) {
                hierarchy = hierarchy.substring(1, hierarchy.length() - 1);
            }
            if ((po = this.getParentObject()) != null) {
                MondrianGuiDef.CubeGrant parent = (MondrianGuiDef.CubeGrant)((Object)po);
                if (parent.cube != null && !parent.cube.equals("")) {
                    if (this.cacheCube.equals(parent.cube) && this.cacheHierarchy.equals(hierarchy)) {
                        return this.hlevels;
                    }
                    this.hlevels = new Vector();
                    this.cacheCube = parent.cube;
                    this.cacheHierarchy = hierarchy;
                    MondrianGuiDef.Schema s = this.getSchema();
                    if (s != null) {
                        block0: for (int i = 0; i < s.cubes.length; ++i) {
                            if (!s.cubes[i].name.equals(parent.cube)) continue;
                            for (int j = 0; j < s.cubes[i].dimensions.length; ++j) {
                                if (!s.cubes[i].dimensions[j].name.equals(hierarchy)) continue;
                                MondrianGuiDef.Dimension d = null;
                                if (s.cubes[i].dimensions[j] instanceof MondrianGuiDef.Dimension) {
                                    d = (MondrianGuiDef.Dimension)s.cubes[i].dimensions[j];
                                } else {
                                    MondrianGuiDef.DimensionUsage d2 = (MondrianGuiDef.DimensionUsage)s.cubes[i].dimensions[j];
                                    for (int m = 0; m < s.dimensions.length; ++m) {
                                        if (!s.dimensions[m].name.equals(d2.source)) continue;
                                        d = s.dimensions[m];
                                        break;
                                    }
                                }
                                if (d.hierarchies[0] == null) break block0;
                                for (int k = 0; k < d.hierarchies[0].levels.length; ++k) {
                                    this.hlevels.add(d.hierarchies[0].levels[k].name);
                                }
                                break block0;
                            }
                            break;
                        }
                    }
                }
            }
        }
        return this.hlevels;
    }
}

