/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.Collections;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.MemberCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.ConstantCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.type.NullType;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapMember;

class RangeFunDef
extends FunDefBase {
    static final RangeFunDef instance = new RangeFunDef();

    private RangeFunDef() {
        super(":", "<Member> : <Member>", "Infix colon operator returns the set of members between a given pair of members.", "ixmm");
    }

    private MemberCalc[] compileMembers(Exp exp0, Exp exp1, ExpCompiler compiler) {
        MemberCalc[] members = new MemberCalc[]{exp0.getType() instanceof NullType ? null : compiler.compileMember(exp0), exp1.getType() instanceof NullType ? null : compiler.compileMember(exp1)};
        if (members[0] == null && members[1] == null) {
            throw MondrianResource.instance().TwoNullsNotSupported.ex();
        }
        if (members[0] == null) {
            Member nullMember = ((RolapMember)members[1].evaluate(null)).getHierarchy().getNullMember();
            members[0] = (MemberCalc)ConstantCalc.constantMember(nullMember);
        } else if (members[1] == null) {
            Member nullMember = ((RolapMember)members[0].evaluate(null)).getHierarchy().getNullMember();
            members[1] = (MemberCalc)ConstantCalc.constantMember(nullMember);
        }
        return members;
    }

    public Calc compileCall(final ResolvedFunCall call, ExpCompiler compiler) {
        final MemberCalc[] memberCalcs = this.compileMembers(call.getArg(0), call.getArg(1), compiler);
        return new AbstractListCalc(call, new Calc[]{memberCalcs[0], memberCalcs[1]}){

            public List evaluateList(Evaluator evaluator) {
                Member member0 = memberCalcs[0].evaluateMember(evaluator);
                Member member1 = memberCalcs[1].evaluateMember(evaluator);
                if (member0.isNull() || member1.isNull()) {
                    return Collections.EMPTY_LIST;
                }
                if (member0.getLevel() != member1.getLevel()) {
                    throw evaluator.newEvalException(call.getFunDef(), "Members must belong to the same level");
                }
                return FunUtil.memberRange(evaluator, member0, member1);
            }
        };
    }
}

