/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test.loader;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.sql.SqlQuery;
import org.apache.log4j.Logger;

public abstract class DBLoader {
    protected static final Logger LOGGER = Logger.getLogger(DBLoader.class);
    public static final String nl = System.getProperty("line.separator");
    private static final int DEFAULT_BATCH_SIZE = 50;
    public static final String BATCH_SIZE_PROP = "mondrian.test.loader.batch.size";
    public static final String JDBC_DRIVER_PROP = "mondrian.test.loader.jdbc.driver";
    public static final String JDBC_URL_PROP = "mondrian.test.loader.jdbc.url";
    public static final String JDBC_USER_PROP = "mondrian.test.loader.jdbc.user";
    public static final String JDBC_PASSWORD_PROP = "mondrian.test.loader.jdbc.password";
    public static final String OUTPUT_DIRECTORY_PROP = "mondrian.test.loader.output.directory";
    public static final String FORCE_PROP = "mondrian.test.loader.force";
    public static final String DROP_TABLE_PROP = "mondrian.test.loader.drop.table.suffix";
    public static final String DROP_TABLE_SUFFIX_DEFAULT = "drop.sql";
    public static final String DROP_TABLE_ROWS_PROP = "mondrian.test.loader.drop.table.rows.suffix";
    public static final String DROP_TABLE_ROWS_SUFFIX_DEFAULT = "droprows.sql";
    public static final String CREATE_TABLE_PROP = "mondrian.test.loader.create.table.suffix";
    public static final String CREATE_TABLE_SUFFIX_DEFAULT = "create.sql";
    public static final String LOAD_TABLE_ROWS_PROP = "mondrian.test.loader.load.table.rows.suffix";
    public static final String LOAD_TABLE_ROWS_SUFFIX_DEFAULT = "loadrows.sql";
    static final Pattern decimalDataTypeRegex = Pattern.compile("DECIMAL\\((.*),(.*)\\)");
    static final Pattern varcharDataTypeRegex = Pattern.compile("VARCHAR\\((.*)\\)");
    static final DecimalFormat integerFormatter = new DecimalFormat(DBLoader.decimalFormat(15, 0));
    static final String dateFormatString = "yyyy-MM-dd";
    static final String oracleDateFormatString = "YYYY-MM-DD";
    static final DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    static final RowStream EMPTY_ROW_STREAM = new RowStream(){

        @Override
        public Iterator<Row> iterator() {
            List list = Collections.emptyList();
            return list.iterator();
        }
    };
    private String jdbcDriver;
    private String jdbcURL;
    private String userName;
    private String password;
    private Connection connection;
    private File outputDirectory;
    private boolean force;
    private Writer fileWriter = null;
    private SqlQuery.Dialect dialect;
    private int batchSize = 50;
    private boolean initialize;

    public static String decimalFormat(String lengthStr, String placesStr) {
        int length = Integer.parseInt(lengthStr);
        int places = Integer.parseInt(placesStr);
        return DBLoader.decimalFormat(length, places);
    }

    public static String decimalFormat(int length, int places) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (length - i == places) {
                buf.append('.');
            }
            if (length - i <= places + 1) {
                buf.append("0");
                continue;
            }
            buf.append("#");
        }
        return buf.toString();
    }

    protected DBLoader() {
    }

    public abstract Table[] getTables() throws Exception;

    public void dropTables(Table[] tables) throws Exception {
        Exception firstEx = null;
        for (Table table : tables) {
            try {
                this.dropTable(table);
            }
            catch (Exception ex) {
                if (firstEx != null) continue;
                firstEx = ex;
            }
        }
        if (firstEx != null) {
            throw firstEx;
        }
    }

    public void dropTable(Table table) throws Exception {
        String dropTableStmt = table.getDropTableStmt();
        if (dropTableStmt != null) {
            this.executeDDL(dropTableStmt);
        }
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean getForce() {
        return this.force;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setJdbcURL(String jdbcURL) {
        this.jdbcURL = jdbcURL;
    }

    public String getJdbcURL() {
        return this.jdbcURL;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void initialize() throws Exception {
        if (this.initialize) {
            return;
        }
        this.check();
        if (this.connection == null) {
            RolapUtil.loadDrivers(this.jdbcDriver);
            this.connection = this.userName == null ? DriverManager.getConnection(this.jdbcURL) : DriverManager.getConnection(this.jdbcURL, this.userName, this.password);
        }
        DatabaseMetaData metaData = this.connection.getMetaData();
        String productName = metaData.getDatabaseProductName();
        String version = metaData.getDatabaseProductVersion();
        LOGGER.info((Object)("Output connection is " + productName + ", " + version));
        this.dialect = SqlQuery.Dialect.create(metaData);
        this.initialize = true;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void generateStatements(Table[] tables) throws Exception {
        this.initialize();
        for (Table table : tables) {
            this.generateStatements(table);
        }
    }

    protected void generateStatements(Table table) throws Exception {
        Column[] columns = table.getColumns();
        this.initializeColumns(columns);
        this.generateDropTable(table);
        this.generateDropTableRows(table);
        this.generateCreateTable(table);
    }

    protected void generateDropTable(Table table) {
        String tableName = table.getName();
        String dropTableStmt = "DROP TABLE " + this.quoteId(tableName);
        table.setDropTableStmt(dropTableStmt);
    }

    protected void generateDropTableRows(Table table) {
        String tableName = table.getName();
        String dropTableRowsStmt = "DELETE FROM " + this.quoteId(tableName);
        table.setDropTableRowsStmt(dropTableRowsStmt);
    }

    protected void generateCreateTable(Table table) {
        String tableName = table.getName();
        Column[] columns = table.getColumns();
        StringBuilder buf = new StringBuilder(50);
        buf.append("CREATE TABLE ");
        buf.append(this.quoteId(tableName));
        buf.append(" (");
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (i > 0) {
                buf.append(",");
            }
            buf.append(nl);
            buf.append("    ");
            buf.append(this.quoteId(column.name));
            buf.append(" ");
            buf.append(column.typeName);
            String constraint = column.getConstraint();
            if (constraint.equals("")) continue;
            buf.append(" ");
            buf.append(constraint);
        }
        buf.append(nl);
        buf.append(")");
        String ddl = buf.toString();
        table.setCreateTableStmt(ddl);
    }

    public void executeStatements(Table[] tables) throws Exception {
        for (Table table : tables) {
            table.executeStatements();
        }
    }

    protected void executeStatements(Table table) throws Exception {
        this.executeDropTable(table);
        this.executeDropTableRows(table);
        this.executeCreateTable(table);
        this.executeLoadTableRows(table);
    }

    protected boolean makeFileWriter(Table table, String suffix) throws Exception {
        if (this.outputDirectory != null) {
            String fileName = table.getName() + suffix;
            File file = new File(this.outputDirectory, fileName);
            if (file.exists()) {
                if (this.force) {
                    if (!file.delete()) {
                        throw new Exception("Table file \"" + fileName + "\" could not be deleted");
                    }
                } else {
                    throw new Exception("Table file \"" + fileName + "\" already exists" + " - delete or use force flag");
                }
            }
            this.fileWriter = new FileWriter(file);
            return true;
        }
        return false;
    }

    protected void closeFileWriter() {
        try {
            if (this.fileWriter != null) {
                this.fileWriter.flush();
                this.fileWriter.close();
                this.fileWriter = null;
            }
        }
        catch (IOException ex) {
            LOGGER.debug((Object)("Could not close file writer: " + ex));
        }
    }

    public void clear() {
    }

    public void close() {
    }

    protected void check() throws Exception {
        if (this.connection == null) {
            if (this.jdbcDriver == null) {
                throw new Exception("Not set: jdbcDriver");
            }
            if (this.jdbcURL == null) {
                throw new Exception("Not set: jdbcURL");
            }
        }
    }

    protected void initializeColumns(Column[] columns) {
        for (Column column : columns) {
            column.init(this.dialect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeDropTableRows(Table table) throws Exception {
        try {
            Table.Controller controller = table.getController();
            if (controller.shouldDropTableRows()) {
                String suffix = System.getProperty(DROP_TABLE_ROWS_PROP, DROP_TABLE_ROWS_SUFFIX_DEFAULT);
                String dropTableRowsStmt = table.getDropTableRowsStmt();
                if (this.makeFileWriter(table, "." + suffix)) {
                    this.writeDDL(dropTableRowsStmt);
                } else {
                    this.executeDDL(dropTableRowsStmt);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            LOGGER.debug((Object)("Drop Table row of " + table.getName() + " failed. Ignored"));
        }
        finally {
            this.closeFileWriter();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeDropTable(Table table) {
        try {
            Table.Controller controller = table.getController();
            if (controller.shouldDropTable()) {
                String suffix = System.getProperty(DROP_TABLE_PROP, DROP_TABLE_SUFFIX_DEFAULT);
                String dropTableStmt = table.getDropTableStmt();
                if (this.makeFileWriter(table, "." + suffix)) {
                    this.writeDDL(dropTableStmt);
                } else {
                    this.executeDDL(dropTableStmt);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Drop of " + table.getName() + " failed. Ignored"));
        }
        finally {
            this.closeFileWriter();
        }
        return false;
    }

    protected boolean executeCreateTable(Table table) {
        try {
            Table.Controller controller = table.getController();
            if (controller.createTable()) {
                String suffix = System.getProperty(CREATE_TABLE_PROP, CREATE_TABLE_SUFFIX_DEFAULT);
                String ddl = table.getCreateTableStmt();
                if (this.makeFileWriter(table, "." + suffix)) {
                    this.writeDDL(ddl);
                } else {
                    this.executeDDL(ddl);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw MondrianResource.instance().CreateTableFailed.ex(table.getName(), e);
        }
        finally {
            this.closeFileWriter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeLoadTableRows(Table table) {
        int rowsAdded = 0;
        try {
            String suffix = System.getProperty(LOAD_TABLE_ROWS_PROP, LOAD_TABLE_ROWS_SUFFIX_DEFAULT);
            this.makeFileWriter(table, "." + suffix);
            Table.Controller controller = table.getController();
            if (controller.loadRows()) {
                String[] batch = new String[this.batchSize];
                int nosInBatch = 0;
                Iterator<Row> it = controller.rows();
                boolean displayedInsert = false;
                while (it.hasNext()) {
                    Row row = it.next();
                    Object[] values = row.values();
                    String insertStatement = this.createInsertStatement(table, values);
                    if (!displayedInsert && LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Example Insert statement: " + insertStatement));
                        displayedInsert = true;
                    }
                    batch[nosInBatch++] = insertStatement;
                    if (nosInBatch < this.batchSize) continue;
                    rowsAdded += this.writeBatch(batch, nosInBatch);
                    nosInBatch = 0;
                }
                if (nosInBatch > 0) {
                    rowsAdded += this.writeBatch(batch, nosInBatch);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.warn((Object)("Load of " + table.getName() + " failed. Ignored"));
        }
        finally {
            this.closeFileWriter();
        }
        return rowsAdded;
    }

    protected String createInsertStatement(Table table, Object[] values) throws Exception {
        int i;
        Column[] columns = table.getColumns();
        if (columns.length != values.length) {
            StringBuilder buf;
            int numberOfNullColumns = 0;
            for (Column c : columns) {
                if (!c.canBeNull()) continue;
                ++numberOfNullColumns;
            }
            if (numberOfNullColumns == 0) {
                buf = new StringBuilder();
                buf.append("For table ");
                buf.append(table.getName());
                buf.append(" the columns length ");
                buf.append(columns.length);
                buf.append(" does not equal the values length ");
                buf.append(values.length);
                throw new Exception(buf.toString());
            }
            if (columns.length != values.length + numberOfNullColumns) {
                buf = new StringBuilder();
                buf.append("For table ");
                buf.append(table.getName());
                buf.append(" the columns length ");
                buf.append(columns.length);
                buf.append(" and number allowed to be null ");
                buf.append(numberOfNullColumns);
                buf.append(" does not equal the values length ");
                buf.append(values.length);
                throw new Exception(buf.toString());
            }
            Object[] vs = new Object[columns.length];
            int j = 0;
            for (int i2 = 0; i2 < columns.length; ++i2) {
                if (columns[i2].canBeNull()) continue;
                vs[i2] = values[j++];
            }
            values = vs;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("INSERT INTO ");
        buf.append(this.quoteId(table.getName()));
        buf.append(" ( ");
        for (i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.quoteId(column.getName()));
        }
        buf.append(" ) VALUES ( ");
        for (i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.columnValue(column, values[i]));
        }
        buf.append(" )");
        return buf.toString();
    }

    protected String quoteId(String name) {
        return this.dialect.quoteIdentifier(name);
    }

    protected String columnValue(Column column, Object value) {
        Type type = column.getType();
        String typeName = type.getName();
        if (value == null) {
            return "NULL";
        }
        if (value instanceof String && ((String)value).length() == 0) {
            return "NULL";
        }
        if (type == Type.Integer) {
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof Double) {
                Double result = (Double)value;
                return integerFormatter.format(result);
            }
            if (value instanceof Integer) {
                Integer result = (Integer)value;
                return result.toString();
            }
        } else if (type == Type.Smallint) {
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? "1" : "0";
            }
            if (value instanceof Integer) {
                Integer result = (Integer)value;
                return result.toString();
            }
        } else if (type == Type.Bigint) {
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof Double) {
                Double result = (Double)value;
                return integerFormatter.format(result);
            }
            if (value instanceof Long) {
                Long result = (Long)value;
                return result.toString();
            }
        } else if (type == Type.Varchar30 || type == Type.Varchar255 || type == Type.Varchar60 || typeName.startsWith("VARCHAR(")) {
            if (value instanceof String) {
                return this.embedQuotes((String)value);
            }
        } else if (type == Type.Timestamp) {
            if (value instanceof String) {
                Timestamp ts = Timestamp.valueOf((String)value);
                if (this.dialect.isOracle() || this.dialect.isLucidDB()) {
                    return "TIMESTAMP '" + ts + "'";
                }
                return "'" + ts + "'";
            }
            if (value instanceof Timestamp) {
                Timestamp ts = (Timestamp)value;
                if (this.dialect.isOracle() || this.dialect.isLucidDB()) {
                    return "TIMESTAMP '" + ts + "'";
                }
                return "'" + ts + "'";
            }
        } else if (type == Type.Date) {
            if (value instanceof String) {
                Date dt = Date.valueOf((String)value);
                if (this.dialect.isOracle() || this.dialect.isLucidDB()) {
                    return "DATE '" + dateFormatter.format(dt) + "'";
                }
                return "'" + dateFormatter.format(dt) + "'";
            }
            if (value instanceof Date) {
                Date dt = (Date)value;
                if (this.dialect.isOracle() || this.dialect.isLucidDB()) {
                    return "DATE '" + dateFormatter.format(dt) + "'";
                }
                return "'" + dateFormatter.format(dt) + "'";
            }
        } else if (type == Type.Real) {
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof Float) {
                Float result = (Float)value;
                return result.toString();
            }
        } else if (type == Type.Decimal || typeName.startsWith("DECIMAL(")) {
            if (value instanceof String) {
                return (String)value;
            }
            Matcher matcher = decimalDataTypeRegex.matcher(typeName);
            if (!matcher.matches()) {
                throw new RuntimeException("Bad DECIMAL column type for " + typeName);
            }
            DecimalFormat formatter = new DecimalFormat(DBLoader.decimalFormat(matcher.group(1), matcher.group(2)));
            if (value instanceof Double) {
                Double result = (Double)value;
                return formatter.format(result);
            }
            if (value instanceof BigDecimal) {
                BigDecimal result = (BigDecimal)value;
                return formatter.format(result);
            }
        } else if (type == Type.Boolean) {
            if (value instanceof String) {
                String trimmedValue = ((String)value).trim();
                if (!(this.dialect.isMySQL() || this.dialect.isOracle() || this.dialect.isDB2() || this.dialect.isFirebird() || this.dialect.isMSSQL() || this.dialect.isDerby() || this.dialect.isIngres())) {
                    if (trimmedValue.equals("1")) {
                        return "true";
                    }
                    if (trimmedValue.equals("0")) {
                        return "false";
                    }
                } else {
                    if (trimmedValue.equals("true")) {
                        return "1";
                    }
                    if (trimmedValue.equals("false")) {
                        return "0";
                    }
                    if (trimmedValue.equals("1")) {
                        return "1";
                    }
                    if (trimmedValue.equals("0")) {
                        return "0";
                    }
                }
            } else if (value instanceof Boolean) {
                Boolean result = (Boolean)value;
                return result.toString();
            }
        }
        throw new RuntimeException("Unknown column type: " + typeName + " for column: " + column.getName());
    }

    protected String embedQuotes(String original) {
        if (original == null) {
            return "NULL";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("'");
        for (int i = 0; i < original.length(); ++i) {
            char ch = original.charAt(i);
            buf.append(ch);
            if (ch != '\'') continue;
            buf.append('\'');
        }
        buf.append("'");
        return buf.toString();
    }

    protected int writeBatch(String[] batch, int batchSize) throws IOException, SQLException {
        if (this.fileWriter != null) {
            for (int i = 0; i < batchSize; ++i) {
                this.fileWriter.write(batch[i]);
                this.fileWriter.write(59);
                this.fileWriter.write(nl);
            }
        } else {
            this.connection.setAutoCommit(false);
            Statement stmt = this.connection.createStatement();
            if (batchSize == 1) {
                stmt.execute(batch[0]);
            } else {
                int[] updateCounts;
                for (int i = 0; i < batchSize; ++i) {
                    stmt.addBatch(batch[i]);
                }
                try {
                    updateCounts = stmt.executeBatch();
                }
                catch (SQLException e) {
                    for (int i = 0; i < batchSize; ++i) {
                        LOGGER.error((Object)("Error in SQL batch: " + batch[i]));
                    }
                    throw e;
                }
                int updates = 0;
                for (int i = 0; i < updateCounts.length; ++i) {
                    if (updateCounts[i] == 0) {
                        LOGGER.error((Object)("Error in SQL: " + batch[i]));
                    }
                    updates += updateCounts[i];
                }
                if (updates < batchSize) {
                    throw new RuntimeException("Failed to execute batch: " + batchSize + " versus " + updates);
                }
            }
            this.connection.commit();
            stmt.close();
            this.connection.setAutoCommit(true);
        }
        return batchSize;
    }

    protected void writeDDL(String ddl) throws Exception {
        LOGGER.debug((Object)ddl);
        this.fileWriter.write(ddl);
        this.fileWriter.write(59);
        this.fileWriter.write(nl);
    }

    protected void executeDDL(String ddl) throws Exception {
        LOGGER.debug((Object)ddl);
        Statement statement = this.getConnection().createStatement();
        statement.execute(ddl);
    }

    public static class Type {
        public static final Type Integer = new Type("INTEGER");
        public static final Type Decimal = new Type("DECIMAL(10,4)");
        public static final Type Smallint = new Type("SMALLINT");
        public static final Type Varchar30 = new Type("VARCHAR(30)");
        public static final Type Varchar255 = new Type("VARCHAR(255)");
        public static final Type Varchar60 = new Type("VARCHAR(60)");
        public static final Type Real = new Type("REAL");
        public static final Type Boolean = new Type("BOOLEAN");
        public static final Type Bigint = new Type("BIGINT");
        public static final Type Date = new Type("DATE");
        public static final Type Timestamp = new Type("TIMESTAMP");
        public static final Map<String, Type> extraTypes = new HashMap<String, Type>();
        private final String name;

        public static Type getType(String typeName) {
            String upperCaseTypeName = typeName.toUpperCase();
            if (upperCaseTypeName.equals("INTEGER")) {
                return Integer;
            }
            if (upperCaseTypeName.equals("INT")) {
                return Integer;
            }
            if (upperCaseTypeName.equals("DECIMAL(10,4)")) {
                return Decimal;
            }
            if (upperCaseTypeName.equals("SMALLINT")) {
                return Smallint;
            }
            if (upperCaseTypeName.equals("VARCHAR(30)")) {
                return Varchar30;
            }
            if (upperCaseTypeName.equals("VARCHAR(255)")) {
                return Varchar255;
            }
            if (upperCaseTypeName.equals("VARCHAR(60)")) {
                return Varchar60;
            }
            if (upperCaseTypeName.equals("REAL")) {
                return Real;
            }
            if (upperCaseTypeName.equals("BOOLEAN")) {
                return Boolean;
            }
            if (upperCaseTypeName.equals("BOOL")) {
                return Boolean;
            }
            if (upperCaseTypeName.equals("BIGINT")) {
                return Bigint;
            }
            if (upperCaseTypeName.equals("DATE")) {
                return Date;
            }
            if (upperCaseTypeName.equals("TIMESTAMP")) {
                return Timestamp;
            }
            return extraTypes.get(upperCaseTypeName);
        }

        public static Type makeType(String typeName) {
            Type type = null;
            String upperCaseTypeName = typeName.toUpperCase();
            Matcher matcher = decimalDataTypeRegex.matcher(upperCaseTypeName);
            if (matcher.matches()) {
                type = new Type(upperCaseTypeName);
                extraTypes.put(upperCaseTypeName, type);
                return type;
            }
            matcher = varcharDataTypeRegex.matcher(upperCaseTypeName);
            if (matcher.matches()) {
                type = new Type(upperCaseTypeName);
                extraTypes.put(upperCaseTypeName, type);
                return type;
            }
            return type;
        }

        public Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toPhysical(SqlQuery.Dialect dialect) {
            if (this == Integer || this == Decimal || this == Smallint || this == Varchar30 || this == Varchar60 || this == Varchar255 || this == Real) {
                return this.name;
            }
            if (this == Boolean) {
                if (dialect.isPostgres()) {
                    return this.name;
                }
                if (dialect.isMySQL()) {
                    return "TINYINT(1)";
                }
                if (dialect.isMSSQL()) {
                    return "BIT";
                }
                return Type.Smallint.name;
            }
            if (this == Bigint) {
                if (dialect.isOracle() || dialect.isFirebird()) {
                    return "DECIMAL(15,0)";
                }
                return this.name;
            }
            if (this == Date) {
                if (dialect.isMSSQL()) {
                    return "DATETIME";
                }
                return this.name;
            }
            if (this == Timestamp) {
                if (dialect.isMSSQL() || dialect.isMySQL()) {
                    return "DATETIME";
                }
                if (dialect.isIngres()) {
                    return "DATE";
                }
                return this.name;
            }
            if (this.name.startsWith("DECIMAL(")) {
                return this.name;
            }
            if (this.name.startsWith("VARCHAR(")) {
                return this.name;
            }
            throw new AssertionError((Object)("unexpected type: " + this.name));
        }
    }

    public static class Column {
        private final String name;
        private final Type type;
        private String typeName;
        private final boolean canBeNull;

        public Column(String name, Type type, boolean canBeNull) {
            this.name = name;
            this.type = type;
            this.canBeNull = canBeNull;
        }

        public void init(SqlQuery.Dialect dialect) {
            this.typeName = this.type.toPhysical(dialect);
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public boolean canBeNull() {
            return this.canBeNull;
        }

        public String getConstraint() {
            return this.canBeNull ? "" : "NOT NULL";
        }
    }

    public static class RowDefault
    implements Row {
        private final Object[] values;

        public RowDefault(Object[] values) {
            this.values = values;
        }

        public Object[] values() {
            return this.values;
        }
    }

    public static interface Row {
        public Object[] values();
    }

    public class Table {
        private final String name;
        private final Column[] columns;
        private final Controller controller;
        private String dropTableStmt;
        private String dropTableRowsStmt;
        private String createTableStmt;

        public Table(String name, Column[] columns) {
            this.name = name;
            this.columns = columns;
            this.controller = new Controller();
        }

        public String getName() {
            return this.name;
        }

        public String getDropTableStmt() {
            return this.dropTableStmt;
        }

        public void setDropTableStmt(String dropTableStmt) {
            this.dropTableStmt = dropTableStmt;
        }

        public String getDropTableRowsStmt() {
            return this.dropTableRowsStmt;
        }

        public void setDropTableRowsStmt(String dropTableRowsStmt) {
            this.dropTableRowsStmt = dropTableRowsStmt;
        }

        public String getCreateTableStmt() {
            return this.createTableStmt;
        }

        public void setCreateTableStmt(String createTableStmt) {
            this.createTableStmt = createTableStmt;
        }

        public Column[] getColumns() {
            return this.columns;
        }

        public Controller getController() {
            return this.controller;
        }

        public void executeStatements() throws Exception {
            DBLoader.this.executeStatements(this);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Controller {
            private boolean dropTable = true;
            private boolean dropRows = true;
            private boolean createTable = true;
            private boolean loadRows = true;
            private RowStream rowStream = EMPTY_ROW_STREAM;

            private Controller() {
            }

            public boolean shouldDropTable() {
                return this.dropTable;
            }

            public void setShouldDropTable(boolean dropTable) {
                this.dropTable = dropTable;
            }

            public boolean shouldDropTableRows() {
                return this.dropRows;
            }

            public void setShouldDropTableRows(boolean dropRows) {
                this.dropRows = dropRows;
            }

            public boolean createTable() {
                return this.createTable;
            }

            public void setCreateTable(boolean createTable) {
                this.createTable = createTable;
            }

            public boolean loadRows() {
                return this.loadRows;
            }

            public void setloadRows(boolean loadRows) {
                this.loadRows = loadRows;
            }

            public void setRowStream(RowStream rowStream) {
                this.rowStream = rowStream == null ? EMPTY_ROW_STREAM : rowStream;
            }

            public Iterator<Row> rows() {
                return this.rowStream.iterator();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RowStream {
        public Iterator<Row> iterator();
    }
}

