/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.LineElement;
import org.netbeans.editor.LineRootElement;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxUpdateTokens;
import org.netbeans.editor.TokenID;

final class FixLineSyntaxState {
    private static final boolean debug = false;
    private final DocumentEvent evt;
    private int syntaxUpdateOffset;
    private List syntaxUpdateTokenList = Collections.EMPTY_LIST;

    FixLineSyntaxState(DocumentEvent documentEvent) {
        this.evt = documentEvent;
    }

    final int getSyntaxUpdateOffset() {
        return this.syntaxUpdateOffset;
    }

    final List getSyntaxUpdateTokenList() {
        return this.syntaxUpdateTokenList;
    }

    static void invalidateAllSyntaxStateInfos(BaseDocument baseDocument) {
        LineRootElement lineRootElement = FixLineSyntaxState.getLineRoot(baseDocument);
        int n = lineRootElement.getElementCount();
        for (int i = n - 1; i >= 0; --i) {
            LineElement lineElement = (LineElement)lineRootElement.getElement(i);
            lineElement.clearSyntaxStateInfo();
        }
    }

    static void prepareSyntax(BaseDocument baseDocument, Segment segment, Syntax syntax, int n, int n2, boolean bl, boolean bl2) throws BadLocationException {
        int n3;
        if (n < 0 || n2 < 0 || n + n2 > baseDocument.getLength()) {
            throw new BadLocationException("reqPos=" + n + ", reqLen=" + n2 + ", doc.getLength()=" + baseDocument.getLength(), -1);
        }
        LineRootElement lineRootElement = FixLineSyntaxState.getLineRoot(baseDocument);
        int n4 = lineRootElement.getElementIndex(n);
        Element element = lineRootElement.getElement(n4);
        Syntax.StateInfo stateInfo = FixLineSyntaxState.getValidSyntaxStateInfo(baseDocument, n4);
        int n5 = element.getStartOffset();
        int n6 = n3 = stateInfo != null ? stateInfo.getPreScan() : 0;
        if (n3 > n5) {
            n3 = n5;
        }
        int n7 = n - n5;
        baseDocument.getText(n5 - n3, n3 + n7 + n2, segment);
        segment.offset += n3;
        segment.count -= n3;
        syntax.load(stateInfo, segment.array, segment.offset, n7, false, n);
        while (syntax.nextToken() != null) {
        }
        segment.offset += n7;
        segment.count -= n7;
        boolean bl3 = bl2 ? false : bl || n + n2 >= baseDocument.getLength();
        syntax.relocate(segment.array, segment.offset, segment.count, bl3, n + n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Syntax.StateInfo getValidSyntaxStateInfo(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n == 0) {
            return null;
        }
        LineRootElement lineRootElement = FixLineSyntaxState.getLineRoot(baseDocument);
        LineElement lineElement = (LineElement)lineRootElement.getElement(n);
        Syntax.StateInfo stateInfo = lineElement.getSyntaxStateInfo();
        if (n > 0 && stateInfo == null) {
            int n2;
            LineElement lineElement2 = null;
            for (n2 = n - 1; n2 > 0 && (stateInfo = (lineElement2 = (LineElement)lineRootElement.getElement(n2)).getSyntaxStateInfo()) == null; --n2) {
            }
            Segment segment = new Segment();
            Syntax syntax = baseDocument.getFreeSyntax();
            try {
                int n3;
                int n4 = lineElement.getStartOffset();
                int n5 = 0;
                if (n2 > 0) {
                    n3 = lineElement2.getStartOffset();
                    n5 = stateInfo.getPreScan();
                } else {
                    n3 = 0;
                    stateInfo = null;
                }
                baseDocument.getText(n3 - n5, n4 - n3 + n5, segment);
                segment.offset += n5;
                segment.count -= n5;
                syntax.load(stateInfo, segment.array, segment.offset, segment.count, false, n4);
                int n6 = segment.offset + segment.count;
                do {
                    lineElement2 = (LineElement)lineRootElement.getElement(++n2);
                    int n7 = n3;
                    n3 = lineElement2.getStartOffset();
                    n7 = n3 - n7;
                    syntax.relocate(segment.array, syntax.getOffset(), n7, false, n3);
                    while (syntax.nextToken() != null) {
                    }
                    lineElement2.updateSyntaxStateInfo(syntax);
                } while (n2 != n);
            }
            finally {
                baseDocument.releaseSyntax(syntax);
            }
        }
        return lineElement.getSyntaxStateInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(boolean bl) {
        SyntaxUpdateTokens syntaxUpdateTokens = (SyntaxUpdateTokens)this.evt.getDocument().getProperty(SyntaxUpdateTokens.class);
        if (syntaxUpdateTokens != null) {
            syntaxUpdateTokens.syntaxUpdateStart();
        }
        try {
            this.syntaxUpdateOffset = this.fixSyntaxStateInfos(bl);
        }
        finally {
            if (syntaxUpdateTokens != null) {
                this.syntaxUpdateTokenList = Collections.unmodifiableList(new ArrayList(syntaxUpdateTokens.syntaxUpdateEnd()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int fixSyntaxStateInfos(boolean bl) {
        int n = this.evt.getOffset();
        if (n < 0) {
            throw new IllegalStateException("offset=" + n);
        }
        BaseDocument baseDocument = (BaseDocument)this.evt.getDocument();
        LineRootElement lineRootElement = FixLineSyntaxState.getLineRoot(baseDocument);
        int n2 = lineRootElement.getElementCount();
        DocumentEvent.ElementChange elementChange = this.evt.getChange((Element)((Object)lineRootElement));
        int n3 = elementChange != null ? elementChange.getIndex() : lineRootElement.getElementIndex(n);
        int n4 = elementChange != null ? elementChange.getChildrenAdded().length : 0;
        int n5 = n3 + n4 + 1;
        if (n3 > 0) {
            --n3;
        }
        if (n3 + 1 == n2) {
            return baseDocument.getLength();
        }
        LineElement lineElement = (LineElement)lineRootElement.getElement(n3);
        Segment segment = new Segment();
        try {
            Syntax.StateInfo stateInfo = FixLineSyntaxState.getValidSyntaxStateInfo(baseDocument, n3);
            int n6 = lineElement.getStartOffset();
            int n7 = stateInfo != null ? stateInfo.getPreScan() : 0;
            Syntax syntax = baseDocument.getFreeSyntax();
            try {
                LineElement lineElement2 = (LineElement)lineRootElement.getElement(++n3);
                int n8 = lineElement2.getStartOffset();
                baseDocument.getText(n6 - n7, n8 - n6 + n7, segment);
                segment.offset += n7;
                segment.count -= n7;
                syntax.load(stateInfo, segment.array, segment.offset, segment.count, false, n8);
                SyntaxUpdateTokens syntaxUpdateTokens = (SyntaxUpdateTokens)baseDocument.getProperty(SyntaxUpdateTokens.class);
                int n9 = -1;
                int n10 = -1;
                int n11 = -1;
                while (true) {
                    int n12;
                    int n13 = n6 - segment.offset;
                    TokenID tokenID = syntax.nextToken();
                    while (tokenID != null) {
                        if (syntaxUpdateTokens != null) {
                            syntaxUpdateTokens.syntaxUpdateToken(tokenID, syntax.getTokenContextPath(), n13 + syntax.getTokenOffset(), syntax.getTokenLength());
                        }
                        tokenID = syntax.nextToken();
                    }
                    stateInfo = lineElement2.getSyntaxStateInfo();
                    if (n3 >= n5 && stateInfo != null && syntax.compareState(stateInfo) == 0) {
                        n6 = n8;
                        n13 = n6;
                        return n13;
                    }
                    lineElement2.updateSyntaxStateInfo(syntax);
                    if (++n3 >= n2) {
                        n12 = baseDocument.getLength();
                        return n12;
                    }
                    lineElement = lineElement2;
                    n6 = n8;
                    lineElement2 = (LineElement)lineRootElement.getElement(n3);
                    n8 = lineElement2.getStartOffset();
                    n7 = syntax.getPreScan();
                    n12 = n8 - n6 + n7;
                    if (n9 == -1) {
                        n10 = n6 - n7;
                        n9 = n12;
                        baseDocument.getText(n10, n9, segment);
                        n11 = n10 - segment.offset;
                    } else {
                        if (n6 - n7 < n10 || n8 > n10 + n9) {
                            n9 = Math.max(n9, n12);
                            n9 *= 2;
                            n10 = n6 - n7;
                            n9 = Math.min(n10 + n9, baseDocument.getLength()) - n10;
                            baseDocument.getText(n10, n9, segment);
                            n11 = n10 - segment.offset;
                        } else {
                            segment.offset = n6 - n7 - n11;
                        }
                        segment.count = n12;
                    }
                    segment.offset += n7;
                    segment.count -= n7;
                    syntax.relocate(segment.array, segment.offset, segment.count, false, n8);
                }
            }
            finally {
                baseDocument.releaseSyntax(syntax);
            }
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalStateException(badLocationException);
        }
    }

    static int getTokenSafeOffset(BaseDocument baseDocument, int n) {
        if (n == 0) {
            return n;
        }
        try {
            LineRootElement lineRootElement = FixLineSyntaxState.getLineRoot(baseDocument);
            int n2 = lineRootElement.getElementIndex(n);
            Element element = lineRootElement.getElement(n2);
            int n3 = element.getStartOffset();
            Syntax.StateInfo stateInfo = FixLineSyntaxState.getValidSyntaxStateInfo(baseDocument, n2);
            if (n == n3 && stateInfo.getPreScan() == 0) {
                return n;
            }
            int n4 = lineRootElement.getElementCount();
            while (++n2 < n4) {
                element = lineRootElement.getElement(n2);
                stateInfo = FixLineSyntaxState.getValidSyntaxStateInfo(baseDocument, n2);
                n3 = element.getStartOffset();
                if (n3 - stateInfo.getPreScan() < n) continue;
                return n3;
            }
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalStateException(badLocationException.toString());
        }
        return baseDocument.getLength();
    }

    private static LineRootElement getLineRoot(Document document) {
        return (LineRootElement)((Object)document.getDefaultRootElement());
    }

    private static void checkConsistency(Document document) {
        LineRootElement lineRootElement = FixLineSyntaxState.getLineRoot(document);
        int n = lineRootElement.getElementCount();
        for (int i = 1; i < n; ++i) {
            LineElement lineElement = (LineElement)lineRootElement.getElement(i);
            assert (lineElement.getSyntaxStateInfo() != null) : "Syntax state null at line " + i + " of " + n;
        }
    }

    public static String lineInfosToString(Document document) {
        StringBuffer stringBuffer = new StringBuffer();
        LineRootElement lineRootElement = FixLineSyntaxState.getLineRoot(document);
        int n = lineRootElement.getElementCount();
        for (int i = 0; i < n; ++i) {
            LineElement lineElement = (LineElement)lineRootElement.getElement(i);
            stringBuffer.append("[" + i + "]: lineStartOffset=" + lineElement.getStartOffset() + ", info: " + lineElement.getSyntaxStateInfo() + "\n");
        }
        return stringBuffer.toString();
    }

    UndoableEdit createBeforeLineUndo() {
        return new BeforeLineUndo();
    }

    UndoableEdit createAfterLineUndo() {
        return new AfterLineUndo();
    }

    final class AfterLineUndo
    extends AbstractUndoableEdit {
        AfterLineUndo() {
        }

        public void redo() throws CannotRedoException {
            FixLineSyntaxState.this.update(false);
            super.redo();
        }
    }

    final class BeforeLineUndo
    extends AbstractUndoableEdit {
        BeforeLineUndo() {
        }

        FixLineSyntaxState getMaster() {
            return FixLineSyntaxState.this;
        }

        public void undo() throws CannotUndoException {
            FixLineSyntaxState.this.update(true);
            super.undo();
        }
    }
}

