/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.text.Position;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;

class FormatTokenPositionSupport {
    private final FormatWriter formatWriter;
    private SaveSet firstSet;
    private SaveSet lastSet;
    private final HashMap tokens2positionLists = new HashMap();

    FormatTokenPositionSupport(FormatWriter formatWriter) {
        this.formatWriter = formatWriter;
    }

    private ArrayList getPosList(TokenItem tokenItem) {
        ArrayList arrayList = (ArrayList)this.tokens2positionLists.get(tokenItem);
        if (arrayList == null) {
            arrayList = new ArrayList(3);
            this.tokens2positionLists.put(tokenItem, arrayList);
        }
        return arrayList;
    }

    synchronized ExtTokenPosition getTokenPosition(TokenItem tokenItem, int n, Position.Bias bias) {
        ExtTokenPosition extTokenPosition;
        if (tokenItem == null) {
            if (n != 0) {
                throw new IllegalArgumentException("Ending token position has non-zero offset=" + n);
            }
        } else if (n >= tokenItem.getImage().length()) {
            throw new IllegalArgumentException("Offset=" + n + " >= tokenLength=" + tokenItem.getImage().length());
        }
        ArrayList arrayList = this.getPosList(tokenItem);
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            extTokenPosition = (ExtTokenPosition)arrayList.get(i);
            if (extTokenPosition.getOffset() != n || extTokenPosition.getBias() != bias) continue;
            return extTokenPosition;
        }
        extTokenPosition = new ExtTokenPosition(tokenItem, n, bias);
        arrayList.add(extTokenPosition);
        return extTokenPosition;
    }

    synchronized void splitStartTokenPositions(TokenItem tokenItem, int n) {
        TokenItem tokenItem2 = tokenItem.getPrevious();
        if (tokenItem2 != null) {
            tokenItem2 = this.formatWriter.findNonEmptyToken(tokenItem2, true);
        }
        ArrayList arrayList = this.getPosList(tokenItem);
        int n2 = arrayList.size();
        ArrayList arrayList2 = this.getPosList(tokenItem2);
        for (int i = 0; i < n2; ++i) {
            ExtTokenPosition extTokenPosition = (ExtTokenPosition)arrayList.get(i);
            if (extTokenPosition.offset >= n) continue;
            extTokenPosition.token = tokenItem2;
            arrayList.remove(i);
            arrayList2.add(extTokenPosition);
            --i;
            --n2;
        }
    }

    synchronized void splitEndTokenPositions(TokenItem tokenItem, int n) {
        TokenItem tokenItem2 = tokenItem.getNext();
        if (tokenItem2 != null) {
            tokenItem2 = this.formatWriter.findNonEmptyToken(tokenItem2, false);
        }
        ArrayList arrayList = this.getPosList(tokenItem2);
        ArrayList arrayList2 = this.getPosList(tokenItem);
        int n2 = arrayList2.size();
        int n3 = tokenItem.getImage().length() - n;
        for (int i = 0; i < n2; ++i) {
            ExtTokenPosition extTokenPosition = (ExtTokenPosition)arrayList2.get(i);
            if (extTokenPosition.offset < n3) continue;
            extTokenPosition.token = tokenItem2;
            extTokenPosition.offset -= n3;
            arrayList2.remove(i);
            arrayList.add(extTokenPosition);
            --i;
            --n2;
        }
    }

    synchronized void tokenTextInsert(TokenItem tokenItem, int n, int n2) {
        ArrayList arrayList = this.getPosList(tokenItem);
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            ExtTokenPosition extTokenPosition = (ExtTokenPosition)arrayList.get(i);
            if (!(extTokenPosition.bias == Position.Bias.Backward ? extTokenPosition.offset > n : extTokenPosition.offset >= n)) continue;
            extTokenPosition.offset += n2;
        }
        if (tokenItem.getImage().length() == n) {
            TokenItem tokenItem2 = tokenItem.getNext();
            if (tokenItem2 != null) {
                tokenItem2 = this.formatWriter.findNonEmptyToken(tokenItem2, false);
            }
            arrayList = this.getPosList(tokenItem2);
            n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                ExtTokenPosition extTokenPosition = (ExtTokenPosition)arrayList.get(i);
                if (extTokenPosition.bias != Position.Bias.Backward || extTokenPosition.offset != 0) continue;
                extTokenPosition.token = tokenItem;
                extTokenPosition.offset = n;
            }
        }
    }

    synchronized void tokenTextRemove(TokenItem tokenItem, int n, int n2) {
        ArrayList arrayList = this.getPosList(tokenItem);
        int n3 = arrayList.size();
        int n4 = tokenItem.getImage().length() - n2;
        ArrayList arrayList2 = this.getPosList(tokenItem.getNext());
        for (int i = 0; i < n3; ++i) {
            ExtTokenPosition extTokenPosition = (ExtTokenPosition)arrayList.get(i);
            if (extTokenPosition.offset >= n + n2) {
                extTokenPosition.offset -= n2;
            } else if (extTokenPosition.offset >= n) {
                extTokenPosition.offset = n;
            }
            if (extTokenPosition.offset < n4) continue;
            extTokenPosition.token = tokenItem.getNext();
            extTokenPosition.offset = 0;
            arrayList.remove(i);
            arrayList2.add(extTokenPosition);
            --i;
            --n3;
        }
    }

    synchronized void tokenRemove(TokenItem tokenItem) {
        TokenItem tokenItem2 = tokenItem.getNext();
        if (tokenItem2 != null) {
            tokenItem2 = this.formatWriter.findNonEmptyToken(tokenItem2, false);
        }
        ArrayList arrayList = this.getPosList(tokenItem2);
        ArrayList arrayList2 = this.getPosList(tokenItem);
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            ExtTokenPosition extTokenPosition = (ExtTokenPosition)arrayList2.get(i);
            extTokenPosition.token = tokenItem2;
            extTokenPosition.offset = 0;
            arrayList.add(extTokenPosition);
        }
        arrayList2.clear();
        this.tokens2positionLists.remove(tokenItem);
    }

    synchronized void tokenInsert(TokenItem tokenItem) {
        if (tokenItem.getImage().length() > 0) {
            ArrayList arrayList = this.getPosList(tokenItem);
            TokenItem tokenItem2 = tokenItem.getNext();
            if (tokenItem2 != null) {
                tokenItem2 = this.formatWriter.findNonEmptyToken(tokenItem2, false);
            }
            ArrayList arrayList2 = this.getPosList(tokenItem2);
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                ExtTokenPosition extTokenPosition = (ExtTokenPosition)arrayList2.get(i);
                if (extTokenPosition.offset != 0 || extTokenPosition.getBias() != Position.Bias.Backward) continue;
                extTokenPosition.token = tokenItem;
                arrayList2.remove(i);
                --i;
                --n;
                arrayList.add(extTokenPosition);
            }
        }
    }

    synchronized void clearSaveSets() {
        this.firstSet = null;
        this.lastSet = null;
    }

    synchronized void addSaveSet(int n, int n2, int[] nArray, Position.Bias[] biasArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 0 && nArray[i] <= n2) continue;
            throw new IllegalArgumentException("Invalid save-offset=" + nArray[i] + " at index=" + i + ". Written length is " + n2);
        }
        SaveSet saveSet = new SaveSet(n, nArray, biasArray);
        if (this.firstSet != null) {
            this.lastSet.next = saveSet;
            this.lastSet = saveSet;
        } else {
            this.firstSet = this.lastSet = saveSet;
        }
    }

    synchronized void createPositions(FormatTokenPosition formatTokenPosition) {
        boolean bl;
        this.updateSaveOffsets(formatTokenPosition);
        SaveSet saveSet = this.firstSet;
        FormatWriter.FormatTokenItem formatTokenItem = (FormatWriter.FormatTokenItem)formatTokenPosition.getToken();
        boolean bl2 = bl = formatTokenItem == null;
        while (saveSet != null) {
            int n = saveSet.offsets.length;
            for (int i = 0; i < n; ++i) {
                if (bl) {
                    saveSet.positions[i] = this.getTokenPosition(null, 0, saveSet.biases[i]);
                    continue;
                }
                int n2 = saveSet.offsets[i];
                while (formatTokenItem != null) {
                    if (n2 < formatTokenItem.getSaveOffset()) {
                        formatTokenItem = (FormatWriter.FormatTokenItem)formatTokenItem.getPrevious();
                        continue;
                    }
                    if (n2 > formatTokenItem.getSaveOffset() + formatTokenItem.getImage().length() || formatTokenItem.getImage().length() == 0) {
                        formatTokenItem = (FormatWriter.FormatTokenItem)formatTokenItem.getNext();
                        continue;
                    }
                    saveSet.positions[i] = this.getTokenPosition(formatTokenItem, n2 - formatTokenItem.getSaveOffset(), saveSet.biases[i]);
                    break;
                }
                if (formatTokenItem != null) continue;
                saveSet.positions[i] = this.getTokenPosition(null, 0, saveSet.biases[i]);
                formatTokenItem = (FormatWriter.FormatTokenItem)this.formatWriter.getLastToken();
            }
            saveSet = saveSet.next;
        }
    }

    synchronized void updateSaveSets(FormatTokenPosition formatTokenPosition) {
        this.updateSaveOffsets(formatTokenPosition);
        SaveSet saveSet = this.firstSet;
        int n = 0;
        if (formatTokenPosition.getToken() != null) {
            n = ((FormatWriter.FormatTokenItem)this.formatWriter.getLastToken()).getSaveOffset() + this.formatWriter.getLastToken().getImage().length();
        }
        while (saveSet != null) {
            int n2 = saveSet.offsets.length;
            for (int i = 0; i < n2; ++i) {
                FormatWriter.FormatTokenItem formatTokenItem = (FormatWriter.FormatTokenItem)saveSet.positions[i].getToken();
                saveSet.offsets[i] = formatTokenItem == null ? n : formatTokenItem.getSaveOffset() + saveSet.positions[i].getOffset();
            }
        }
    }

    private void updateSaveOffsets(FormatTokenPosition formatTokenPosition) {
        if (this.firstSet != null) {
            int n = -formatTokenPosition.getOffset();
            for (FormatWriter.FormatTokenItem formatTokenItem = (FormatWriter.FormatTokenItem)formatTokenPosition.getToken(); formatTokenItem != null; formatTokenItem = (FormatWriter.FormatTokenItem)formatTokenItem.getNext()) {
                formatTokenItem.setSaveOffset(n);
                n += formatTokenItem.getImage().length();
            }
        }
    }

    static class SaveSet {
        SaveSet next;
        int baseOffset;
        int[] offsets;
        Position.Bias[] biases;
        FormatTokenPosition[] positions;

        SaveSet(int n, int[] nArray, Position.Bias[] biasArray) {
            this.baseOffset = n;
            this.offsets = nArray;
            this.biases = biasArray;
        }
    }

    class ExtTokenPosition
    implements FormatTokenPosition {
        TokenItem token;
        int offset;
        Position.Bias bias;

        ExtTokenPosition(TokenItem tokenItem, int n) {
            this(tokenItem, n, Position.Bias.Forward);
        }

        ExtTokenPosition(TokenItem tokenItem, int n, Position.Bias bias) {
            this.token = tokenItem;
            this.offset = n;
            this.bias = bias;
        }

        public TokenItem getToken() {
            return this.token;
        }

        public int getOffset() {
            return this.token != null ? this.offset : 0;
        }

        public Position.Bias getBias() {
            return this.bias;
        }

        public boolean equals(Object object) {
            return this.equals(object, true);
        }

        public boolean equals(Object object, boolean bl) {
            if (object instanceof FormatTokenPosition) {
                FormatTokenPosition formatTokenPosition = (FormatTokenPosition)object;
                return this.token == formatTokenPosition.getToken() && this.offset == formatTokenPosition.getOffset() && (bl || this.bias == formatTokenPosition.getBias());
            }
            return false;
        }

        public String toString() {
            return "<" + this.getToken() + ", " + this.getOffset() + ", " + this.getBias() + ">";
        }
    }
}

