/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.EditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorNames;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.Language;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.TokenContext;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColoringMap {
    private static final Logger LOG = Logger.getLogger(ColoringMap.class.getName());
    public static final String PROP_COLORING_MAP = "ColoringMap.PROP_COLORING_MAP";
    private static final Map<MimePath, ColoringMap> CACHE = new WeakHashMap<MimePath, ColoringMap>();
    private static final ColoringMap EMPTY = new ColoringMap();
    private static final ThreadLocal<Boolean> IN_GET = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final List<String> legacyNonTokenColoringNames;
    private final Language<?> lexerLanguage;
    private final List<? extends TokenContext> syntaxLanguages;
    private final Lookup.Result<FontColorSettings> lookupResult;
    private final LookupListener lookupListener = new LookupListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent lookupEvent) {
            String string = ColoringMap.this.LOCK;
            synchronized (string) {
                ColoringMap.this.map = null;
            }
            ColoringMap.this.PCS.firePropertyChange(ColoringMap.PROP_COLORING_MAP, null, null);
        }
    };
    private final PropertyChangeSupport PCS = new PropertyChangeSupport(this);
    private final String LOCK = new String("ColoringMap.LOCK");
    private Map<String, Coloring> map = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColoringMap get(String string) {
        if (!IN_GET.get().booleanValue()) {
            IN_GET.set(true);
            try {
                ColoringMap coloringMap = ColoringMap.getInternal(string);
                return coloringMap;
            }
            finally {
                IN_GET.set(false);
            }
        }
        return EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Coloring> getMap() {
        String string = this.LOCK;
        synchronized (string) {
            if (this.map == null) {
                this.map = ColoringMap.loadTheMap(this.legacyNonTokenColoringNames, this.lexerLanguage, this.syntaxLanguages, this.lookupResult.allInstances());
            }
            return this.map;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.PCS.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.PCS.removePropertyChangeListener(propertyChangeListener);
    }

    private ColoringMap() {
        this.legacyNonTokenColoringNames = null;
        this.lexerLanguage = null;
        this.syntaxLanguages = null;
        this.lookupResult = null;
        this.map = Collections.emptyMap();
    }

    private ColoringMap(List<String> list, Language<?> language, List<? extends TokenContext> list2, Lookup.Result<FontColorSettings> result) {
        this.legacyNonTokenColoringNames = list;
        this.lexerLanguage = language;
        this.syntaxLanguages = list2;
        this.lookupResult = result;
        this.map = ColoringMap.loadTheMap(list, language, list2, result.allInstances());
        this.lookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.lookupListener, this.lookupResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ColoringMap getInternal(String string) {
        ColoringMap coloringMap;
        MimePath mimePath = string == null || string.length() == 0 ? MimePath.EMPTY : MimePath.parse((String)string);
        Object object = CACHE;
        synchronized (object) {
            coloringMap = CACHE.get(mimePath);
            if (coloringMap != null) {
                return coloringMap;
            }
        }
        object = ColoringMap.findLegacyNonTokenColoringNames(mimePath);
        coloringMap = MimeLookup.getLookup((MimePath)mimePath).lookupResult(FontColorSettings.class);
        Language language = null;
        List<? extends TokenContext> list = null;
        if (mimePath.size() > 0) {
            language = Language.find((String)mimePath.getPath());
            list = ColoringMap.findSyntaxLanguage(mimePath);
        }
        LOG.fine("Creating ColoringMap for '" + string + "' ---------------------------");
        ColoringMap coloringMap2 = new ColoringMap((List<String>)object, language, list, (Lookup.Result<FontColorSettings>)coloringMap);
        LOG.fine("----------------------------------------------------------------------");
        Map<MimePath, ColoringMap> map = CACHE;
        synchronized (map) {
            ColoringMap coloringMap3 = CACHE.get(mimePath);
            if (coloringMap3 == null) {
                coloringMap3 = coloringMap2;
                CACHE.put(mimePath, coloringMap3);
            }
            return coloringMap3;
        }
    }

    private static Map<String, Coloring> loadTheMap(List<String> list, Language<?> language, List<? extends TokenContext> list2, Collection<? extends FontColorSettings> collection) {
        HashMap<String, Coloring> hashMap = new HashMap<String, Coloring>();
        if (!collection.isEmpty()) {
            FontColorSettings fontColorSettings = collection.iterator().next();
            if (list != null) {
                ColoringMap.collectLegacyNonTokenColorings(hashMap, list, fontColorSettings);
            }
            ColoringMap.collectNonTokenColorings(hashMap, fontColorSettings);
            if (list2 != null) {
                ColoringMap.collectLegacyTokenColorings(hashMap, list2, fontColorSettings);
            }
            if (language != null) {
                ColoringMap.collectTokenColorings(hashMap, language, fontColorSettings);
            }
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private static void collectNonTokenColorings(HashMap<String, Coloring> hashMap, FontColorSettings fontColorSettings) {
        for (Field field : FontColorNames.class.getDeclaredFields()) {
            String string;
            AttributeSet attributeSet;
            Object object = null;
            try {
                object = field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (!(object instanceof String) || (attributeSet = fontColorSettings.getFontColors(string = (String)object)) == null) continue;
            LOG.fine("Loading coloring '" + string + "'");
            hashMap.put(string, Coloring.fromAttributeSet(attributeSet));
        }
    }

    private static void collectLegacyNonTokenColorings(HashMap<String, Coloring> hashMap, List<String> list, FontColorSettings fontColorSettings) {
        for (int i = list.size() - 1; i >= 0; --i) {
            String string = list.get(i);
            AttributeSet attributeSet = fontColorSettings.getFontColors(string);
            if (attributeSet == null) continue;
            LOG.fine("Loading legacy coloring '" + string + "'");
            hashMap.put(string, Coloring.fromAttributeSet(attributeSet));
        }
    }

    private static void collectTokenColorings(HashMap<String, Coloring> hashMap, Language<?> language, FontColorSettings fontColorSettings) {
        AttributeSet attributeSet;
        for (String string : language.tokenCategories()) {
            attributeSet = fontColorSettings.getTokenFontColors(string);
            if (attributeSet == null) continue;
            LOG.fine("Loading token coloring '" + string + "'");
            hashMap.put(string, Coloring.fromAttributeSet(attributeSet));
        }
        for (String string : language.tokenIds()) {
            attributeSet = fontColorSettings.getTokenFontColors(string.name());
            if (attributeSet == null) continue;
            LOG.fine("Loading token coloring '" + string.name() + "'");
            hashMap.put(string.name(), Coloring.fromAttributeSet(attributeSet));
        }
    }

    private static void collectLegacyTokenColorings(HashMap<String, Coloring> hashMap, List<? extends TokenContext> list, FontColorSettings fontColorSettings) {
        for (int i = list.size() - 1; i >= 0; --i) {
            TokenContext tokenContext = list.get(i);
            TokenContextPath[] tokenContextPathArray = tokenContext.getAllContextPaths();
            for (int j = 0; j < tokenContextPathArray.length; ++j) {
                Object object;
                TokenContext tokenContext2 = tokenContextPathArray[j].getContexts()[0];
                TokenCategory[] tokenCategoryArray = tokenContext2.getTokenCategories();
                for (int k = 0; k < tokenCategoryArray.length; ++k) {
                    String string = tokenContextPathArray[j].getFullTokenName(tokenCategoryArray[k]);
                    object = fontColorSettings.getTokenFontColors(string);
                    if (object == null) continue;
                    LOG.fine("Loading legacy token coloring '" + string + "'");
                    hashMap.put(string, Coloring.fromAttributeSet((AttributeSet)object));
                }
                TokenID[] tokenIDArray = tokenContext2.getTokenIDs();
                for (int k = 0; k < tokenIDArray.length; ++k) {
                    object = tokenContextPathArray[j].getFullTokenName(tokenIDArray[k]);
                    AttributeSet attributeSet = fontColorSettings.getTokenFontColors((String)object);
                    if (attributeSet == null) continue;
                    LOG.fine("Loading legacy token coloring '" + (String)object + "'");
                    hashMap.put((String)object, Coloring.fromAttributeSet(attributeSet));
                }
            }
        }
    }

    private static List<String> findLegacyNonTokenColoringNames(MimePath mimePath) {
        EditorKit editorKit = (EditorKit)MimeLookup.getLookup((MimePath)mimePath).lookup(EditorKit.class);
        List list = null;
        if (editorKit != null) {
            List list2;
            list = list2 = SettingsUtil.getCumulativeList(editorKit.getClass(), "coloring-name-list", null);
        }
        return list;
    }

    private static List<? extends TokenContext> findSyntaxLanguage(MimePath mimePath) {
        EditorKit editorKit = (EditorKit)MimeLookup.getLookup((MimePath)mimePath).lookup(EditorKit.class);
        List list = null;
        if (editorKit != null) {
            List list2;
            list = list2 = SettingsUtil.getList(editorKit.getClass(), "token-context-list", null);
        }
        return list;
    }
}

