/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.formatting.actions;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.formatting.actions.AbstractFormattingToolAction;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Rectangle;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;

public class AlignMarginRightAction
extends AbstractFormattingToolAction {
    public AlignMarginRightAction() {
        this.putValue("Name", this.getName());
    }

    protected String iconResource() {
        return "com/jaspersoft/ireport/designer/resources/formatting/align_margin_right.png";
    }

    protected void performAction(Node[] nodes) {
        if (nodes.length == 0) {
            return;
        }
        JasperDesign jd = (JasperDesign)nodes[0].getLookup().lookup(JasperDesign.class);
        if (jd == null) {
            return;
        }
        List<JRDesignElement> elements = this.getSelectedElements(nodes);
        boolean aggregate = false;
        for (JRDesignElement element : elements) {
            Rectangle oldBounds = this.getElementBounds(element);
            Rectangle rect = ModelUtils.getParentBounds(jd, element);
            element.setX(rect.width - element.getWidth());
            aggregate = this.addTransformationUndo(element, oldBounds, aggregate);
        }
    }

    public String getName() {
        return I18n.getString("formatting.tools.alignMarginRight");
    }
}

