/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.jrctx.nodes.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.SeriesColorsProperty;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.jasperreports.chartthemes.simple.ColorProvider;
import net.sf.jasperreports.chartthemes.simple.PlotSettings;
import net.sf.jasperreports.engine.base.JRBaseChartPlot;

public final class PlotSeriesColorsProperty
extends SeriesColorsProperty {
    private final PlotSettings settings;

    public PlotSeriesColorsProperty(PlotSettings settings) {
        super("seriesColors", "Series Colors", "Series Colors");
        this.settings = settings;
    }

    public Object getValue() {
        TreeSet<JRBaseChartPlot.JRBaseSeriesColor> set = new TreeSet<JRBaseChartPlot.JRBaseSeriesColor>();
        if (this.settings.getSeriesColorSequence() != null) {
            for (int i = 0; i < this.settings.getSeriesColorSequence().size(); ++i) {
                set.add(new JRBaseChartPlot.JRBaseSeriesColor(i, ((ColorProvider)this.settings.getSeriesColorSequence().get(i)).getColor()));
            }
        }
        return set;
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.setPropertyValue(val);
    }

    private void setPropertyValue(Object val) {
        if (val instanceof SortedSet) {
            if (val == this.settings.getSeriesColorSequence()) {
                return;
            }
            SortedSet oldValue = (SortedSet)this.getValue();
            SortedSet newValue = (SortedSet)val;
            ArrayList<ColorProvider> colors = new ArrayList<ColorProvider>();
            if (newValue != null) {
                Iterator it = newValue.iterator();
                while (it.hasNext()) {
                    colors.add(new ColorProvider(((JRBaseChartPlot.JRBaseSeriesColor)it.next()).getColor()));
                }
            }
            this.settings.setSeriesColorSequence(colors);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.settings, "SeriesColors", Collection.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }
}

