/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.editors;

import com.jaspersoft.ireport.designer.sheet.editors.SeriesColorsPropertyCustomEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import java.util.Iterator;
import java.util.SortedSet;
import net.sf.jasperreports.engine.JRChartPlot;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;

public class SeriesColorsPropertyEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private boolean customEd = true;
    private PropertyEnv env;

    public boolean isEditable() {
        return false;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        SortedSet colors = (SortedSet)this.getValue();
        if (colors == null) {
            super.paintValue(gfx, box);
        } else {
            int cols = colors.size();
            int bw = 10;
            while (cols > 0 && (bw + 2) * cols > box.width) {
                if (bw > 4) {
                    --bw;
                    continue;
                }
                --cols;
            }
            int x = box.x + 1;
            Iterator it = colors.iterator();
            for (int i = 0; i < cols && it.hasNext(); ++i) {
                JRChartPlot.JRSeriesColor color = (JRChartPlot.JRSeriesColor)it.next();
                gfx.setColor(color.getColor());
                gfx.fillRect(x, box.y + 3, bw, Math.min(box.height - 6, 10));
                gfx.setColor(Color.BLACK);
                gfx.drawRect(x, box.y + 3, bw, Math.min(box.height - 6, 10));
                x += bw + 2;
            }
        }
    }

    public String getAsText() {
        return "test";
    }

    public void setAsText(String s) {
    }

    public boolean supportsCustomEditor() {
        return this.customEd;
    }

    public Component getCustomEditor() {
        SortedSet val = (SortedSet)this.getValue();
        return new SeriesColorsPropertyCustomEditor(val, false, null, this, this.env);
    }

    public void attachEnv(PropertyEnv env) {
        FeatureDescriptor desc = env.getFeatureDescriptor();
        if (desc instanceof Node.Property) {
            Node.Property prop = (Node.Property)desc;
            this.customEd = !Boolean.TRUE.equals(prop.getValue("suppressCustomEditor"));
        }
        this.env = env;
    }
}

