/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ReportClassLoader;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.GraphicsEnvironment;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.util.JRFontUtil;
import org.openide.nodes.PropertySupport;

public class FontNameProperty
extends PropertySupport.ReadWrite
implements PreferenceChangeListener {
    private final JRFont font;
    PropertyEditor editor = null;

    public FontNameProperty(JRFont font) {
        super("fontName", String.class, I18n.getString("Global.Property.Fontname"), I18n.getString("Global.Property.Fontname"));
        this.font = font;
        this.setValue("canEditAsText", true);
        this.setValue("oneline", true);
        this.setValue("suppressCustomEditor", true);
        IReportManager.getPreferences().addPreferenceChangeListener(this);
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.font.getFontName();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (val == null || val instanceof String) {
            String oldValue = this.font.getOwnFontName();
            String newValue = (String)val;
            this.font.setFontName(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.font, "FontName", String.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public boolean isDefaultValue() {
        return this.font.getOwnFontName() == null;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(null);
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    private void updateTags() {
        ArrayList<Tag> classes = new ArrayList<Tag>();
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new ReportClassLoader(IReportManager.getReportClassLoader()));
        Collection extensionFonts = JRFontUtil.getFontFamilyNames();
        for (String fname : extensionFonts) {
            classes.add(new Tag(fname));
        }
        String[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        classes.add(new Tag("sansserif", "SansSerif"));
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            classes.add(new Tag(name));
        }
        Thread.currentThread().setContextClassLoader(oldCL);
        if (this.editor == null) {
            this.editor = new ComboBoxPropertyEditor(true, classes);
        } else {
            ((ComboBoxPropertyEditor)this.editor).setTagValues(classes);
        }
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.updateTags();
        }
        return this.editor;
    }

    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt == null || evt.getKey() == null || evt.getKey().equals("IREPORT_CLASSPATH")) {
            this.updateTags();
        }
    }
}

