/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class MaskedPlainDocument
extends PlainDocument {
    public static final int NO_MAX_LENGTH = 0;
    public static final String COLOR_MASK = "(#?)(([0-9]|[a-f]|[A-F]){0,6})";
    private String mask = null;
    private int maxLength = 0;

    public MaskedPlainDocument(String mask, int maxLength) {
        this.mask = mask;
        this.maxLength = maxLength;
    }

    public MaskedPlainDocument(String mask) {
        this(mask, 0);
    }

    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str == null) {
            return;
        }
        if (this.maxLength > 0 && offset >= this.maxLength) {
            return;
        }
        if (this.maxLength > 0 && str.length() > this.maxLength) {
            str = str.substring(0, this.maxLength);
        }
        try {
            String currentString = this.getText(0, offset);
            currentString = currentString + str;
            if (offset < this.getLength()) {
                currentString = currentString + this.getText(offset, this.getLength() - offset);
            }
            if ((currentString = currentString.trim()).matches(this.mask)) {
                str = str.toUpperCase();
                super.insertString(offset, str, attr);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }
}

