/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.undo;

import com.jaspersoft.ireport.designer.undo.AggregatedUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;

public class DeleteStyleUndoableEdit
extends AggregatedUndoableEdit {
    private JRDesignStyle style = null;
    private JasperDesign jasperDesign = null;
    private int index = -1;

    public DeleteStyleUndoableEdit(JRDesignStyle style, JasperDesign jasperDesign, int index) {
        this.style = style;
        this.jasperDesign = jasperDesign;
        this.index = index;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        if (this.index > -1) {
            this.jasperDesign.getStylesList().add(this.index, this.getStyle());
        } else {
            this.jasperDesign.getStylesList().add(this.getStyle());
        }
        this.jasperDesign.getEventSupport().firePropertyChange("styles", null, null);
    }

    public void redo() throws CannotRedoException {
        super.redo();
        this.index = this.jasperDesign.getStylesList().indexOf(this.getStyle());
        this.jasperDesign.removeStyle((JRStyle)this.getStyle());
    }

    public String getPresentationName() {
        return "Delete Style " + this.getStyle().getName();
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
    }

    public JRDesignStyle getStyle() {
        return this.style;
    }

    public void setStyle(JRDesignStyle style) {
        this.style = style;
    }
}

