/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.utils;

import java.util.HashMap;

public class Unit {
    public static final double PIXEL = 1.0;
    public static final double INCHES = 72.0;
    public static final double CENTIMETERS = 28.3464;
    public static final double MILLIMETERS = 2.83464;
    private String unitName;
    private String keyName;
    private double conversionValue;
    private static Unit[] units = null;
    private static HashMap<String, Unit> unitsMap = null;

    public Unit(String unitName, double conversionValue) {
        this(unitName, conversionValue, unitName);
    }

    public Unit(String unitName, double conversionValue, String keyName) {
        this.unitName = unitName;
        this.conversionValue = conversionValue;
        this.setKeyName(keyName);
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public double getConversionValue() {
        return this.conversionValue;
    }

    public void setConversionValue(double conversionValue) {
        this.conversionValue = conversionValue;
    }

    public static Unit[] getStandardUnits() {
        if (units == null) {
            unitsMap = new HashMap();
            units = new Unit[4];
            Unit.units[0] = new Unit("pixels", 1.0, "pixels");
            unitsMap.put("pixels", units[0]);
            Unit.units[1] = new Unit("inches", 72.0, "inches");
            unitsMap.put("inches", units[1]);
            Unit.units[2] = new Unit("cm", 28.3464, "cm");
            unitsMap.put("cm", units[2]);
            Unit.units[3] = new Unit("mm", 2.83464, "mm");
            unitsMap.put("mm", units[3]);
        }
        return units;
    }

    public static int getUnitIndex(String unitName) {
        Unit[] units = Unit.getStandardUnits();
        for (int i = 0; i < units.length; ++i) {
            if (!units[i].getUnitName().equalsIgnoreCase(unitName)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return this.getUnitName();
    }

    public static double convertPixelsToInches(long pixels) {
        return (double)pixels / 72.0;
    }

    public static long convertInchesToPixels(double inches) {
        return (long)(inches * 72.0);
    }

    public static double convertPixelsToCentimeters(long pixels) {
        return (double)pixels / 28.3464;
    }

    public static long convertCentimetersToPixels(double centimeters) {
        return (long)(centimeters * 28.3464);
    }

    public static double convertPixelsToMillimeters(long pixels) {
        return (double)pixels / 2.83464;
    }

    public static long convertMillimetersToPixels(double millimeters) {
        return (long)(millimeters * 28.3464);
    }

    public static long convertToPixels(double value, double convert) {
        return (long)(value * convert);
    }

    public static Unit getUnit(String unitName) {
        if (unitsMap == null) {
            Unit.getStandardUnits();
        }
        return unitsMap.get(unitName);
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }
}

