/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class AutoupdateSettings {
    private static final String PROP_OPEN_CONNECTION_TIMEOUT = "plugin.manager.connection.timeout";
    public static final int DEFAULT_OPEN_CONNECTION_TIMEOUT = 30000;
    private static final String PROP_LAST_CHECK = "lastCheckTime";
    private static final Logger err = Logger.getLogger(AutoupdateSettings.class.getName());

    private AutoupdateSettings() {
    }

    public static void setLastCheck(Date date) {
        err.log(Level.FINER, "Set the last check to " + date);
        if (date != null) {
            AutoupdateSettings.getPreferences().putLong(PROP_LAST_CHECK, date.getTime());
        } else {
            AutoupdateSettings.getPreferences().remove(PROP_LAST_CHECK);
        }
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("/org/netbeans/modules/autoupdate");
    }

    public static int getOpenConnectionTimeout() {
        return AutoupdateSettings.getPreferences().getInt(PROP_OPEN_CONNECTION_TIMEOUT, 30000);
    }
}

