/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Log {
    private static final String DEFAULT_NAME = "SEVERE";
    private static final Level DEFAULT = Level.SEVERE;
    private static final String OFF_NAME = "OFF";
    private static final Level OFF_LEVEL = Level.OFF;
    private static final String[] LEVEL_NAMES = new String[]{"OFF", "SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST"};
    private static final Level[] LEVELS = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST};
    private static Log log = null;
    private Logger logger = null;
    private Level level = DEFAULT;
    private String packageName;
    private static ResourceBundle rb = ResourceBundle.getBundle("org.netbeans.modules.db.sql.visualeditor.Bundle", Locale.getDefault());

    Log(String string) {
        this.packageName = string;
    }

    private Logger getPackageLogger() {
        if (this.logger == null) {
            String string = System.getProperty(this.packageName, DEFAULT_NAME);
            for (int i = 1; i < LEVELS.length; ++i) {
                if (!string.toLowerCase().equals(LEVEL_NAMES[i].toLowerCase())) continue;
                this.level = LEVELS[i];
                break;
            }
            LogManager.getLogManager().addLogger(new Logger(this.packageName, null){});
            this.logger = LogManager.getLogManager().getLogger(this.packageName);
            if (this.logger == null) {
                System.out.println(this.packageName + ": " + rb.getString("CANT_GET_LOGGER"));
                return Logger.getLogger("global");
            }
            try {
                this.logger.setLevel(this.level);
                ConsoleHandler consoleHandler = new ConsoleHandler();
                consoleHandler.setLevel(this.level);
                this.logger.setUseParentHandlers(false);
                Formatter formatter = new Formatter(){

                    public String format(LogRecord logRecord) {
                        Object[] objectArray;
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(logRecord.getLevel().getLocalizedName());
                        stringBuffer.append(' ');
                        if (logRecord.getLoggerName() != null) {
                            stringBuffer.append('[');
                            stringBuffer.append(logRecord.getLoggerName());
                            stringBuffer.append("]: ");
                        }
                        if (logRecord.getSourceClassName() != null) {
                            stringBuffer.append("| ");
                            if (logRecord.getLevel().equals(Level.FINEST)) {
                                objectArray = logRecord.getSourceClassName();
                                stringBuffer.append(objectArray.substring(Math.max(objectArray.lastIndexOf(46) + 1, 0)));
                            } else {
                                stringBuffer.append(logRecord.getSourceClassName());
                            }
                            stringBuffer.append(' ');
                        }
                        if (logRecord.getSourceMethodName() != null) {
                            stringBuffer.append("|  ");
                            stringBuffer.append(logRecord.getSourceMethodName());
                            stringBuffer.append("( ");
                            objectArray = logRecord.getParameters();
                            if (objectArray != null) {
                                for (int i = 0; i < objectArray.length; ++i) {
                                    if (i != 0) {
                                        stringBuffer.append(", ");
                                    }
                                    stringBuffer.append(objectArray[i]);
                                }
                            }
                            stringBuffer.append(" ) ");
                        }
                        if (logRecord.getThrown() != null) {
                            stringBuffer.append("| ");
                            stringBuffer.append(logRecord.getThrown());
                        }
                        if (logRecord.getMessage() != null) {
                            stringBuffer.append('|');
                            stringBuffer.append(logRecord.getMessage());
                        }
                        stringBuffer.append('\n');
                        return stringBuffer.toString();
                    }
                };
                consoleHandler.setFormatter(formatter);
                this.logger.addHandler(consoleHandler);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return this.logger;
    }

    public static Logger getLogger() {
        if (log == null) {
            log = new Log(Log.class.getPackage().getName());
        }
        return log.getPackageLogger();
    }
}

