/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.lexer.CharPreprocessor;
import org.netbeans.lib.lexer.CharPreprocessorError;
import org.netbeans.lib.lexer.CharProvider;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.PreprocessedTextStorage;
import org.netbeans.lib.lexer.token.AbstractToken;

public final class CharPreprocessorOperation
implements CharProvider {
    private static final boolean testing = Boolean.getBoolean("netbeans.debug.lexer.test");
    private CharProvider parent;
    private CharPreprocessor preprocessor;
    private int readIndex;
    private int lookaheadIndex;
    private int prepStartIndex;
    private int prepEndIndex;
    private char[] prepChars = ArrayUtilities.emptyCharArray();
    private int[] rawLengthShifts;
    private int lastOutputChar;
    private int tokenLength;
    private LexerInputOperation lexerInputOperation;
    private int tokenEndRawLengthShift;

    CharPreprocessorOperation(CharProvider charProvider, CharPreprocessor charPreprocessor, LexerInputOperation lexerInputOperation) {
        this.parent = charProvider;
        this.preprocessor = charPreprocessor;
        this.lexerInputOperation = lexerInputOperation;
    }

    public void initApprovedToken(AbstractToken abstractToken) {
    }

    public int inputRead() {
        return this.parent.read();
    }

    public void inputBackup(int n) {
        this.parent.backup(n);
    }

    public void outputOriginal(int n) {
        this.lastOutputChar = n;
        if (n != -1) {
            if (this.prepStartIndex == this.lookaheadIndex) {
                ++this.prepStartIndex;
            }
            ++this.lookaheadIndex;
        }
    }

    public void outputPreprocessed(char c, int n) {
        this.lastOutputChar = c;
        if (this.prepStartIndex == this.lookaheadIndex) {
            this.prepEndIndex = this.prepStartIndex;
        } else if (this.prepEndIndex < this.lookaheadIndex) {
            do {
                this.addPrepChar(this.parent.readExisting(this.prepEndIndex), 0);
            } while (this.prepEndIndex < this.lookaheadIndex);
        }
        this.addPrepChar(c, n);
        ++this.lookaheadIndex;
    }

    public int deepRawLength(int n) {
        return this.parent.deepRawLength(this.parentLength(n));
    }

    public int deepRawLengthShift(int n) {
        return this.rawLengthShift(n) + this.parent.deepRawLengthShift(n);
    }

    private int rawLengthShift(int n) {
        if (n < this.prepStartIndex) {
            return n;
        }
        if (n < this.prepEndIndex) {
            return this.rawLengthShifts[n - this.prepStartIndex];
        }
        return this.totalRawLengthShift();
    }

    private int parentLength(int n) {
        if (n > this.prepStartIndex) {
            n = n <= this.prepEndIndex ? (n += this.rawLengthShifts[n - 1 - this.prepStartIndex]) : (n += this.totalRawLengthShift());
        }
        return n;
    }

    private int totalRawLengthShift() {
        return this.rawLengthShifts[this.prepEndIndex - 1 - this.prepStartIndex];
    }

    public void notifyError(String string) {
        if (this.lexerInputOperation != null) {
            int n = this.parent.readIndex();
            this.lexerInputOperation.notifyPreprocessorError(new CharPreprocessorError(string, this.parent.deepRawLength(n)));
        }
    }

    public int read() {
        if (this.readIndex == this.lookaheadIndex) {
            ++this.readIndex;
            if (this.readIndex == this.lookaheadIndex) {
                return this.lastOutputChar;
            }
            --this.readIndex;
            if (this.readIndex == this.lookaheadIndex && this.lastOutputChar == -1) {
                return -1;
            }
        }
        return this.readExisting(this.readIndex++);
    }

    public char readExisting(int n) {
        return n < this.prepStartIndex ? this.parent.readExisting(n) : (n < this.prepEndIndex ? this.prepChars[n - this.prepStartIndex] : this.parent.readExisting(n + this.totalRawLengthShift()));
    }

    public int readIndex() {
        return this.readIndex;
    }

    public void backup(int n) {
        this.readIndex -= n;
    }

    public int tokenLength() {
        return this.tokenLength;
    }

    public void tokenRecognized(int n) {
        this.tokenLength = n;
        this.parent.tokenRecognized(this.parentLength(n));
    }

    public PreprocessedTextStorage createPreprocessedTextStorage(CharSequence charSequence, CharProvider.ExtraPreprocessedChars extraPreprocessedChars) {
        PreprocessedTextStorage preprocessedTextStorage;
        int n;
        int n2;
        int n3;
        if (this.prepStartIndex >= this.tokenLength) {
            if (this.prepEndIndex > this.tokenLength) {
                this.updateTokenEndRawLengthShift();
                n3 = this.tokenLength - 1;
                while (--n3 >= this.prepStartIndex && this.rawLengthShifts[n3] == this.tokenEndRawLengthShift) {
                }
                n3 += 2;
            } else {
                n3 = this.prepEndIndex;
            }
            n2 = this.parentLength(n3);
            for (int i = this.prepStartIndex; i < n3; ++i) {
                this.rawLengthShifts[i - this.prepStartIndex] = this.deepRawLength(i + 1) - (i + 1);
            }
            n = this.prepStartIndex;
        } else {
            n = this.tokenLength;
            n3 = this.tokenLength;
            n2 = this.tokenLength;
        }
        if (extraPreprocessedChars != null) {
            this.parent.collectExtraPreprocessedChars(extraPreprocessedChars, n, n3, n2);
            preprocessedTextStorage = PreprocessedTextStorage.create(charSequence, this.prepChars, n3 - n, n, this.rawLengthShifts, extraPreprocessedChars.extraPrepChars(), extraPreprocessedChars.extraRawLengthShifts(), extraPreprocessedChars.preStartIndex(), extraPreprocessedChars.postEndIndex());
            extraPreprocessedChars.clear();
        } else {
            preprocessedTextStorage = PreprocessedTextStorage.create(charSequence, this.prepChars, n3 - n, n, this.rawLengthShifts);
        }
        return preprocessedTextStorage;
    }

    private void updateTokenEndRawLengthShift() {
        this.tokenEndRawLengthShift = this.rawLengthShifts[this.tokenLength - 1 - this.prepStartIndex];
    }

    public void collectExtraPreprocessedChars(CharProvider.ExtraPreprocessedChars extraPreprocessedChars, int n, int n2, int n3) {
        if (n < this.tokenLength) {
            int n4;
            int n5 = Math.max(n - this.prepStartIndex, 0);
            if (this.prepEndIndex > this.tokenLength) {
                this.updateTokenEndRawLengthShift();
                if (n4 > 0) {
                    int n6 = this.tokenLength - 2;
                    for (n4 = this.tokenLength - n2; --n6 >= n && n4 > 0 && this.rawLengthShifts[n6] == this.tokenEndRawLengthShift; --n4) {
                    }
                } else {
                    n4 = 0;
                }
            } else {
                n4 = this.prepEndIndex - n2;
            }
            assert (n5 >= 0 && n4 >= 0);
            extraPreprocessedChars.ensureExtraLength(n5 + n4);
            while (--n5 >= 0) {
                extraPreprocessedChars.insert(this.readExisting(n - 1), this.deepRawLength(n) - n);
                --n;
            }
            while (--n4 >= 0) {
                extraPreprocessedChars.append(this.readExisting(n2), this.deepRawLength(n2) - n3);
                ++n2;
                ++n3;
            }
        }
        this.parent.collectExtraPreprocessedChars(extraPreprocessedChars, n, n2, n3);
    }

    public void tokenApproved() {
        if (this.prepStartIndex != this.lookaheadIndex) {
            if (this.prepStartIndex < this.tokenLength) {
                if (this.prepEndIndex <= this.tokenLength) {
                    this.prepStartIndex = this.lookaheadIndex;
                } else {
                    int n = this.tokenLength;
                    while (n < this.prepEndIndex) {
                        int n2 = n++;
                        this.rawLengthShifts[n2] = this.rawLengthShifts[n2] - this.tokenEndRawLengthShift;
                    }
                    System.arraycopy(this.prepChars, this.prepStartIndex, this.prepChars, 0, this.prepEndIndex - this.prepStartIndex);
                    System.arraycopy(this.rawLengthShifts, this.prepStartIndex, this.rawLengthShifts, 0, this.prepEndIndex - this.prepStartIndex);
                    this.prepStartIndex = 0;
                    this.prepEndIndex -= this.tokenLength;
                }
            } else {
                this.prepStartIndex -= this.tokenLength;
                this.prepEndIndex -= this.tokenLength;
            }
        } else {
            this.prepStartIndex -= this.tokenLength;
        }
        this.readIndex -= this.tokenLength;
        this.lookaheadIndex -= this.tokenLength;
        this.parent.tokenApproved();
        if (testing) {
            this.consistencyCheck();
        }
    }

    private void addPrepChar(char c, int n) {
        int n2 = this.prepEndIndex - this.prepStartIndex;
        if (n2 == this.prepChars.length) {
            this.prepChars = ArrayUtilities.charArray((char[])this.prepChars);
            this.rawLengthShifts = ArrayUtilities.intArray((int[])this.rawLengthShifts);
        }
        this.prepChars[n2] = c;
        int n3 = n2 > 0 ? this.rawLengthShifts[n2 - 1] : 0;
        this.rawLengthShifts[n2] = n3 + n;
        ++this.prepEndIndex;
    }

    private void consistencyCheck() {
        if (this.readIndex > this.lookaheadIndex) {
            throw new IllegalStateException("readIndex > lookaheadIndex: " + this);
        }
        if (this.prepStartIndex > this.lookaheadIndex) {
            throw new IllegalStateException("prepStartIndex > lookaheadIndex: " + this);
        }
        if (this.prepStartIndex != this.lookaheadIndex && this.prepStartIndex >= this.prepEndIndex) {
            throw new IllegalStateException("prepStartIndex >= prepEndIndex: " + this);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("readIndex=");
        stringBuilder.append(this.readIndex);
        stringBuilder.append(", lookaheadIndex=");
        stringBuilder.append(this.lookaheadIndex);
        stringBuilder.append(", prepStartIndex=");
        stringBuilder.append(this.prepStartIndex);
        stringBuilder.append(", prepEndIndex=");
        stringBuilder.append(this.prepEndIndex);
        return stringBuilder.toString();
    }
}

