/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.token.AbstractToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubSequenceTokenList<T extends TokenId>
implements TokenList<T> {
    private TokenList<T> tokenList;
    private final int limitStartOffset;
    private final int limitEndOffset;
    private int limitStartIndex;
    private int limitEndIndex;

    public static <T extends TokenId> SubSequenceTokenList<T> create(TokenList<T> tokenList, int n, int n2) {
        return new SubSequenceTokenList<T>(tokenList, n, n2);
    }

    public SubSequenceTokenList(TokenList<T> tokenList, int n, int n2) {
        int n3;
        int n4;
        this.tokenList = tokenList;
        this.limitStartOffset = n;
        this.limitEndOffset = n2;
        if (n2 == Integer.MAX_VALUE) {
            this.limitEndIndex = tokenList.tokenCount();
        } else {
            this.limitEndIndex = tokenList.tokenCountCurrent();
            if (this.limitEndIndex == 0 && tokenList.tokenOrEmbeddingContainer(0) != null) {
                this.limitEndIndex = tokenList.tokenCountCurrent();
            }
            if (this.limitEndIndex > 0) {
                n4 = tokenList.tokenOffset(this.limitEndIndex - 1);
                if (n2 > n4) {
                    Object object;
                    AbstractToken<T> abstractToken = this.token(this.limitEndIndex - 1);
                    n3 = abstractToken.length();
                    while (n2 > n4 + n3 && (object = tokenList.tokenOrEmbeddingContainer(this.limitEndIndex)) != null) {
                        abstractToken = LexerUtilsConstants.token(object);
                        n4 = tokenList.isContinuous() || abstractToken.isFlyweight() ? (n4 += n3) : tokenList.tokenOffset(this.limitEndIndex);
                        n3 = abstractToken.length();
                        ++this.limitEndIndex;
                    }
                } else {
                    int n5 = 0;
                    --this.limitEndIndex;
                    while (n5 <= this.limitEndIndex) {
                        n3 = (n5 + this.limitEndIndex) / 2;
                        int n6 = tokenList.tokenOffset(n3);
                        if (n6 < n2) {
                            n5 = n3 + 1;
                            continue;
                        }
                        if (n6 > n2) {
                            this.limitEndIndex = n3 - 1;
                            continue;
                        }
                        this.limitEndIndex = n3 - 1;
                        break;
                    }
                    ++this.limitEndIndex;
                }
            }
        }
        if (this.limitEndIndex > 0 && n > 0) {
            n4 = this.limitEndIndex - 1;
            while (this.limitStartIndex <= n4) {
                int n7 = (this.limitStartIndex + n4) / 2;
                n3 = tokenList.tokenOffset(n7);
                if (n3 < n) {
                    this.limitStartIndex = n7 + 1;
                    continue;
                }
                if (n3 > n) {
                    n4 = n7 - 1;
                    continue;
                }
                this.limitStartIndex = n7 + 1;
                break;
            }
            if (this.limitStartIndex > 0 && tokenList.tokenOffset(this.limitStartIndex - 1) + this.token(this.limitStartIndex - 1).length() > n) {
                --this.limitStartIndex;
            }
        }
    }

    public TokenList<T> delegate() {
        return this.tokenList;
    }

    public int limitStartOffset() {
        return this.limitStartOffset;
    }

    public int limitEndOffset() {
        return this.limitEndOffset;
    }

    @Override
    public Object tokenOrEmbeddingContainer(int n) {
        return (n += this.limitStartIndex) < this.limitEndIndex ? this.tokenList.tokenOrEmbeddingContainer(n) : null;
    }

    @Override
    public int tokenOffset(int n) {
        if ((n += this.limitStartIndex) >= this.limitEndIndex) {
            throw new IndexOutOfBoundsException("index=" + n + " >= limitEndIndex=" + this.limitEndIndex);
        }
        return this.tokenList.tokenOffset(n);
    }

    @Override
    public int tokenCount() {
        return this.limitEndIndex - this.limitStartIndex;
    }

    @Override
    public int tokenCountCurrent() {
        return this.limitEndIndex - this.limitStartIndex;
    }

    @Override
    public AbstractToken<T> replaceFlyToken(int n, AbstractToken<T> abstractToken, int n2) {
        return this.tokenList.replaceFlyToken(n + this.limitStartIndex, abstractToken, n2);
    }

    @Override
    public int modCount() {
        return this.tokenList.modCount();
    }

    @Override
    public LanguagePath languagePath() {
        return this.tokenList.languagePath();
    }

    @Override
    public int childTokenOffset(int n) {
        throw new IllegalStateException("Unexpected call.");
    }

    @Override
    public char childTokenCharAt(int n, int n2) {
        throw new IllegalStateException("Unexpected call.");
    }

    @Override
    public void wrapToken(int n, EmbeddingContainer<T> embeddingContainer) {
        this.tokenList.wrapToken(this.limitStartIndex + n, embeddingContainer);
    }

    @Override
    public TokenList<?> root() {
        return this.tokenList.root();
    }

    @Override
    public TokenHierarchyOperation<?, ?> tokenHierarchyOperation() {
        return this.tokenList.tokenHierarchyOperation();
    }

    @Override
    public InputAttributes inputAttributes() {
        return this.tokenList.inputAttributes();
    }

    @Override
    public int lookahead(int n) {
        return this.tokenList.lookahead(n);
    }

    @Override
    public Object state(int n) {
        return this.tokenList.state(n);
    }

    @Override
    public boolean isContinuous() {
        return this.tokenList.isContinuous();
    }

    @Override
    public Set<T> skipTokenIds() {
        return this.tokenList.skipTokenIds();
    }

    @Override
    public int startOffset() {
        if (this.tokenCountCurrent() > 0 || this.tokenCount() > 0) {
            return this.tokenOffset(0);
        }
        return this.limitStartOffset;
    }

    @Override
    public int endOffset() {
        int n = this.tokenCount() - 1;
        if (n >= 0) {
            return this.tokenOffset(n) + this.token(n).length();
        }
        return this.limitStartOffset;
    }

    private AbstractToken<T> token(int n) {
        return LexerUtilsConstants.token(this.tokenList, n);
    }
}

