/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;
import org.netbeans.lib.lexer.SubSequenceTokenList;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenListList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenSequenceList
extends AbstractList<TokenSequence<?>> {
    private TokenHierarchyOperation<?, ?> operation;
    private final TokenListList tokenListList;
    private final List<TokenSequence<?>> tokenSequences;
    private final int endOffset;
    private final int expectedModCount;
    private int tokenListIndex;

    public TokenSequenceList(TokenHierarchyOperation<?, ?> tokenHierarchyOperation, LanguagePath languagePath, int n, int n2) {
        this.operation = tokenHierarchyOperation;
        this.endOffset = n2;
        this.expectedModCount = tokenHierarchyOperation.modCount();
        if (languagePath.size() == 1) {
            this.tokenListList = null;
            this.tokenListIndex = Integer.MAX_VALUE;
            TokenList<?> tokenList = tokenHierarchyOperation.validRootTokenList();
            if (tokenList.languagePath() == languagePath) {
                TokenSequence<?> tokenSequence = LexerApiPackageAccessor.get().createTokenSequence(this.checkWrapTokenList(tokenList, n, n2));
                this.tokenSequences = Collections.singletonList(tokenSequence);
            } else {
                this.tokenSequences = Collections.emptyList();
            }
        } else {
            EmbeddedTokenList<?> embeddedTokenList;
            this.tokenListList = tokenHierarchyOperation.tokenListList(languagePath);
            int n3 = this.tokenListList.size();
            int n4 = n3 - 1;
            if (n > 0) {
                while (this.tokenListIndex <= n4) {
                    int n5 = (this.tokenListIndex + n4) / 2;
                    EmbeddedTokenList embeddedTokenList2 = (EmbeddedTokenList)this.tokenListList.get(n5);
                    embeddedTokenList2.embeddingContainer().updateStatusImpl();
                    int n6 = embeddedTokenList2.endOffset();
                    if (n6 < n) {
                        this.tokenListIndex = n5 + 1;
                        continue;
                    }
                    if (n6 > n) {
                        n4 = n5 - 1;
                        continue;
                    }
                    this.tokenListIndex = n5 + 1;
                    break;
                }
                embeddedTokenList = this.tokenListList.getOrNull(this.tokenListIndex);
                if (this.tokenListIndex == n3) {
                    while (embeddedTokenList != null) {
                        embeddedTokenList.embeddingContainer().updateStatusImpl();
                        if (embeddedTokenList.endOffset() < n) {
                            embeddedTokenList = this.tokenListList.getOrNull(++this.tokenListIndex);
                            continue;
                        }
                        break;
                    }
                }
            } else {
                embeddedTokenList = this.tokenListList.getOrNull(0);
            }
            if (embeddedTokenList != null) {
                embeddedTokenList.embeddingContainer().updateStatusImpl();
                this.tokenSequences = new ArrayList(4);
                this.tokenSequences.add(LexerApiPackageAccessor.get().createTokenSequence(this.checkWrapTokenList(embeddedTokenList, n, n2)));
            } else {
                this.tokenSequences = Collections.emptyList();
                this.tokenListIndex = Integer.MAX_VALUE;
            }
        }
    }

    private TokenList<?> checkWrapTokenList(TokenList<?> tokenList, int n, int n2) {
        boolean bl;
        boolean bl2 = n > 0 && tokenList.startOffset() < n && n < tokenList.endOffset();
        boolean bl3 = bl = n2 != Integer.MAX_VALUE && tokenList.startOffset() < n2 && n2 < tokenList.endOffset();
        if (bl2 || bl) {
            tokenList = SubSequenceTokenList.create(tokenList, n, n2);
        }
        if (bl) {
            this.tokenListIndex = Integer.MAX_VALUE;
        }
        return tokenList;
    }

    @Override
    public Iterator<TokenSequence<?>> iterator() {
        return new Itr();
    }

    @Override
    public TokenSequence<?> get(int n) {
        this.findTokenSequenceWithIndex(n);
        return this.tokenSequences.get(n);
    }

    public TokenSequence<?> getOrNull(int n) {
        this.findTokenSequenceWithIndex(n);
        return n < this.tokenSequences.size() ? this.tokenSequences.get(n) : null;
    }

    @Override
    public int size() {
        this.findTokenSequenceWithIndex(Integer.MAX_VALUE);
        return this.tokenSequences.size();
    }

    private void findTokenSequenceWithIndex(int n) {
        while (n >= this.tokenSequences.size() && this.tokenListIndex != Integer.MAX_VALUE) {
            EmbeddedTokenList<?> embeddedTokenList;
            if ((embeddedTokenList = this.tokenListList.getOrNull(++this.tokenListIndex)) != null && (this.endOffset == Integer.MAX_VALUE || embeddedTokenList.startOffset() < this.endOffset)) {
                boolean bl;
                embeddedTokenList.embeddingContainer().updateStatus();
                boolean bl2 = bl = this.endOffset != Integer.MAX_VALUE && embeddedTokenList.startOffset() < this.endOffset && this.endOffset < embeddedTokenList.endOffset();
                if (bl) {
                    this.tokenSequences.add(LexerApiPackageAccessor.get().createTokenSequence(SubSequenceTokenList.create(embeddedTokenList, 0, this.endOffset)));
                    this.tokenListIndex = Integer.MAX_VALUE;
                    continue;
                }
                this.tokenSequences.add(LexerApiPackageAccessor.get().createTokenSequence(embeddedTokenList));
                continue;
            }
            this.tokenListIndex = Integer.MAX_VALUE;
        }
    }

    void checkForComodification() {
        if (this.expectedModCount != this.operation.modCount()) {
            throw new ConcurrentModificationException("Caller uses obsolete TokenSequenceList: expectedModCount=" + this.expectedModCount + " != modCount=" + this.operation.modCount());
        }
    }

    @Override
    public String toString() {
        return this.tokenListList.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<TokenSequence<?>> {
        private int cursor = 0;
        private TokenSequence<?> next;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            this.checkFetchNext();
            return this.next != null;
        }

        @Override
        public TokenSequence<?> next() {
            this.checkFetchNext();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            TokenSequence<?> tokenSequence = this.next;
            this.next = null;
            return tokenSequence;
        }

        private void checkFetchNext() {
            if (this.next == null) {
                TokenSequenceList.this.checkForComodification();
                this.next = TokenSequenceList.this.getOrNull(this.cursor++);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

