/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfo;
import org.openidex.search.SimpleSearchIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleSearchInfo
implements SearchInfo {
    static final SearchInfo EMPTY_SEARCH_INFO = new SearchInfo(){

        @Override
        public boolean canSearch() {
            return true;
        }

        @Override
        public Iterator<DataObject> objectsToSearch() {
            return Collections.emptyList().iterator();
        }
    };
    private final DataFolder rootFolder;
    private final boolean recursive;
    private final FileObjectFilter[] filters;

    SimpleSearchInfo(DataFolder dataFolder, boolean bl, FileObjectFilter[] fileObjectFilterArray) {
        if (dataFolder == null) {
            throw new IllegalArgumentException();
        }
        if (fileObjectFilterArray != null && fileObjectFilterArray.length == 0) {
            fileObjectFilterArray = null;
        }
        this.rootFolder = dataFolder;
        this.recursive = bl;
        this.filters = fileObjectFilterArray;
    }

    @Override
    public boolean canSearch() {
        return this.filters != null ? this.checkFolderAgainstFilters(this.rootFolder.getPrimaryFile()) : true;
    }

    @Override
    public Iterator<DataObject> objectsToSearch() {
        return new SimpleSearchIterator(this.rootFolder, this.recursive, this.filters != null ? Arrays.asList(this.filters) : null);
    }

    private boolean checkFolderAgainstFilters(FileObject fileObject) {
        assert (fileObject.isFolder());
        for (int i = 0; i < this.filters.length; ++i) {
            if (this.filters[i].traverseFolder(fileObject) != 0) continue;
            return false;
        }
        return true;
    }
}

