/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features.refactoring;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.languages.features.DatabaseContext;
import org.netbeans.modules.languages.features.DatabaseDefinition;
import org.netbeans.modules.languages.features.DatabaseItem;
import org.netbeans.modules.languages.features.DatabaseManager;
import org.netbeans.modules.languages.features.DatabaseUsage;
import org.netbeans.modules.languages.features.refactoring.RenameRefactoringUI;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class JSRefactoringsFactory
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring abstractRefactoring) {
        Lookup lookup = abstractRefactoring.getRefactoringSource();
        ASTPath aSTPath = (ASTPath)lookup.lookup(ASTPath.class);
        if (aSTPath == null) {
            return null;
        }
        if (abstractRefactoring instanceof WhereUsedQuery) {
            return new JSWhereUsedQueryPlugin((WhereUsedQuery)abstractRefactoring);
        }
        if (abstractRefactoring instanceof RenameRefactoring) {
            return new JSRenameRefactoringPlugin((RenameRefactoring)abstractRefactoring);
        }
        return null;
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dataObject) {
        Node.Cookie cookie = dataObject.getCookie(OpenCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        cookie = dataObject.getCookie(EditorCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        return null;
    }

    private static String getItemText(StyledDocument styledDocument, PositionBounds positionBounds, DatabaseItem databaseItem) {
        int n = positionBounds.getBegin().getOffset();
        int n2 = positionBounds.getEnd().getOffset();
        int n3 = styledDocument.getLength();
        int n4 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)(n3 - 1));
        int n5 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)positionBounds.getBegin().getOffset());
        int n6 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n5);
        int n7 = n5 < n4 ? NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(n5 + 1)) : n3;
        try {
            String string = styledDocument.getText(n6, n7 - n6 - 1);
            String string2 = n2 > n7 ? string : string.substring(0, n - n6) + "<b>" + string.substring(n - n6, n2 - n6) + "</b>" + string.substring(n2 - n6);
            return string2.trim();
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
            return JSRefactoringsFactory.getItemName(databaseItem);
        }
    }

    private static String getItemName(DatabaseItem databaseItem) {
        if (databaseItem instanceof DatabaseDefinition) {
            return ((DatabaseDefinition)databaseItem).getName();
        }
        if (databaseItem instanceof DatabaseUsage) {
            return ((DatabaseUsage)databaseItem).getName();
        }
        throw new IllegalArgumentException();
    }

    private static String getString(String string) {
        return NbBundle.getMessage(JSRefactoringsFactory.class, (String)string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JSCommit
    implements Transaction {
        private ArrayList<BackupFacility.Handle> ids = new ArrayList();
        private List<FileObject> refactoredFiles;
        private boolean commited = false;

        public JSCommit(List<FileObject> list) {
            this.refactoredFiles = list;
        }

        public void commit() {
            try {
                if (this.commited) {
                    for (BackupFacility.Handle handle : this.ids) {
                        try {
                            handle.restore();
                        }
                        catch (IOException iOException) {
                            throw (RuntimeException)new RuntimeException().initCause(iOException);
                        }
                    }
                } else {
                    this.commited = true;
                    for (FileObject fileObject : this.refactoredFiles) {
                        this.ids.add(BackupFacility.getDefault().backup(new FileObject[]{fileObject}));
                    }
                }
            }
            catch (IOException iOException) {
                throw (RuntimeException)new RuntimeException().initCause(iOException);
            }
        }

        public void rollback() {
            for (BackupFacility.Handle handle : this.ids) {
                try {
                    handle.restore();
                }
                catch (IOException iOException) {
                    throw (RuntimeException)new RuntimeException().initCause(iOException);
                }
            }
        }
    }

    static class RenameElement
    extends SimpleRefactoringElementImplementation {
        private DataObject dobj;
        private StyledDocument doc;
        private DatabaseItem item;
        private String newName;
        private PositionBounds bounds = null;

        public RenameElement(DataObject dataObject, StyledDocument styledDocument, DatabaseItem databaseItem, String string) {
            this.dobj = dataObject;
            this.doc = styledDocument;
            this.item = databaseItem;
            this.newName = string;
            this.getPosition();
        }

        public String getText() {
            return JSRefactoringsFactory.getItemText(this.doc, this.bounds, this.item);
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
            int n = this.bounds.getBegin().getOffset();
            try {
                this.doc.remove(n, this.item.getEndOffset() - this.item.getOffset());
                this.doc.insertString(n, this.newName, null);
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
        }

        public Object getComposite() {
            return this.getParentFile();
        }

        public FileObject getParentFile() {
            return this.dobj.getPrimaryFile();
        }

        public PositionBounds getPosition() {
            if (this.bounds == null) {
                CloneableEditorSupport cloneableEditorSupport = JSRefactoringsFactory.findCloneableEditorSupport(this.dobj);
                int n = this.item.getOffset();
                PositionRef positionRef = cloneableEditorSupport.createPositionRef(n, Position.Bias.Forward);
                PositionRef positionRef2 = cloneableEditorSupport.createPositionRef(this.item.getEndOffset(), Position.Bias.Forward);
                this.bounds = new PositionBounds(positionRef, positionRef2);
            }
            return this.bounds;
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }
    }

    public static class JSRenameRefactoringPlugin
    implements RefactoringPlugin {
        private RenameRefactoring refactoring;
        private DatabaseItem item;
        private DataObject dataObject;
        private StyledDocument document;

        public JSRenameRefactoringPlugin(RenameRefactoring renameRefactoring) {
            this.refactoring = renameRefactoring;
        }

        public Problem preCheck() {
            Lookup lookup = this.refactoring.getRefactoringSource();
            ASTPath aSTPath = (ASTPath)lookup.lookup(ASTPath.class);
            this.document = (StyledDocument)lookup.lookup(StyledDocument.class);
            this.dataObject = NbEditorUtilities.getDataObject((Document)this.document);
            DatabaseContext databaseContext = DatabaseManager.getRoot((ASTNode)aSTPath.getRoot());
            if (databaseContext == null) {
                return new Problem(true, JSRefactoringsFactory.getString("LBL_CannotRename"));
            }
            this.item = databaseContext.getDatabaseItem(aSTPath.getLeaf().getOffset());
            if (this.item == null) {
                return new Problem(true, JSRefactoringsFactory.getString("LBL_CannotRename"));
            }
            return null;
        }

        public Problem checkParameters() {
            String string;
            String string2 = this.refactoring.getNewName();
            String string3 = string = this.item instanceof DatabaseDefinition ? ((DatabaseDefinition)this.item).getName() : ((DatabaseUsage)this.item).getName();
            if (string2.equals(string)) {
                return new Problem(true, JSRefactoringsFactory.getString("LBL_NameNotChanged"));
            }
            if (string2 == null || string2.length() == 0) {
                return new Problem(true, JSRefactoringsFactory.getString("LBL_NameNotSet"));
            }
            int n = string2.length();
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                if (Character.isLetter(c) || c == '_' || c == '$' || i != 0 && Character.isDigit(c)) continue;
                String string4 = new MessageFormat(NbBundle.getMessage(RenameRefactoringUI.class, (String)"LBL_NotValidIdentifier")).format(new Object[]{string2});
                return new Problem(true, string4);
            }
            return null;
        }

        public Problem fastCheckParameters() {
            return null;
        }

        public void cancelRequest() {
        }

        public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
            String string = this.refactoring.getNewName();
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            arrayList.add(this.dataObject.getPrimaryFile());
            DatabaseDefinition databaseDefinition = this.item instanceof DatabaseDefinition ? (DatabaseDefinition)this.item : ((DatabaseUsage)this.item).getDefinition();
            refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new RenameElement(this.dataObject, this.document, databaseDefinition, string));
            Iterator<DatabaseUsage> iterator = databaseDefinition.getUsages().iterator();
            while (iterator.hasNext()) {
                refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new RenameElement(this.dataObject, this.document, iterator.next(), string));
            }
            refactoringElementsBag.registerTransaction((Transaction)new JSCommit(arrayList));
            return null;
        }
    }

    static class UsageElement
    extends SimpleRefactoringElementImplementation {
        private DataObject dobj;
        private DatabaseItem item;
        private PositionBounds bounds = null;
        private StyledDocument doc;

        public UsageElement(DataObject dataObject, StyledDocument styledDocument, DatabaseItem databaseItem) {
            this.item = databaseItem;
            this.dobj = dataObject;
            this.doc = styledDocument;
            this.getPosition();
        }

        public String getText() {
            return JSRefactoringsFactory.getItemText(this.doc, this.bounds, this.item);
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
        }

        public Object getComposite() {
            return this.getParentFile();
        }

        public FileObject getParentFile() {
            return this.dobj.getPrimaryFile();
        }

        public PositionBounds getPosition() {
            if (this.bounds == null) {
                CloneableEditorSupport cloneableEditorSupport = JSRefactoringsFactory.findCloneableEditorSupport(this.dobj);
                int n = this.item.getOffset();
                PositionRef positionRef = cloneableEditorSupport.createPositionRef(n, Position.Bias.Forward);
                PositionRef positionRef2 = cloneableEditorSupport.createPositionRef(this.item.getEndOffset(), Position.Bias.Forward);
                this.bounds = new PositionBounds(positionRef, positionRef2);
            }
            return this.bounds;
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }
    }

    public static class JSWhereUsedQueryPlugin
    implements RefactoringPlugin {
        private WhereUsedQuery refactoring;
        private DatabaseItem item;
        private DataObject dataObject;
        private StyledDocument doc;

        public JSWhereUsedQueryPlugin(WhereUsedQuery whereUsedQuery) {
            this.refactoring = whereUsedQuery;
        }

        public Problem preCheck() {
            Lookup lookup = this.refactoring.getRefactoringSource();
            this.doc = (StyledDocument)lookup.lookup(Document.class);
            this.dataObject = NbEditorUtilities.getDataObject((Document)this.doc);
            ASTPath aSTPath = (ASTPath)lookup.lookup(ASTPath.class);
            DatabaseContext databaseContext = DatabaseManager.getRoot((ASTNode)aSTPath.getRoot());
            if (databaseContext == null) {
                return new Problem(true, JSRefactoringsFactory.getString("LBL_CannotFindUsages"));
            }
            this.item = databaseContext.getDatabaseItem(aSTPath.getLeaf().getOffset());
            if (this.item == null) {
                return new Problem(true, JSRefactoringsFactory.getString("LBL_CannotFindUsages"));
            }
            return null;
        }

        public Problem checkParameters() {
            return null;
        }

        public Problem fastCheckParameters() {
            return null;
        }

        public void cancelRequest() {
        }

        public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
            DatabaseDefinition databaseDefinition = this.item instanceof DatabaseDefinition ? (DatabaseDefinition)this.item : ((DatabaseUsage)this.item).getDefinition();
            refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new UsageElement(this.dataObject, this.doc, databaseDefinition));
            Iterator<DatabaseUsage> iterator = databaseDefinition.getUsages().iterator();
            while (iterator.hasNext()) {
                refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new UsageElement(this.dataObject, this.doc, iterator.next()));
            }
            return null;
        }
    }
}

