/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.plugins.FileHandlingFactory;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FileMovePlugin
implements RefactoringPlugin {
    private MoveRefactoring refactoring;

    public FileMovePlugin(MoveRefactoring moveRefactoring) {
        this.refactoring = moveRefactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        for (FileObject fileObject : this.refactoring.getRefactoringSource().lookupAll(FileObject.class)) {
            refactoringElementsBag.addFileChange(this.refactoring, new MoveFile(fileObject, refactoringElementsBag));
        }
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    private class MoveFile
    extends SimpleRefactoringElementImplementation {
        private FileObject fo;
        DataFolder sourceFolder;
        DataObject source;

        public MoveFile(FileObject fileObject, RefactoringElementsBag refactoringElementsBag) {
            this.fo = fileObject;
        }

        public String getText() {
            return NbBundle.getMessage(FileMovePlugin.class, (String)"TXT_MoveFile", (Object)this.fo.getNameExt());
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
            try {
                FileObject fileObject = FileHandlingFactory.getOrCreateFolder((URL)FileMovePlugin.this.refactoring.getTarget().lookup(URL.class));
                DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                if (!this.fo.isValid()) {
                    this.fo = FileUtil.toFileObject((File)FileUtil.toFile((FileObject)this.fo));
                }
                this.source = DataObject.find((FileObject)this.fo);
                this.sourceFolder = this.source.getFolder();
                this.source.move(dataFolder);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                dataObjectNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void undoChange() {
            try {
                this.source.move(this.sourceFolder);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                dataObjectNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.fo;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }
}

