/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import org.netbeans.modules.properties.PropertiesDataNode;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;

public final class Util {
    public static final String HELP_ID_PROPERTIES = "propfiles.prop";
    public static final String HELP_ID_CREATING = "propfiles.creating";
    public static final String HELP_ID_ADDING = "propfiles.adding";
    public static final String HELP_ID_MODIFYING = "propfiles.modifying";
    public static final String HELP_ID_ADDLOCALE = "propfiles.addlocale";
    public static final String HELP_ID_EDITLOCALE = "propfiles.editlocale";
    public static final char PRB_SEPARATOR_CHAR = '_';
    public static final int LABEL_FIRST_PART_LENGTH = 10;

    public static String stringToKey(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ':': 
                case '=': {
                    stringBuffer.append('_');
                    continue block3;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String assembleName(String string, String string2) {
        if (string2.length() == 0) {
            return string;
        }
        if (string2.charAt(0) != '_') {
            StringBuffer stringBuffer = new StringBuffer().append(string).append('_').append(string2);
            return stringBuffer.toString();
        }
        return string + string2;
    }

    public static String getLocaleSuffix(MultiDataObject.Entry entry) {
        MultiDataObject.Entry entry2 = entry.getDataObject().getPrimaryEntry();
        if (entry == entry2) {
            return "";
        }
        String string = entry.getFile().getName();
        String string2 = entry2.getFile().getName();
        assert (string.startsWith(string2));
        return string.substring(string2.length());
    }

    public static String getLanguage(String string) {
        return Util.getFirstPart(string);
    }

    public static String getCountry(String string) {
        if (string.length() == 0) {
            return null;
        }
        int n = string.indexOf(95, 1);
        return n != -1 ? Util.getFirstPart(string.substring(n)) : "";
    }

    public static String getVariant(String string) {
        if (string.length() == 0) {
            return null;
        }
        int n = string.indexOf(95, 1);
        if (n == -1) {
            return "";
        }
        return (n = string.indexOf(95, n + 1)) != -1 ? string.substring(n + 1) : "";
    }

    private static String getFirstPart(String string) {
        if (string.length() == 0) {
            return null;
        }
        assert (string.charAt(0) == '_');
        int n = string.indexOf(95, 1);
        return n != -1 ? string.substring(1, n) : string.substring(1);
    }

    public static String getLocaleLabel(MultiDataObject.Entry entry) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6 = Util.getLocaleSuffix(entry);
        if (string6.length() == 0) {
            string5 = "";
            string4 = "";
            string3 = "";
        } else {
            string5 = Util.getLanguage(string6);
            string4 = Util.getCountry(string6);
            string3 = Util.getVariant(string6);
            string5 = string5.length() != 0 ? string5 : "";
            string4 = string4.length() != 0 ? string4 : "";
            string3 = string3.length() != 0 ? string3 : "";
        }
        String string7 = null;
        if (string5 == "") {
            string7 = NbBundle.getMessage(Util.class, (String)"LAB_defaultLanguage");
        }
        if (string5 == "" && string4 == "" && string3 == "") {
            return string7;
        }
        String string8 = string6.substring(1);
        Locale locale = new Locale(string5, string4, string3);
        if (string5 == "") {
            string2 = string7;
        } else {
            string2 = locale.getDisplayLanguage();
            if (string2.equals(string5)) {
                string2 = NbBundle.getMessage(Util.class, (String)"LAB_unknownLanguage", (Object)string5);
            }
        }
        if (string4 == "" && string3 == "") {
            return NbBundle.getMessage(Util.class, (String)"LAB_localeSpecLang", (Object)string8, (Object)string2);
        }
        String string9 = "";
        if (string4 != "" && (string9 = locale.getDisplayCountry()).equals(string4)) {
            string9 = NbBundle.getMessage(Util.class, (String)"LAB_unknownCountry", (Object)string4);
        }
        String string10 = string = string3 == "" ? "" : locale.getDisplayVariant();
        String string11 = string == "" ? string9 : (string9 == "" ? string : string9 + ", " + string);
        return NbBundle.getMessage(Util.class, (String)"LAB_localeSpecLangCountry", (Object)string8, (Object)string2, (Object)string11);
    }

    private static void notifyError(String string) {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle(PropertiesDataNode.class).getString("MSG_LangExists"), string), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    public static PropertiesDataObject createPropertiesDataObject(FileObject fileObject, String string) throws IOException {
        Object object;
        int n = string.lastIndexOf(47);
        if (n > 0) {
            object = string.substring(0, n);
            fileObject = FileUtil.createFolder((FileObject)fileObject, (String)object);
            string = string.substring(n + 1);
        }
        object = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject2 = object.findResource("Templates/Other/properties.properties");
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        return (PropertiesDataObject)dataObject.createFromTemplate(DataFolder.findFolder((FileObject)fileObject), string);
    }

    public static void createLocaleFile(PropertiesDataObject propertiesDataObject, String string, boolean bl) {
        try {
            if (string.length() == 0) {
                Util.notifyError(string);
                return;
            }
            if (propertiesDataObject != null) {
                FileObject fileObject;
                FileObject fileObject2 = propertiesDataObject.getPrimaryFile();
                final String string2 = fileObject2.getName() + '_' + string;
                final FileObject fileObject3 = fileObject2.getParent();
                Iterator iterator = propertiesDataObject.secondaryEntries().iterator();
                while (iterator.hasNext()) {
                    fileObject = ((FileEntry)iterator.next()).getFile();
                    if (!string2.startsWith(fileObject.getName()) || fileObject.getName().length() <= fileObject2.getName().length()) continue;
                    fileObject2 = fileObject;
                }
                if (fileObject2.getName().equals(string2)) {
                    return;
                }
                if (!bl) {
                    fileObject = Repository.getDefault().getDefaultFileSystem();
                    fileObject2 = fileObject.findResource("Templates/Other/properties.properties");
                }
                fileObject = fileObject2;
                SaveCookie saveCookie = (SaveCookie)propertiesDataObject.getCookie(SaveCookie.class);
                if (saveCookie != null) {
                    saveCookie.save();
                }
                if (fileObject3.getFileObject(string2, "properties") == null) {
                    fileObject3.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                        public void run() throws IOException {
                            fileObject.copy(fileObject3, string2, "properties");
                        }
                    });
                }
            }
        }
        catch (IOException iOException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                iOException.printStackTrace();
            }
            Util.notifyError(string);
        }
    }
}

