/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.w3c.dom.Document;
import rex.graphics.ColumnTupleMemberLabel;
import rex.graphics.RowTupleMemberLabel;
import rex.graphics.tables.CellTable;
import rex.metadata.CubeSlicer;
import rex.metadata.ExecuteResult;
import rex.metadata.ServerMetadata;
import rex.metadata.resultelements.Tuple;
import rex.utils.AppColors;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;
import rex.xmla.XMLAExecuteProperties;
import rex.xmla.XMLAObjectsFactory;

public class CubeExplorer2
extends JPanel
implements LanguageChangedListener {
    CellTable ct;
    JSplitPane northSplitPane;
    JSplitPane southSplitPane;
    JScrollPane scrollPane;
    double divLoc;
    private ExecuteResult execResult;
    private JPanel columnsPane;
    private JPanel columnsResultPane;
    private JPanel rowsResultPane;
    private JPanel rowsPane;
    private CubeSlicer cubeSlicer;
    private JLabel btnCopyTable;
    private int cubeExplorerRowNumber;
    private boolean vScrollbarDisplayed;

    public CubeExplorer2(ExecuteResult _execResult, CubeSlicer _cubeSlicer, boolean showColumnTotalsOn, boolean showRowTotalsOn) {
        this.execResult = _execResult;
        this.cubeSlicer = _cubeSlicer;
        this.ct = new CellTable(this.execResult, this.cubeSlicer, this, showColumnTotalsOn, showRowTotalsOn);
        int rh = this.ct.getRowHeight();
        int rw = this.ct.getWidth() / this.ct.getColumnCount();
        this.columnsPane = new JPanel();
        this.columnsPane.setLayout(new BoxLayout(this.columnsPane, 0));
        this.columnsResultPane = this.execResult.getHorizontalTreePanel("Axis0", rw, rh, showRowTotalsOn);
        this.columnsPane.add(this.columnsResultPane);
        this.columnsPane.add(Box.createHorizontalGlue());
        this.cubeExplorerRowNumber = this.execResult.getAxis("Axis0").getHierarchyInfoCount();
        this.rowsPane = new JPanel();
        this.rowsPane.setOpaque(false);
        this.rowsPane.setLayout(new BoxLayout(this.rowsPane, 1));
        this.rowsResultPane = this.execResult.getVerticalTreePanel("Axis1", 40, rh, showColumnTotalsOn);
        this.rowsResultPane.setMaximumSize(new Dimension(Short.MAX_VALUE, this.execResult.getAxis("Axis1").getTupleCount() * rh));
        this.rowsPane.add(this.rowsResultPane);
        this.rowsPane.add(Box.createVerticalGlue());
        this.cubeExplorerRowNumber += this.execResult.getAxis("Axis1").getTupleCount();
        if (showColumnTotalsOn) {
            this.cubeExplorerRowNumber += 2;
        }
        this.btnCopyTable = new JLabel(S.getAppIcon("copy.gif"));
        this.btnCopyTable.setToolTipText(I18n.getString("toolTip.copyTable"));
        Dimension prefSize = new Dimension(this.execResult.getAxis("Axis1").getHierarchyInfoCount() * 40, this.execResult.getAxis("Axis0").getHierarchyInfoCount() * rh);
        this.btnCopyTable.setMinimumSize(prefSize);
        this.btnCopyTable.setMaximumSize(prefSize);
        this.btnCopyTable.setPreferredSize(prefSize);
        this.btnCopyTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                CubeExplorer2.this.copyTableToClipboard();
            }
        });
        this.northSplitPane = new JSplitPane(1, (Component)this.btnCopyTable, (Component)this.columnsPane){
            {
                this.setOpaque(false);
            }

            public void paintComponent(Graphics g) {
                S.paintBackground(g, this);
                super.paintComponent(g);
            }
        };
        this.northSplitPane.setContinuousLayout(false);
        this.northSplitPane.setOneTouchExpandable(true);
        this.northSplitPane.setDividerSize(3);
        this.northSplitPane.setOpaque(false);
        this.southSplitPane = new JSplitPane(1, (Component)this.rowsPane, (Component)this.ct){
            {
                this.setOpaque(false);
            }

            public void paintComponent(Graphics g) {
                S.paintBackground(g, this);
                super.paintComponent(g);
            }
        };
        this.southSplitPane.setContinuousLayout(false);
        this.southSplitPane.setOneTouchExpandable(true);
        this.southSplitPane.setDividerSize(3);
        this.southSplitPane.setOpaque(false);
        this.northSplitPane.setMaximumSize(new Dimension(Short.MAX_VALUE, this.execResult.getAxis("Axis0").getHierarchyInfoCount() * rh));
        this.northSplitPane.setMinimumSize(new Dimension(0, this.execResult.getAxis("Axis0").getHierarchyInfoCount() * rh));
        this.ct.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
                int w = CubeExplorer2.this.ct.getWidth() / CubeExplorer2.this.ct.getColumnCount();
                if (w * CubeExplorer2.this.ct.getColumnCount() != CubeExplorer2.this.ct.getWidth()) {
                    int reduce = CubeExplorer2.this.ct.getColumnCount() - CubeExplorer2.this.ct.getWidth() % CubeExplorer2.this.ct.getColumnCount();
                    CubeExplorer2.this.southSplitPane.setDividerLocation(CubeExplorer2.this.southSplitPane.getDividerLocation() - reduce);
                }
                CubeExplorer2.this.northSplitPane.setDividerLocation(CubeExplorer2.this.southSplitPane.getDividerLocation());
                CubeExplorer2.this.northSplitPane.invalidate();
                CubeExplorer2.this.northSplitPane.revalidate();
                CubeExplorer2.this.northSplitPane.repaint();
            }

            public void componentShown(ComponentEvent e) {
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        this.northSplitPane.setAlignmentX(0.5f);
        this.add(this.northSplitPane);
        this.scrollPane = new JScrollPane(this.southSplitPane);
        this.vScrollbarDisplayed = false;
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (CubeExplorer2.this.scrollPane.getViewport().getViewSize().getHeight() > CubeExplorer2.this.scrollPane.getViewport().getExtentSize().getHeight()) {
                    if (!CubeExplorer2.this.vScrollbarDisplayed) {
                        CubeExplorer2.this.vScrollbarDisplayed = true;
                        CubeExplorer2.this.columnsPane.add(Box.createRigidArea(new Dimension(15, 0)));
                    }
                } else if (CubeExplorer2.this.vScrollbarDisplayed) {
                    CubeExplorer2.this.vScrollbarDisplayed = false;
                    CubeExplorer2.this.columnsPane.removeAll();
                    CubeExplorer2.this.columnsPane.add(CubeExplorer2.this.columnsResultPane);
                    CubeExplorer2.this.columnsPane.add(Box.createHorizontalGlue());
                }
            }
        });
        this.add(this.scrollPane);
        this.add(Box.createVerticalGlue());
        this.setOpaque(true);
        this.setBorder(AppColors.CUBE_EXPLORER_BORDER);
        I18n.addOnLanguageChangedListener(this);
        this.applyI18n();
        this.setPrefferedDividerLocation();
    }

    public void copyTableToClipboard() {
        this.ct.copyTableToClipboard();
    }

    private double getPrefferedDividerLocation() {
        return this.divLoc;
    }

    public short getPrefferedHeight() {
        return (short)(this.ct.getRowHeight() * this.cubeExplorerRowNumber);
    }

    public void setPrefferedDividerLocation() {
        this.divLoc = Toolkit.getDefaultToolkit().getScreenSize().getWidth() - this.rowsPane.getMinimumSize().getWidth();
        this.divLoc *= (double)this.execResult.getAxis("Axis1").getHierarchyInfoCount() / (double)(this.execResult.getAxis("Axis1").getHierarchyInfoCount() + this.execResult.getAxis("Axis0").getTupleCount());
        this.southSplitPane.setDividerLocation((int)this.divLoc);
        this.northSplitPane.setDividerLocation((int)this.divLoc);
    }

    public void highlightRows(int rowNum, int colNum) {
        int i;
        Tuple t = this.execResult.getAxis("Axis1").getTupleAt(rowNum);
        int memberOrdinal = this.execResult.getAxis("Axis1").getHierarchyInfoCount();
        int levelsHighlighted = 0;
        for (i = 0; i < this.rowsResultPane.getComponentCount() && levelsHighlighted <= memberOrdinal; ++i) {
            if (!(this.rowsResultPane.getComponent(i) instanceof RowTupleMemberLabel)) continue;
            levelsHighlighted += ((RowTupleMemberLabel)this.rowsResultPane.getComponent(i)).setHighlight(t, memberOrdinal);
        }
        if (i < this.rowsResultPane.getComponentCount()) {
            while (i < this.rowsResultPane.getComponentCount()) {
                ((JLabel)this.rowsResultPane.getComponent(i)).setOpaque(false);
                ++i;
            }
        }
        this.rowsPane.revalidate();
        this.rowsPane.repaint();
    }

    public void highlightColumns(int rowNum, int colNum) {
        int i;
        Tuple t = this.execResult.getAxis("Axis0").getTupleAt(colNum);
        int memberOrdinal = this.execResult.getAxis("Axis0").getHierarchyInfoCount();
        int levelsHighlighted = 0;
        for (i = 0; i < this.columnsResultPane.getComponentCount() && levelsHighlighted <= memberOrdinal; ++i) {
            if (!(this.columnsResultPane.getComponent(i) instanceof ColumnTupleMemberLabel)) continue;
            levelsHighlighted += ((ColumnTupleMemberLabel)this.columnsResultPane.getComponent(i)).setHighlight(t, memberOrdinal);
        }
        if (i < this.columnsResultPane.getComponentCount()) {
            while (i < this.columnsResultPane.getComponentCount()) {
                ((JLabel)this.columnsResultPane.getComponent(i)).setOpaque(false);
                ++i;
            }
        }
        this.columnsResultPane.revalidate();
        this.columnsResultPane.repaint();
    }

    public void highlightRowsAndColumns(int rowNum, int colNum) {
        this.highlightRows(rowNum, colNum);
        this.highlightColumns(rowNum, colNum);
    }

    public void setShowColumnTotalsOn(boolean showColumnTotalsOn) {
        this.cubeExplorerRowNumber = showColumnTotalsOn ? (this.cubeExplorerRowNumber -= 2) : (this.cubeExplorerRowNumber += 2);
        this.ct.setShowColumnTotalsOn(showColumnTotalsOn);
        int rh = this.ct.getRowHeight();
        this.rowsResultPane = this.execResult.getVerticalTreePanel("Axis1", 40, rh, showColumnTotalsOn);
        S.out("execResult.getAxis(Axis1).getTupleCount()" + this.execResult.getAxis("Axis1").getTupleCount());
        this.rowsPane.removeAll();
        this.rowsResultPane.setMaximumSize(new Dimension(Short.MAX_VALUE, this.execResult.getAxis("Axis1").getTupleCount() * rh));
        this.rowsPane.add(this.rowsResultPane);
        this.rowsPane.add(Box.createVerticalGlue());
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    public void setShowRowTotalsOn(boolean showRowTotalsOn) {
        this.ct.setShowRowTotalsOn(showRowTotalsOn);
        int rh = this.ct.getRowHeight();
        int rw = this.ct.getWidth() / this.ct.getColumnCount();
        this.columnsPane.removeAll();
        this.columnsPane.add(this.execResult.getHorizontalTreePanel("Axis0", rw, rh, showRowTotalsOn));
        this.columnsPane.add(Box.createHorizontalGlue());
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    public static void main(String[] args) {
        ServerMetadata svm2 = new ServerMetadata("http://localhost:8080/mondrian/xmla");
        XMLAExecuteProperties properties2 = XMLAObjectsFactory.newXMLAExecuteProperties();
        properties2.setDataSourceInfo("FoodMartSource");
        properties2.setCatalog("Foodmart");
        try {
            Document d2 = svm2.execute("SELECT NON EMPTY{ {[Measures].Members}} ON COLUMNS,  NON EMPTY {[Promotions].[Promotion Name].Members} ON ROWS FROM Sales ", properties2);
            ExecuteResult r12 = new ExecuteResult(d2, null);
            CubeExplorer2 ceTest = new CubeExplorer2(r12, new CubeSlicer(1, 0), true, true);
            JFrame frame2 = new JFrame("Test CubeExplorer 2");
            frame2.setBackground(Color.GREEN);
            frame2.getContentPane().add((Component)ceTest, "Center");
            frame2.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame2.pack();
            frame2.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    public void applyI18n() {
        this.btnCopyTable.setToolTipText(I18n.getString("toolTip.copyTable"));
    }
}

