/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.indent.spi;

import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.netbeans.modules.editor.indent.IndentImpl;
import org.netbeans.modules.editor.indent.IndentSpiPackageAccessor;
import org.netbeans.modules.editor.indent.TaskHandler;
import org.netbeans.modules.editor.indent.api.IndentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Context {
    private TaskHandler.MimeItem mimeItem;

    Context(TaskHandler.MimeItem mimeItem) {
        this.mimeItem = mimeItem;
    }

    public Document document() {
        return this.mimeItem.handler().document();
    }

    public String mimePath() {
        return this.mimeItem.mimePath().getPath();
    }

    public int startOffset() {
        Position position = this.mimeItem.handler().startPos();
        return position != null ? position.getOffset() : -1;
    }

    public int endOffset() {
        Position position = this.mimeItem.handler().endPos();
        return position != null ? position.getOffset() : -1;
    }

    public int lineStartOffset(int n) throws BadLocationException {
        return IndentUtils.lineStartOffset(this.mimeItem.handler().document(), n);
    }

    public int lineIndent(int n) throws BadLocationException {
        return IndentUtils.lineIndent(this.mimeItem.handler().document(), n);
    }

    public void modifyIndent(int n, int n2) throws BadLocationException {
        char c;
        int n3;
        Document document = this.document();
        IndentImpl.checkOffsetInDocument(document, n);
        int n4 = 0;
        int n5 = -1;
        CharSequence charSequence = DocumentUtilities.getText((Document)document);
        for (n3 = n; n3 < charSequence.length() && (c = charSequence.charAt(n3)) != '\n'; ++n3) {
            if (c == '\t') {
                if (n5 == -1) {
                    n5 = IndentUtils.tabSize(document);
                }
                n4 = (n4 + n5) / n5 * n5;
                continue;
            }
            if (!Character.isWhitespace(c)) break;
            ++n4;
        }
        String string = IndentUtils.createIndentString(document, n2);
        int n6 = n;
        for (int i = 0; i < string.length() && n + i < n3; ++i) {
            if (string.charAt(i) == charSequence.charAt(n + i)) continue;
            n6 = n + i;
            string = string.substring(i);
            break;
        }
        if (n6 < n3) {
            document.remove(n6, n3 - n6);
        }
        if (string.length() > 0) {
            document.insertString(n6, string, null);
        }
    }

    public int caretOffset() {
        return this.mimeItem.handler().caretOffset();
    }

    public void setCaretOffset(int n) throws BadLocationException {
        this.mimeItem.handler().setCaretOffset(n);
    }

    public List<Region> indentRegions() {
        return this.mimeItem.indentRegions();
    }

    public boolean isIndent() {
        return this.mimeItem.handler().isIndent();
    }

    static {
        IndentSpiPackageAccessor.register(new PackageAccessor());
    }

    private static final class PackageAccessor
    extends IndentSpiPackageAccessor {
        private PackageAccessor() {
        }

        public Context createContext(TaskHandler.MimeItem mimeItem) {
            return new Context(mimeItem);
        }

        public Region createContextRegion(MutablePositionRegion mutablePositionRegion) {
            return new Region(mutablePositionRegion);
        }

        public MutablePositionRegion positionRegion(Region region) {
            return region.positionRegion();
        }
    }

    public static final class Region {
        MutablePositionRegion region;

        Region(MutablePositionRegion mutablePositionRegion) {
            this.region = mutablePositionRegion;
        }

        public int getStartOffset() {
            return this.region.getStartOffset();
        }

        public int getEndOffset() {
            return this.region.getEndOffset();
        }

        MutablePositionRegion positionRegion() {
            return this.region;
        }
    }
}

