/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionsList {
    private static final Logger LOG = Logger.getLogger(ActionsList.class.getName());
    private final List<Object> all;
    private final List<Action> actions;

    protected ActionsList(List<FileObject> list) {
        this(list, false);
    }

    protected ActionsList(List<FileObject> list, boolean bl) {
        Pair pair = ActionsList.convertImpl(list == null ? Collections.emptyList() : list, bl);
        this.all = pair.all;
        this.actions = pair.actions;
    }

    public List<Object> getAllInstances() {
        return this.all;
    }

    public List<Action> getActionsOnly() {
        return this.actions;
    }

    public static List<Object> convert(List<FileObject> list) {
        return ActionsList.convertImpl(list, (boolean)false).all;
    }

    private static Pair convertImpl(List<FileObject> list, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Action> arrayList2 = new ArrayList<Action>();
        for (FileObject fileObject : list) {
            Object e;
            Object object;
            block9: {
                DataObject dataObject;
                try {
                    dataObject = DataObject.find((FileObject)fileObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    continue;
                }
                object = null;
                InstanceCookie instanceCookie = (InstanceCookie)dataObject.getLookup().lookup(InstanceCookie.class);
                if (instanceCookie != null) {
                    try {
                        object = instanceCookie.instanceCreate();
                        break block9;
                    }
                    catch (Exception exception) {
                        LOG.log(Level.WARNING, "Can't instantiate object", exception);
                        continue;
                    }
                }
                object = dataObject instanceof DataFolder ? dataObject : dataObject.getName();
            }
            if (arrayList.size() > 0 && (Utilities.compareObjects(e = arrayList.get(arrayList.size() - 1), (Object)object) || ActionsList.isSeparator(e) && ActionsList.isSeparator(object))) continue;
            if (object instanceof Action) {
                arrayList2.add((Action)object);
            } else if (ActionsList.isSeparator(object)) {
                arrayList2.add(null);
            }
            arrayList.add(object);
        }
        Pair pair = new Pair();
        pair.all = arrayList.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(arrayList);
        pair.actions = arrayList2.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(arrayList2);
        return pair;
    }

    private static boolean isSeparator(Object object) {
        return object == null || object instanceof JSeparator;
    }

    private static class Pair {
        List<Object> all;
        List<Action> actions;

        private Pair() {
        }
    }
}

