/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.modules.editor.impl.actions.NavigationHistoryBackAction;
import org.netbeans.modules.editor.lib.NavigationHistory;
import org.openide.awt.DropDownButtonFactory;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public final class NavigationHistoryForwardAction
extends TextAction
implements ContextAwareAction,
Presenter.Toolbar,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(NavigationHistoryForwardAction.class.getName());
    private final JTextComponent component;
    private final NavigationHistory.Waypoint waypoint;
    private final JPopupMenu popupMenu;

    public NavigationHistoryForwardAction() {
        this(null, null, null);
    }

    private NavigationHistoryForwardAction(JTextComponent jTextComponent, NavigationHistory.Waypoint waypoint, String string) {
        super("jump-list-next");
        this.component = jTextComponent;
        this.waypoint = waypoint;
        if (waypoint != null) {
            this.putValue("Name", string);
            this.putValue("ShortDescription", NbBundle.getMessage(NavigationHistoryBackAction.class, (String)"NavigationHistoryForwardAction_Tooltip", (Object)string));
            this.popupMenu = null;
        } else if (jTextComponent != null) {
            this.putValue("SmallIcon", new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/editor/resources/navigate_forward_16.png")));
            this.popupMenu = new JPopupMenu();
            this.update();
            NavigationHistory navigationHistory = NavigationHistory.getNavigations();
            navigationHistory.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)navigationHistory));
        } else {
            this.popupMenu = null;
            this.putValue("ShortDescription", NbBundle.getMessage(NavigationHistoryForwardAction.class, (String)"NavigationHistoryForwardAction_Tooltip_simple"));
        }
    }

    public Action createContextAwareInstance(Lookup lookup) {
        JTextComponent jTextComponent = NavigationHistoryBackAction.findComponent(lookup);
        return new NavigationHistoryForwardAction(jTextComponent, null, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        NavigationHistory.Waypoint waypoint;
        NavigationHistory navigationHistory = NavigationHistory.getNavigations();
        NavigationHistory.Waypoint waypoint2 = waypoint = this.waypoint != null ? navigationHistory.navigateTo(this.waypoint) : navigationHistory.navigateForward();
        if (waypoint != null) {
            NavigationHistoryBackAction.show(waypoint);
        }
    }

    public Component getToolbarPresenter() {
        if (this.popupMenu != null) {
            JButton jButton = DropDownButtonFactory.createDropDownButton((Icon)((ImageIcon)this.getValue("SmallIcon")), (JPopupMenu)this.popupMenu);
            jButton.putClientProperty("hideActionText", Boolean.TRUE);
            jButton.setAction(this);
            return jButton;
        }
        return new JButton(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.update();
    }

    private void update() {
        String string;
        List list = NavigationHistory.getNavigations().getNextWaypoints();
        if (this.popupMenu != null) {
            this.popupMenu.removeAll();
            int n = 0;
            string = null;
            NavigationHistory.Waypoint waypoint = null;
            for (int i = 0; i < list.size(); ++i) {
                NavigationHistory.Waypoint waypoint2 = (NavigationHistory.Waypoint)list.get(i);
                String string2 = NavigationHistoryBackAction.getWaypointName(waypoint2);
                if (string2 == null) continue;
                if (string == null || !string2.equals(string)) {
                    if (string != null) {
                        this.popupMenu.add(new NavigationHistoryForwardAction(this.component, waypoint, n > 1 ? string + ":" + n : string));
                    }
                    string = string2;
                    waypoint = waypoint2;
                    n = 1;
                    continue;
                }
                ++n;
            }
            if (string != null) {
                this.popupMenu.add(new NavigationHistoryForwardAction(this.component, waypoint, n > 1 ? string + ":" + n : string));
            }
        }
        if (!list.isEmpty()) {
            NavigationHistory.Waypoint waypoint = (NavigationHistory.Waypoint)list.get(0);
            string = NavigationHistoryBackAction.getWaypointName(waypoint);
            if (string != null) {
                this.putValue("ShortDescription", NbBundle.getMessage(NavigationHistoryForwardAction.class, (String)"NavigationHistoryForwardAction_Tooltip", (Object)string));
            } else {
                this.putValue("ShortDescription", NbBundle.getMessage(NavigationHistoryForwardAction.class, (String)"NavigationHistoryForwardAction_Tooltip_simple"));
            }
            this.setEnabled(true);
        } else {
            this.putValue("ShortDescription", NbBundle.getMessage(NavigationHistoryForwardAction.class, (String)"NavigationHistoryForwardAction_Tooltip_simple"));
            this.setEnabled(false);
        }
    }
}

