/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom.wrappers;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.wrappers.W3CDOMWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

abstract class GenericDOMParser
implements ErrorHandler,
Parser {
    StringWriter errorBuffer = null;
    PrintWriter errorOut = null;
    protected Document document;
    static final String LOAD_EXTERNAL_DTD_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";

    GenericDOMParser() {
    }

    public DOMWrapper create(String string) {
        Element element = this.document.createElement(string);
        return new W3CDOMWrapper(element);
    }

    public DOMWrapper parse(InputStream inputStream) throws XOMException {
        InputSource inputSource = new InputSource(inputStream);
        Document document = this.parseInputSource(inputSource);
        return new W3CDOMWrapper(document.getDocumentElement());
    }

    public DOMWrapper parse(String string) throws XOMException {
        return this.parse(new StringReader(string));
    }

    public DOMWrapper parse(Reader reader) throws XOMException {
        Document document = this.parseInputSource(new InputSource(reader));
        return new W3CDOMWrapper(document.getDocumentElement());
    }

    protected abstract Document parseInputSource(InputSource var1) throws XOMException;

    public void warning(SAXParseException sAXParseException) {
        this.errorOut.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) {
        this.errorOut.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.errorOut.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        throw sAXParseException;
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    public DOMWrapper parse(URL uRL) throws XOMException {
        try {
            return this.parse(new BufferedInputStream(uRL.openStream()));
        }
        catch (IOException iOException) {
            throw new XOMException(iOException, "Document parse failed");
        }
    }

    protected void prepareParse() {
        this.errorBuffer = new StringWriter();
        this.errorOut = new PrintWriter(this.errorBuffer);
    }

    protected void handleErrors() throws XOMException {
        this.errorOut.flush();
        String string = this.errorBuffer.toString();
        if (string.length() > 0) {
            throw new XOMException("Document parse failed: " + string);
        }
    }
}

