/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.standalone.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.standalone.actions.RecentFileAction;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecentFiles {
    private static final Object HISTORY_LOCK = new Object();
    private static List<String> history = new ArrayList<String>();
    private static final int MAX_HISTORY_ITEMS = 20;
    private static boolean inited = false;

    private RecentFiles() {
    }

    public static synchronized void init() {
        if (!inited) {
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = HISTORY_LOCK;
                    synchronized (object) {
                        String s = IReportManager.getPreferences().get("RecentFiles", null);
                        if (s != null) {
                            String[] files = s.split("\n");
                            for (int i = 0; i < files.length; ++i) {
                                history.add(files[i]);
                            }
                        }
                        RecentFiles.checkHistory();
                    }
                    TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)new WindowRegistryL());
                }
            });
        }
    }

    public static List<String> getRecentFiles() {
        return history;
    }

    static void storeHistory() {
        String historyString = "";
        int i = 0;
        for (String hItem : history) {
            if (i > 20) break;
            historyString = historyString + hItem + "\n";
        }
        IReportManager.getPreferences().put("RecentFiles", historyString);
    }

    private static void addFile(TopComponent tc) {
        URL fileURL;
        if (tc instanceof CloneableTopComponent && (fileURL = RecentFiles.obtainURL(tc)) != null) {
            String hItem = fileURL.toExternalForm();
            history.remove(hItem);
            history.add(0, hItem);
        }
    }

    public static URL obtainURL(TopComponent tc) {
        FileObject fo;
        DataObject dObj = (DataObject)tc.getLookup().lookup(DataObject.class);
        if (dObj != null && (fo = dObj.getPrimaryFile()) != null) {
            return RecentFiles.convertFile2URL(fo);
        }
        return null;
    }

    static URL convertFile2URL(FileObject fo) {
        URL url = URLMapper.findURL((FileObject)fo, (int)1);
        if (url == null) {
            Logger.getLogger(RecentFiles.class.getName()).log(Level.FINE, "convertFile2URL: URL can't be found for FileObject " + fo);
        }
        return url;
    }

    static FileObject convertURL2File(URL url) {
        FileObject fo = URLMapper.findFileObject((URL)url);
        if (fo == null) {
            Logger.getLogger(RecentFiles.class.getName()).log(Level.FINE, "convertURL2File: File can't be found for URL " + url);
        }
        return fo;
    }

    private static void checkHistory() {
        ArrayList<String> invalidEntries = new ArrayList<String>();
        FileObject fo = null;
        for (String historyItem : history) {
            try {
                fo = RecentFiles.convertURL2File(new URL(historyItem));
                if (fo != null && fo.isValid()) continue;
                invalidEntries.add(historyItem);
            }
            catch (Exception ex) {
                invalidEntries.add(historyItem);
            }
        }
        for (String historyItem : invalidEntries) {
            history.remove(historyItem);
        }
    }

    private static class WindowRegistryL
    implements PropertyChangeListener {
        private WindowRegistryL() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("tcOpened".equals(evt.getPropertyName())) {
                final TopComponent tc = (TopComponent)evt.getNewValue();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RecentFiles.addFile(tc);
                        RecentFiles.storeHistory();
                        if (RecentFileAction.getInstance() != null) {
                            RecentFileAction.getInstance().updateSubMenu();
                        }
                    }
                });
            }
        }
    }
}

