/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder;

import java.awt.Component;
import javax.swing.tree.DefaultMutableTreeNode;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.syntax.QueryExpression;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;
import nickyb.sqleonardo.querybuilder.syntax.SubQuery;

public abstract class BrowserItems {

    static class ClauseTreeItem
    extends DefaultTreeItem {
        ClauseTreeItem(String label) {
            super(label);
        }

        void onDropPerformed(QueryBuilder builder) {
            if (this.toString().indexOf("SELECT") != -1) {
                this.refreshSelectList(builder);
            } else if (this.toString().indexOf("WHERE") != -1) {
                this.refreshWhereClause(builder);
            } else if (this.toString().indexOf("GROUP BY") != -1) {
                this.refreshGroupByClause(builder);
            } else if (this.toString().indexOf("HAVING") != -1) {
                this.refreshHavingClause(builder);
            } else if (this.toString().indexOf("ORDER BY") != -1) {
                this.refreshOrderByClause(builder);
            }
        }

        private void refreshSelectList(QueryBuilder builder) {
            int i;
            QueryTokens._Expression[] tokens = builder.browser.getQuerySpecification().getSelectList();
            for (i = 0; i < tokens.length; ++i) {
                builder.browser.getQuerySpecification().removeSelectList(tokens[i]);
            }
            for (i = 0; i < this.getChildCount(); ++i) {
                DefaultTreeItem item = (DefaultTreeItem)this.getChildAt(i);
                QueryTokens._Expression token = item instanceof AbstractQueryTreeItem ? (SubQuery)((AbstractQueryTreeItem)item).getQueryExpression() : (QueryTokens._Expression)item.getUserObject();
                builder.browser.getQuerySpecification().addSelectList(token);
            }
        }

        private void refreshWhereClause(QueryBuilder builder) {
            int i;
            QueryTokens.Condition[] tokens = builder.browser.getQuerySpecification().getWhereClause();
            for (i = 0; i < tokens.length; ++i) {
                builder.browser.getQuerySpecification().removeWhereClause(tokens[i]);
            }
            for (i = 0; i < this.getChildCount(); ++i) {
                DefaultTreeItem item = (DefaultTreeItem)this.getChildAt(i);
                QueryTokens.Condition token = item instanceof ConditionQueryTreeItem ? ((ConditionQueryTreeItem)item).getCondition() : (QueryTokens.Condition)item.getUserObject();
                builder.browser.getQuerySpecification().addWhereClause(token);
                if (i == 0) {
                    token.setAppend(null);
                    continue;
                }
                if (token.getAppend() != null) continue;
                token.setAppend("AND");
            }
        }

        private void refreshGroupByClause(QueryBuilder builder) {
            int i;
            QueryTokens.Group[] tokens = builder.browser.getQuerySpecification().getGroupByClause();
            for (i = 0; i < tokens.length; ++i) {
                builder.browser.getQuerySpecification().removeGroupByClause(tokens[i]);
            }
            for (i = 0; i < this.getChildCount(); ++i) {
                DefaultTreeItem item = (DefaultTreeItem)this.getChildAt(i);
                QueryTokens.Group token = (QueryTokens.Group)item.getUserObject();
                builder.browser.getQuerySpecification().addGroupByClause(token);
            }
        }

        private void refreshHavingClause(QueryBuilder builder) {
            int i;
            QueryTokens.Condition[] tokens = builder.browser.getQuerySpecification().getHavingClause();
            for (i = 0; i < tokens.length; ++i) {
                builder.browser.getQuerySpecification().removeHavingClause(tokens[i]);
            }
            for (i = 0; i < this.getChildCount(); ++i) {
                DefaultTreeItem item = (DefaultTreeItem)this.getChildAt(i);
                QueryTokens.Condition token = (QueryTokens.Condition)item.getUserObject();
                builder.browser.getQuerySpecification().addHavingClause(token);
                if (i == 0) {
                    token.setAppend(null);
                    continue;
                }
                if (token.getAppend() != null) continue;
                token.setAppend("AND");
            }
        }

        private void refreshOrderByClause(QueryBuilder builder) {
            int i;
            QueryTokens.Sort[] tokens = builder.getModel().getOrderByClause();
            for (i = 0; i < tokens.length; ++i) {
                builder.getModel().removeOrderByClause(tokens[i]);
            }
            for (i = 0; i < this.getChildCount(); ++i) {
                DefaultTreeItem item = (DefaultTreeItem)this.getChildAt(i);
                QueryTokens.Sort token = (QueryTokens.Sort)item.getUserObject();
                builder.getModel().addOrderByClause(token);
            }
        }
    }

    static class FromTreeItem
    extends DefaultTreeItem {
        private Component[] diagramObjects = null;

        FromTreeItem() {
            super("FROM");
        }

        Component[] getDiagramObjects() {
            return this.diagramObjects;
        }

        void setDiagramObjects(Component[] c) {
            this.diagramObjects = c;
        }

        void setSelected(boolean b) {
            String label = "FROM";
            if (b) {
                label = "[ " + label + " ]";
            }
            this.setUserObject(label);
        }
    }

    static class TableTreeItem
    extends DefaultTreeItem {
        private int joins;

        TableTreeItem(Object userObject) {
            super(userObject);
        }

        boolean isJoined() {
            return this.joins > 0;
        }

        void joined() {
            ++this.joins;
        }

        void unjoined() {
            --this.joins;
        }
    }

    static class UnionQueryTreeItem
    extends AbstractQueryTreeItem {
        UnionQueryTreeItem(QueryExpression qe) {
            super("UNION", qe);
        }
    }

    static class QueryTreeItem
    extends AbstractQueryTreeItem {
        QueryTreeItem(String label, QueryExpression qe) {
            super(label, qe);
        }
    }

    static class ConditionQueryTreeItem
    extends AbstractQueryTreeItem {
        private QueryTokens.Condition token;

        ConditionQueryTreeItem(QueryTokens.Condition token) {
            super("SUBQUERY", (SubQuery)token.getRight());
            this.token = token;
        }

        boolean isQueryToken() {
            return true;
        }

        QueryTokens.Condition getCondition() {
            return this.token;
        }

        public String toString() {
            String label = this.token.getAppend() == null ? new String() : this.token.getAppend() + ' ';
            label = label + (this.token.getLeft() == null ? new String() : this.token.getLeft().toString() + ' ');
            label = label + this.token.getOperator() + ' ';
            label = "" + label + " (SUBQUERY)";
            return label;
        }
    }

    static abstract class AbstractQueryTreeItem
    extends DefaultTreeItem {
        private QueryExpression qe;

        AbstractQueryTreeItem(String label, QueryExpression qe) {
            super(label);
            this.qe = qe;
            if (qe.getQuerySpecification().getQuantifier() == 2) {
                this.add(new ClauseTreeItem("SELECT DISTINCT"));
            } else {
                this.add(new ClauseTreeItem("SELECT"));
            }
            this.add(new FromTreeItem());
            this.add(new ClauseTreeItem("WHERE"));
            this.add(new ClauseTreeItem("GROUP BY"));
            this.add(new ClauseTreeItem("HAVING"));
        }

        QueryExpression getQueryExpression() {
            return this.qe;
        }
    }

    static class DefaultTreeItem
    extends DefaultMutableTreeNode {
        DefaultTreeItem(Object userObject) {
            super(userObject);
        }

        DefaultTreeItem addChild(Object userObject) {
            DefaultTreeItem child = new DefaultTreeItem(userObject);
            this.add(child);
            return child;
        }

        DefaultTreeItem findChild(Object userObject) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                DefaultTreeItem child = (DefaultTreeItem)this.getChildAt(i);
                if (!child.getUserObject().toString().equals(userObject.toString())) continue;
                return child;
            }
            return null;
        }

        boolean isQueryToken() {
            return this.getUserObject() instanceof QueryTokens._Base;
        }

        boolean hasChild(Object userObject) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                if (this.findChild(userObject) == null) continue;
                return true;
            }
            return false;
        }

        boolean hasChild(DefaultTreeItem item) {
            return this.hasChild(item.getUserObject());
        }

        void removeChild(Object userObject) {
            DefaultTreeItem child = this.findChild(userObject);
            if (child != null) {
                this.remove(child);
            }
        }
    }
}

